/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.sorting;

import com.excentis.products.byteblower.gui.swt.sorting.AlphanumComparator;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.NetworkAddress;
import com.excentis.products.byteblower.model.reader.NetworkAddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.Calendar;
import java.util.Comparator;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public abstract class ByteBlowerComparator
extends ViewerComparator
implements Comparator<Object> {
    int column;
    AlphanumComparator alphanumericComparator;
    protected Direction direction;
    private ColumnViewer columnViewer;

    public ByteBlowerComparator(ColumnViewer columnViewer) {
        this.columnViewer = columnViewer;
        this.alphanumericComparator = new AlphanumComparator();
        this.column = 0;
        this.direction = Direction.OFF;
    }

    public void initialize(int column, Direction direction) {
        this.column = column;
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void toggleSortingColumn(int column) {
        if (column == this.column) {
            if (this.direction == Direction.ASCENDING) {
                this.direction = Direction.DESCENDING;
            } else if (this.direction == Direction.DESCENDING) {
                this.direction = Direction.OFF;
            } else if (this.direction == Direction.OFF) {
                this.direction = Direction.ASCENDING;
            }
        } else {
            this.column = column;
            this.direction = Direction.ASCENDING;
        }
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (this.direction == Direction.OFF) {
            return 0;
        }
        int column = this.getColumn();
        int comparison = this.compare(arg0, arg1, column);
        if (comparison > 0) {
            comparison = 1;
        } else if (comparison < 0) {
            comparison = -1;
        }
        if (this.direction == Direction.DESCENDING) {
            comparison = this.flip(comparison);
        }
        return comparison;
    }

    private int flip(int comparison) {
        if (comparison == 1) {
            return -1;
        }
        if (comparison == -1) {
            return 1;
        }
        return 0;
    }

    public abstract boolean isDynamic();

    public boolean isEnabled() {
        return this.direction != Direction.OFF;
    }

    protected int compare(Object arg0, Object arg1, int column) {
        String value0 = null;
        String value1 = null;
        IBaseLabelProvider baseLabelProvider = this.columnViewer.getLabelProvider();
        if (baseLabelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider provider = (ITableLabelProvider)baseLabelProvider;
            value0 = provider.getColumnText(arg0, column);
            value1 = provider.getColumnText(arg1, column);
        }
        return this.compareValues(value0, value1);
    }

    protected int compareValues(Object value0, Object value1) {
        if (value0 instanceof String && value1 instanceof String) {
            return this.alphanumericComparator.compare((String)value0, (String)value1);
        }
        if (value0 instanceof Boolean && value1 instanceof Boolean) {
            Boolean comp0 = (Boolean)value0;
            Boolean comp1 = (Boolean)value1;
            return comp0.compareTo(comp1);
        }
        if (value0 instanceof Integer && value1 instanceof Integer) {
            Integer comp0 = (Integer)value0;
            Integer comp1 = (Integer)value1;
            return comp0.compareTo(comp1);
        }
        if (value0 instanceof Long && value1 instanceof Long) {
            Long comp0 = (Long)value0;
            Long comp1 = (Long)value1;
            return comp0.compareTo(comp1);
        }
        if (value0 instanceof Float && value1 instanceof Float) {
            Float comp0 = (Float)value0;
            Float comp1 = (Float)value1;
            return comp0.compareTo(comp1);
        }
        if (value0 instanceof Enumerator && value1 instanceof Enumerator) {
            String comp0 = ((Enumerator)value0).getLiteral();
            String comp1 = ((Enumerator)value1).getLiteral();
            return comp0.compareTo(comp1);
        }
        if (value0 instanceof NetworkAddress && value1 instanceof NetworkAddress) {
            NetworkAddress comp0 = (NetworkAddress)value0;
            NetworkAddress comp1 = (NetworkAddress)value1;
            NetworkAddressReader reader0 = (NetworkAddressReader)ReaderFactory.create((EByteBlowerObject)comp0);
            NetworkAddressReader reader1 = (NetworkAddressReader)ReaderFactory.create((EByteBlowerObject)comp1);
            return reader0.compareTo(reader1);
        }
        if (value0 instanceof HighResolutionCalendar && value1 instanceof HighResolutionCalendar) {
            HighResolutionCalendar cal0 = (HighResolutionCalendar)value0;
            HighResolutionCalendar cal1 = (HighResolutionCalendar)value1;
            return cal0.compareTo((Calendar)cal1);
        }
        System.out.println(" WARNING : unsupported sorting column : " + this.column + " - " + value0);
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING,
        OFF;

    }
}

