/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ByteBlowerViewerEditorActivationStrategy {
    public static ColumnViewerEditorActivationStrategy reClickActivation(ColumnViewer viewer) {
        return new ReClickStrategy(viewer);
    }

    public static int getFeature() {
        return 59;
    }

    private static final class ReClickStrategy
    extends ColumnViewerEditorActivationStrategy {
        private Object lastTable = new Object();
        private List<Object> previouslySelectedRows = Collections.emptyList();

        private ReClickStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        private List<Object> getSelected(Table table) {
            ArrayList<Object> selected = new ArrayList<Object>();
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem row = tableItemArray[n2];
                selected.add(row);
                ++n2;
            }
            return selected;
        }

        private List<Object> getSelected(Tree tree) {
            ArrayList<Object> selected = new ArrayList<Object>();
            TreeItem[] treeItemArray = tree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem row = treeItemArray[n2];
                selected.add(row);
                ++n2;
            }
            return selected;
        }

        private List<Object> getSelected(Object uiElement) {
            if (uiElement instanceof Tree) {
                return this.getSelected((Tree)uiElement);
            }
            if (uiElement instanceof Table) {
                return this.getSelected((Table)uiElement);
            }
            return Collections.emptyList();
        }

        private boolean sameList(List<Object> first, List<Object> second) {
            boolean same = first.size() == second.size();
            int ctr = 0;
            while (same && ctr < first.size()) {
                same = first.get(ctr) == second.get(ctr) && same;
                ++ctr;
            }
            return same;
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean result = false;
            Object source = event.sourceEvent.getSource();
            List<Object> selectedRows = this.getSelected(source);
            switch (event.eventType) {
                case 3: 
                case 4: 
                case 5: {
                    result = true;
                    break;
                }
                case 1: {
                    if (event.keyCode != 13) break;
                    result = true;
                    break;
                }
                case 2: {
                    if (((MouseEvent)event.sourceEvent).button != 1 || !this.lastTable.equals(source)) break;
                    result = this.sameList(this.previouslySelectedRows, selectedRows);
                }
            }
            this.lastTable = source;
            this.previouslySelectedRows = this.getSelected(source);
            return result;
        }
    }
}

