/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DoubleTextFactory {
    private static DoubleTextFactory instance = null;

    public static DoubleTextFactory instance() {
        if (instance == null) {
            instance = new DoubleTextFactory();
        }
        return instance;
    }

    public Text create(Composite parent, int style, int maxDigitsAfterComma, double maxValue) {
        Text newItem = new Text(parent, style);
        InputVerifcation verify = new InputVerifcation(maxDigitsAfterComma, maxValue);
        newItem.addListener(25, (Listener)verify);
        return newItem;
    }

    public Text create(Composite parent, int style, final int maxDigitsAfterComma) {
        Text newItem = new Text(parent, style);
        newItem.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                int digitsAfterComma;
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                int dot1 = result.indexOf(".");
                int dot2 = result.lastIndexOf(".");
                if (dot1 != -1 && dot2 != dot1) {
                    e.doit = false;
                    return;
                }
                char[] chars = new char[result.length()];
                result.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (('0' > chars[i] || chars[i] > '9') && chars[i] != '.') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                if (dot1 != -1 && (digitsAfterComma = result.length() - dot1 - 1) > maxDigitsAfterComma) {
                    e.doit = false;
                    return;
                }
            }
        });
        return newItem;
    }

    private static class InputVerifcation
    implements Listener {
        private final int maxDigitsAfterComma;
        private final double maxValue;

        private InputVerifcation(int maxDigitsAfterComma) {
            this.maxDigitsAfterComma = maxDigitsAfterComma;
            this.maxValue = Double.MAX_VALUE;
        }

        private InputVerifcation(int maxDigitsAfterComma, double maxValue) {
            this.maxDigitsAfterComma = maxDigitsAfterComma;
            this.maxValue = maxValue;
        }

        public void handleEvent(Event e) {
            int digitsAfterComma;
            Text t = (Text)e.widget;
            String previous = t.getText();
            String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
            int dot1 = result.indexOf(".");
            int dot2 = result.lastIndexOf(".");
            if (dot1 != -1 && dot2 != dot1) {
                e.doit = false;
                return;
            }
            char[] chars = new char[result.length()];
            result.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if (('0' > chars[i] || chars[i] > '9') && chars[i] != '.') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            if (dot1 != -1 && (digitsAfterComma = result.length() - dot1 - 1) > this.maxDigitsAfterComma) {
                e.doit = false;
                return;
            }
            if (result.isEmpty()) {
                return;
            }
            try {
                Double value = new Double(result);
                if (value > this.maxValue) {
                    String newValue = Double.toString(this.maxValue);
                    e.doit = false;
                    t.setText(newValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    }
}

