/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class HexTextFactory {
    private static final Color red = new Color(null, 255, 0, 0);

    private HexTextFactory() {
    }

    public static Text create(Composite parent, int style, int textLimitArg) {
        final String formatString = "%0" + textLimitArg + "X";
        final Text newItem = new Text(parent, style);
        newItem.setTextLimit(textLimitArg);
        newItem.setText(String.format(formatString, 0));
        newItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text widget = (Text)e.widget;
                if (HexTextFactory.checkComplete(widget)) {
                    widget.setForeground(null);
                } else {
                    widget.setForeground(red);
                }
            }
        });
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
                e.doit = HexTextFactory.isHexString(e.text);
            }
        });
        newItem.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent event) {
                try {
                    Integer value = Integer.parseInt(newItem.getText(), 16);
                    newItem.setText(String.format(formatString, value));
                }
                catch (NumberFormatException numberFormatException) {}
            }

            public void focusGained(FocusEvent event) {
            }
        });
        return newItem;
    }

    private static boolean isHexString(String text) {
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!HexTextFactory.isValidCharachter(ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidCharachter(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    public static boolean checkComplete(Text text) {
        return text.getText().length() == text.getTextLimit();
    }
}

