/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.update;

import com.excentis.products.byteblower.gui.update.Activator;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

class P2Util {
    P2Util() {
    }

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        Activator.log(1, "P2: Checking for updates");
        ProvisioningSession session = new ProvisioningSession(agent);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for updates...", (int)200);
        UpdateOperation operation = new UpdateOperation(session);
        Activator.log(1, "P2: >> resolving update process...");
        IStatus resolveStatus = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        Activator.log(1, "P2: >> update resolve status: " + resolveStatus.toString());
        return resolveStatus;
    }

    static IStatus installUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        Activator.log(1, "P2: Installing updates");
        ProvisioningSession session = new ProvisioningSession(agent);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Installing updates...", (int)200);
        UpdateOperation operation = new UpdateOperation(session);
        Activator.log(1, "P2: >> resolving update process...");
        IStatus resolveStatus = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        Activator.log(1, "P2: >> update resolve status " + resolveStatus.toString());
        if (!resolveStatus.isOK()) {
            return resolveStatus;
        }
        ProvisioningJob job = operation.getProvisioningJob(monitor);
        Activator.log(1, "P2: >> running update process...");
        IStatus runStatus = job.runModal((IProgressMonitor)sub.newChild(100));
        Activator.log(1, "P2: >> update run status: " + runStatus.toString());
        return runStatus;
    }

    static boolean addRepository(IProvisioningAgent agent, String repo) {
        Activator.log(1, "P2: Adding repository " + repo);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (metadataManager == null) {
            Activator.log(4, "P2: >> error: metadata manager is null");
            return false;
        }
        if (artifactManager == null) {
            Activator.log(4, "P2: >> error: artifact manager is null");
            return false;
        }
        try {
            URI uri = new URI(repo);
            metadataManager.addRepository(uri);
            artifactManager.addRepository(uri);
            return true;
        }
        catch (Exception e) {
            Activator.log(4, "P2: >> error: an error occured while adding repository" + e.getLocalizedMessage());
            return false;
        }
    }
}

