/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.views.realtime.Activator;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.HTTPServer;
import java.util.concurrent.TimeUnit;

public class PrometheusState
implements ByteBlowerPreferences.SimpleChangeListener {
    private static final String[] TRAFFIC_LABELS = new String[]{"flow", "direction", "port"};
    private static final String[] OOS_LABELS = new String[]{"flow", "port"};
    private static final String[] LATENCY_LABELS = new String[]{"flow", "source", "destination", "latency_type"};
    private static final String LATENCY_TYPE_ONE_WAY = "one_way";
    private HTTPServer server;
    private final Gauge trafficThroughput = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build((String)"bbgui_scenario_throughput", (String)"[DEPRECATED] The current throughput of a flow").unit("bytes")).labelNames(TRAFFIC_LABELS)).register();
    private final Counter trafficBytes = (Counter)((Counter.Builder)((Counter.Builder)Counter.build((String)"byteblower_gui_traffic", (String)"Total number of bytes sent or received").unit("bytes")).labelNames(TRAFFIC_LABELS)).register();
    private final Gauge avgLatencyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build((String)"byteblower_gui_latency_average", (String)"Average latency of a flow").unit("seconds")).labelNames(LATENCY_LABELS)).register();
    private final Gauge minLatencyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build((String)"byteblower_gui_latency_minimum", (String)"Minimum latency of a flow").unit("seconds")).labelNames(LATENCY_LABELS)).register();
    private final Gauge maxLatencyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build((String)"byteblower_gui_latency_maximum", (String)"Maximum latency of a flow").unit("seconds")).labelNames(LATENCY_LABELS)).register();
    private final Gauge jitLatencyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build((String)"byteblower_gui_latency_jitter", (String)"Latency jitter of a flow").unit("seconds")).labelNames(LATENCY_LABELS)).register();
    private final Counter oosCounter = (Counter)((Counter.Builder)((Counter.Builder)Counter.build((String)"byteblower_gui_out_of_sequence", (String)"Total number of packets that arrived out-of-sequence").unit("packets")).labelNames(OOS_LABELS)).register();
    private final String prometheusFamily = "byteblower_gui_";
    private long lastScrape = 0L;

    public PrometheusState() {
        this.ensureStart();
        ByteBlowerPreferences.addListener((ByteBlowerPreferences.SimpleChangeListener)this);
    }

    public void ensureStop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    public STATE getState() {
        if (this.server == null) {
            return STATE.OFFLINE;
        }
        if (System.currentTimeMillis() - this.lastScrape < TimeUnit.MINUTES.toMillis(1L)) {
            return STATE.SCRAPED;
        }
        return STATE.AVAILABLE;
    }

    public void ensureStart() {
        if (this.server == null) {
            int tcpPortNumber = ByteBlowerPreferences.getOpenMetricsPort();
            this.lastScrape = 0L;
            try {
                this.server = new HTTPServer.Builder().withPort(tcpPortNumber).withSampleNameFilter(name -> {
                    this.lastScrape = System.currentTimeMillis();
                    return true;
                }).build();
                String msg = String.format("Starting Openmetrics on TCP port %d %n", tcpPortNumber);
                Activator.logToRCP(msg);
            }
            catch (Exception e) {
                String msg = "Can not create HTTPServer for Opermtrics on TCP port " + tcpPortNumber;
                Activator.logToRCP(msg, e);
            }
        }
    }

    public void restart() {
        this.trafficBytes.clear();
        this.trafficThroughput.clear();
        this.avgLatencyGauge.clear();
        this.minLatencyGauge.clear();
        this.maxLatencyGauge.clear();
        this.jitLatencyGauge.clear();
        this.oosCounter.clear();
    }

    void setTrafficGauge(String flowName, TRAFFIC_DIRECTION direction, String clientName, double byteCount) {
        Gauge.Child ctr = (Gauge.Child)this.trafficThroughput.labels(new String[]{flowName, direction.toString(), clientName});
        ctr.set(byteCount);
    }

    void incrementTrafficCounter(String flowName, TRAFFIC_DIRECTION direction, String clientName, long increasedBytes) throws NegativeValue {
        if (increasedBytes < 0L) {
            throw new NegativeValue();
        }
        Counter.Child ctr = (Counter.Child)this.trafficBytes.labels(new String[]{flowName, direction.toString(), clientName});
        ctr.inc((double)increasedBytes);
    }

    void incrementOOSCounter(String flowName, String clientName, long increasedPackets) throws NegativeValue {
        if (increasedPackets < 0L) {
            throw new NegativeValue();
        }
        ((Counter.Child)this.oosCounter.labels(new String[]{flowName, clientName})).inc((double)increasedPackets);
    }

    public void setOneWayLatency(String flowName, String txPortName, String rxPortName, double avg, double min, double max, double jit) {
        ((Gauge.Child)this.avgLatencyGauge.labels(new String[]{flowName, txPortName, rxPortName, LATENCY_TYPE_ONE_WAY})).set(avg);
        ((Gauge.Child)this.minLatencyGauge.labels(new String[]{flowName, txPortName, rxPortName, LATENCY_TYPE_ONE_WAY})).set(min);
        ((Gauge.Child)this.maxLatencyGauge.labels(new String[]{flowName, txPortName, rxPortName, LATENCY_TYPE_ONE_WAY})).set(max);
        ((Gauge.Child)this.jitLatencyGauge.labels(new String[]{flowName, txPortName, rxPortName, LATENCY_TYPE_ONE_WAY})).set(jit);
    }

    public void preferenceChanged() {
        int freshTcpConfig;
        int startedTcpPort = this.server != null ? this.server.getPort() : Integer.MAX_VALUE;
        if (startedTcpPort != (freshTcpConfig = ByteBlowerPreferences.getOpenMetricsPort())) {
            String msg = String.format("Changing Openmetrics TCP port from %d to %d %n", startedTcpPort, freshTcpConfig);
            Activator.logToRCP(msg);
            this.ensureStop();
            this.ensureStart();
        }
    }

    public static class NegativeValue
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum STATE {
        SCRAPED,
        AVAILABLE,
        OFFLINE;


        static STATE faulty() {
            return OFFLINE;
        }
    }

    public static enum TRAFFIC_DIRECTION {
        rx,
        tx;

    }
}

