/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.TestManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.Test;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestStatus;
import java.util.ArrayList;
import java.util.List;

class RealtimeDataHandle {
    private final long testDataPersistenceId;
    private final String scenarioName;
    private final ByteBlowerProject runningModelProject;
    private final TestDataPersistenceController tdpc;

    RealtimeDataHandle(String scenarioName, long testDataPersistenceId, ByteBlowerProject runningModelProject) throws Exception {
        this.testDataPersistenceId = testDataPersistenceId;
        this.scenarioName = scenarioName;
        this.runningModelProject = runningModelProject;
        this.tdpc = TestDataPersistenceController.getInstance((Long)testDataPersistenceId);
    }

    public ByteBlowerProject getRunningModelProject() {
        return this.runningModelProject;
    }

    public long getTestDataPersistenceId() {
        return this.testDataPersistenceId;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public Test getTest() throws TestDataPersistenceError {
        return new TestManager(this.tdpc).find();
    }

    public ScenarioStatus getScenarioStatus() throws TestDataPersistenceError {
        Scenario currentScenario = new ScenarioManager(this.tdpc).find(this.scenarioName);
        if (currentScenario == null) {
            return ScenarioStatus.CREATED;
        }
        return currentScenario.getStatus();
    }

    public TestStatus getTestStatus() throws TestDataPersistenceError {
        Test test = this.getTest();
        if (test == null) {
            return null;
        }
        return test.getStatus();
    }

    public List<Port> getPorts() throws TestDataPersistenceError {
        return new PortManager(this.tdpc).getEntities();
    }

    public Scenario getScenario() throws TestDataPersistenceError {
        return new ScenarioManager(this.tdpc).find(this.scenarioName);
    }

    public List<FlowInstance> getFlowInstances() throws TestDataPersistenceError {
        Scenario scenario = new ScenarioManager(this.tdpc).find(this.scenarioName);
        if (scenario == null) {
            return new ArrayList<FlowInstance>();
        }
        return scenario.getFlowInstances();
    }

    public List<ThroughputFlowTest> getThroughputTests() {
        List tests = new BaseEntityManager(ThroughputFlowTest.class, this.tdpc).getEntities();
        return tests;
    }

    public List<Server> getServers() {
        List servers = new BaseEntityManager(Server.class, this.tdpc).getEntities();
        return servers;
    }
}

