/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.gui.views.realtime.RealtimeDataHandle;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.runner.jobs.ExecuteScenarioJob;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class RealtimeUpdater
implements Runnable {
    private static final long IDLE_SLEEP = 10000L;
    private final long resultsIntervalMs;
    private AtomicBoolean stopUpdating = new AtomicBoolean(false);
    private AtomicReference<ExecuteScenarioJob> activeScenarioJob;
    private final CopyOnWriteArrayList<RealtimeUpdateListener> listeners = new CopyOnWriteArrayList();
    private final Object waitObject = new Object();

    RealtimeUpdater(long resultsIntervalMs) {
        this.activeScenarioJob = new AtomicReference();
        this.resultsIntervalMs = resultsIntervalMs;
        GuiRunner runner = GuiRunner.getInstance();
        ScenarioRunTrigger trigger = new ScenarioRunTrigger(runner);
        runner.addListener((GuiRunner.ActiveJobListener)trigger);
        trigger.activeScenarioJobChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIdleObject() {
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecuteScenarioJob scenarioJob = null;
        RealtimeDataHandle dataHandle = null;
        while (!this.stopUpdating.get()) {
            long start = System.currentTimeMillis();
            scenarioJob = this.activeScenarioJob.get();
            if (scenarioJob == null) {
                dataHandle = null;
            } else {
                Long testDataPersistenceId = scenarioJob.getTestDataPersistenceId();
                if (testDataPersistenceId != null) {
                    try {
                        String scenarioName = scenarioJob.getScenarioName();
                        ByteBlowerProject runningModelProject = scenarioJob.getRunningModelProject();
                        dataHandle = new RealtimeDataHandle(scenarioName, testDataPersistenceId, runningModelProject);
                    }
                    catch (Exception e) {
                        Logger logger = Logger.getGlobal();
                        logger.log(Level.SEVERE, "Could not create datahandle for active project", e);
                        dataHandle = null;
                    }
                }
            }
            this.updateRealtimeData(dataHandle);
            long notifyDuration = System.currentTimeMillis() - start;
            long sleepTime = scenarioJob == null ? 10000L : this.resultsIntervalMs - notifyDuration;
            try {
                if (sleepTime <= 0L) continue;
                Object object = this.waitObject;
                synchronized (object) {
                    if (this.activeScenarioJob.get() == scenarioJob) {
                        this.waitObject.wait(sleepTime);
                    }
                }
            }
            catch (InterruptedException e) {
                Logger logger = Logger.getGlobal();
                logger.log(Level.INFO, "Realtime updater interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    void stopUpdating() {
        this.stopUpdating.set(true);
        this.notifyIdleObject();
    }

    /*
     * Unable to fully structure code
     */
    private void updateRealtimeData(RealtimeDataHandle dataHandle) {
        block4: {
            try {
                for (RealtimeUpdateListener listener : this.listeners) {
                    listener.dataUpdated(dataHandle);
                }
                break block4;
            }
            catch (Exception t) {
                logger = Logger.getGlobal();
                logger.log(Level.SEVERE, "problem notifiying others", t);
                ** for (listener : this.listeners)
            }
lbl-1000:
            // 1 sources

            {
                listener.dataError(t);
                continue;
            }
        }
    }

    void addListener(RealtimeUpdateListener listener) {
        this.listeners.add(listener);
        this.notifyIdleObject();
    }

    void removeListener(RealtimeUpdateListener listener) {
        this.listeners.remove(listener);
    }

    public static interface RealtimeUpdateListener {
        public void dataUpdated(RealtimeDataHandle var1);

        public void dataError(Throwable var1);
    }

    private final class ScenarioRunTrigger
    implements GuiRunner.ActiveJobListener {
        private final GuiRunner runner;

        public ScenarioRunTrigger(GuiRunner runner) {
            this.runner = runner;
        }

        public void activeScenarioJobChanged() {
            ExecuteScenarioJob job = this.runner.getActiveScenarioJob();
            RealtimeUpdater.this.activeScenarioJob.set(job);
            RealtimeUpdater.this.notifyIdleObject();
        }

        public void activeScenarioPaused(GuiRunner.Resumer resume) {
        }

        public void activeScenarioResumed() {
        }
    }
}

