/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.gui.swt.actions.RedoAction;
import com.excentis.products.byteblower.gui.swt.actions.UndoAction;
import com.excentis.products.byteblower.gui.views.realtime.Activator;
import com.excentis.products.byteblower.gui.views.realtime.PrometheusGraphicalStatus;
import com.excentis.products.byteblower.gui.views.realtime.RealtimeDataHandle;
import com.excentis.products.byteblower.gui.views.realtime.RealtimeUpdater;
import com.excentis.products.byteblower.gui.views.realtime.composites.RealtimeFlowsComposite;
import com.excentis.products.byteblower.gui.views.realtime.composites.RealtimePortsComposite;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestStatus;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class RealtimeView
extends ViewPart
implements RealtimeUpdater.RealtimeUpdateListener {
    static final String ID = "com.excentis.products.byteblower.gui.views.RealtimeView";
    private ILog logger = Platform.getLog((Bundle)Activator.getDefault().getBundle());
    private String bundleName = Activator.getDefault().getBundle().getSymbolicName();
    private Composite parent;
    private RealtimePortsComposite portsComposite;
    private RealtimeFlowsComposite flowsComposite;
    private Label statusTitleLabel;
    private Label statusLabel;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private String errorString = "";
    private boolean isUpdating = false;
    private RealtimeDataHandle latestDataHandle;

    public void createPartControl(Composite parent) {
        Activator.getDefault().getRealtimeUpdater().addListener(this);
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        Composite labelComposite = new Composite(parent, 0);
        labelComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        SashForm viewerSashFormComposite = new SashForm(parent, 512);
        viewerSashFormComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        labelComposite.setLayout((Layout)new GridLayout(3, false));
        this.statusTitleLabel = new Label(labelComposite, 0);
        this.statusTitleLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.statusLabel = new Label(labelComposite, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite prometheusArea = new Composite(labelComposite, 0);
        this.createPrometheusNotification(prometheusArea);
        this.portsComposite = new RealtimePortsComposite((Composite)viewerSashFormComposite);
        this.flowsComposite = new RealtimeFlowsComposite((Composite)viewerSashFormComposite);
        viewerSashFormComposite.setWeights(new int[]{1, 1});
        this.statusTitleLabel.setText("Status: ");
        this.statusLabel.setText("Idle (no scenario running)");
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    private void createPrometheusNotification(Composite prometheusNotification) {
        prometheusNotification.setLayout((Layout)new RowLayout());
        PrometheusGraphicalStatus.buildUI(prometheusNotification);
    }

    public void dispose() {
        Activator.getDefault().getRealtimeUpdater().removeListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.flowsComposite.setFocus();
    }

    @Override
    public void dataUpdated(RealtimeDataHandle dataHandle) {
        this.latestDataHandle = dataHandle;
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        ArrayList<Port> ports = new ArrayList<Port>();
        ArrayList<FlowInstance> flows = new ArrayList<FlowInstance>();
        if (dataHandle != null && dataHandle.getPorts() != null) {
            ports.addAll(dataHandle.getPorts());
        }
        if (dataHandle != null) {
            flows.addAll(dataHandle.getFlowInstances());
        }
        ArrayList<ThroughputFlowTest> throughputTests = new ArrayList<ThroughputFlowTest>();
        if (dataHandle != null) {
            throughputTests.addAll(dataHandle.getThroughputTests());
        }
        Display.getDefault().asyncExec((Runnable)new UIUpdate(dataHandle, ports, flows, throughputTests));
    }

    @Override
    public void dataError(final Throwable t) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RealtimeView.this.statusLabel.isDisposed() || RealtimeView.this.portsComposite.isDisposed() || RealtimeView.this.flowsComposite.isDisposed()) {
                    return;
                }
                RealtimeView.this.errorString = "\n Error displaying realtime results: " + t.getMessage() + RealtimeView.this.errorString;
                RealtimeView.this.statusLabel.setText("Error occured!" + RealtimeView.this.errorString);
                RealtimeView.this.parent.layout(new Control[]{RealtimeView.this.statusLabel});
            }
        });
    }

    private final class UIUpdate
    implements Runnable {
        private final RealtimeDataHandle dataHandle;
        private final List<Port> ports;
        private final List<FlowInstance> flows;
        private final List<ThroughputFlowTest> throughputTests;

        private UIUpdate(RealtimeDataHandle dataHandle, List<Port> ports, List<FlowInstance> flows, List<ThroughputFlowTest> throughputTests) {
            this.dataHandle = dataHandle;
            this.ports = ports;
            this.flows = flows;
            this.throughputTests = throughputTests;
        }

        @Override
        public void run() {
            TestStatus status;
            block18: {
                block17: {
                    block16: {
                        if (!RealtimeView.this.statusLabel.isDisposed() && !RealtimeView.this.portsComposite.isDisposed() && !RealtimeView.this.flowsComposite.isDisposed()) break block16;
                        RealtimeView.this.isUpdating = false;
                        if (this.dataHandle != RealtimeView.this.latestDataHandle) {
                            RealtimeView.this.dataUpdated(RealtimeView.this.latestDataHandle);
                        }
                        return;
                    }
                    if (this.dataHandle != null) break block17;
                    this.resetTestDisplay();
                    RealtimeView.this.isUpdating = false;
                    if (this.dataHandle != RealtimeView.this.latestDataHandle) {
                        RealtimeView.this.dataUpdated(RealtimeView.this.latestDataHandle);
                    }
                    return;
                }
                status = this.dataHandle.getTestStatus();
                if (status != null) break block18;
                this.resetTestDisplay();
                RealtimeView.this.isUpdating = false;
                if (this.dataHandle != RealtimeView.this.latestDataHandle) {
                    RealtimeView.this.dataUpdated(RealtimeView.this.latestDataHandle);
                }
                return;
            }
            try {
                try {
                    String statusString;
                    switch (status) {
                        case CREATED: 
                        case INITIALIZING: 
                        case INITIALIZED: 
                        case RUNNING: 
                        case CLEANUP: {
                            statusString = "active";
                            break;
                        }
                        case FINISHED: 
                        case CANCELLED: 
                        case ERROR: {
                            RealtimeView.this.errorString = "";
                            statusString = status.toString().toLowerCase();
                            break;
                        }
                        default: {
                            statusString = "not yet ready";
                        }
                    }
                    RealtimeView.this.statusLabel.setText("Scenario '" + this.dataHandle.getScenarioName() + "' " + statusString + RealtimeView.this.errorString);
                    ScenarioStatus scStatus = this.dataHandle.getScenarioStatus();
                    RealtimeView.this.portsComposite.setEnabled(true);
                    RealtimeView.this.portsComposite.updateInput(scStatus, this.ports);
                    RealtimeView.this.flowsComposite.setEnabled(true);
                    RealtimeView.this.flowsComposite.updateInput(scStatus, this.flows, this.throughputTests, this.dataHandle.getRunningModelProject());
                }
                catch (Exception e) {
                    RealtimeView.this.logger.log((IStatus)new Status(4, RealtimeView.this.bundleName, 0, "Error while updating the realtime view", (Throwable)e));
                }
            }
            finally {
                RealtimeView.this.isUpdating = false;
                if (this.dataHandle != RealtimeView.this.latestDataHandle) {
                    RealtimeView.this.dataUpdated(RealtimeView.this.latestDataHandle);
                }
            }
        }

        private void resetTestDisplay() {
            RealtimeView.this.errorString = "";
            RealtimeView.this.statusLabel.setText("No scenario active");
            RealtimeView.this.portsComposite.resetInput();
            RealtimeView.this.portsComposite.setEnabled(false);
            RealtimeView.this.flowsComposite.resetInput();
            RealtimeView.this.flowsComposite.setEnabled(false);
        }
    }
}

