/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.solution;

import com.excentis.products.byteblower.gui.history.operations.status.ByteBlowerStatusContainer;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.views.solution.Activator;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerStatusWrapper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;
import org.osgi.framework.Version;

public class ByteBlowerStatusHandler
extends WorkbenchErrorHandler {
    private boolean checkedOnce = false;

    public void handle(StatusAdapter statusAdapter, int style) {
        IStatus status = statusAdapter.getStatus();
        if (status instanceof ByteBlowerStatusWrapper) {
            this.handleByteBlowerStatus((ByteBlowerStatusWrapper)status);
        } else {
            super.handle(statusAdapter, style);
        }
    }

    private void handleByteBlowerStatus(ByteBlowerStatusWrapper wrapper) {
        ByteBlowerStatusContainer statusRoot = ByteBlowerStatusContainer.getInstance();
        if (wrapper.isNew()) {
            statusRoot.addStatus(wrapper);
        } else {
            statusRoot.removeStatus(wrapper);
        }
        this.presentSolutionView();
    }

    private void presentSolutionView() {
        if (this.checkedOnce) {
            return;
        }
        this.checkedOnce = true;
        Version solutionVersion = new Version(2, 7, 0);
        Version version = Activator.getDefault().getBundle().getVersion();
        if (version.compareTo(solutionVersion) < 1 && ByteBlowerPreferences.getShowSolutionView()) {
            ByteBlowerPreferences.setShowSolutionView((boolean)false);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        IWorkbenchPage activePage = win.getActivePage();
                        activePage.showView("com.excentis.products.byteblower.gui.views.SolutionView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

