/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.solution.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.status.ByteBlowerStatusContainer;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.jump.ViewJumper;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerBasicTreeComposite;
import com.excentis.products.byteblower.gui.views.solution.composites.RootCauseFilter;
import com.excentis.products.byteblower.gui.views.solution.composites.SolutionComparator;
import com.excentis.products.byteblower.gui.views.solution.composites.SolutionTreeViewer;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.status.model.ByteBlowerStatus;
import java.awt.Desktop;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class SolutionComposite
extends ByteBlowerBasicTreeComposite<EObject>
implements IDoubleClickListener {
    private ViewJumper jumper;
    private ToolBar toolbar;
    private ToolItem itemExpandAll;
    private ToolItem itemCollapseAll;
    private Button showRootCausesOnly;
    RootCauseFilter rootCauseFilter;
    private Image itemExpandAllImage = null;
    private Image itemExpandAllDisabledImage = null;
    private Image itemCollapseAllImage = null;
    private Image itemCollapseAllDisabledImage = null;
    private static final String[] columnNames = new String[]{"Description"};
    private static final int[] columnWeights = new int[]{1};

    public String[] getColumnNames() {
        return columnNames;
    }

    public int[] getColumnWeights() {
        return columnWeights;
    }

    public SolutionComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, ViewJumper jumper) {
        super(parent, "SolutionComposite", actionInterface, focusDispatcher, null);
        this.jumper = jumper;
    }

    public void selectAndReveal(EObject object) {
        EByteBlowerObjectReader reader;
        if (object instanceof EByteBlowerObject && (reader = ReaderFactory.create((EByteBlowerObject)((EByteBlowerObject)object))).hasNoRootCauses() && this.rootCauseFilter.isShowRootCausesOnly()) {
            this.asyncExec(() -> this.asyncReveal(object));
            return;
        }
        this.getTreeViewer().expandToLevel((Object)object, 1);
        super.selectAndReveal((Object)object);
    }

    private void asyncReveal(EObject object) {
        this.setShowRootCausesOnly(false);
        this.getTreeViewer().expandToLevel((Object)object, 1);
        super.selectAndReveal((Object)object);
    }

    public Object getInitialInput() {
        return ByteBlowerStatusContainer.getInstance();
    }

    public void projectOpenedOrClosed(ByteBlowerProject project) {
    }

    protected void afterInitialization() {
        ByteBlowerStatusContainer.getInstance().addAdapter((Adapter)new ChangeAdapter());
        super.afterInitialization();
    }

    protected void initializeChildClass() {
    }

    protected String getTreeLabel() {
        return this.getOverviewString();
    }

    private String getOverviewString() {
        boolean onlyRootCauses = this.showRootCausesOnly.getSelection();
        return ByteBlowerStatusContainer.getInstance().getOverviewString(onlyRootCauses);
    }

    protected ByteBlowerPopupMenu createPopupMenu() {
        return null;
    }

    protected int createTopWidgets() {
        int nofWidgets = this.createRootCauseFilter();
        return nofWidgets += this.createToolbar();
    }

    private int createRootCauseFilter() {
        this.showRootCausesOnly = new Button((Composite)this, 32);
        this.showRootCausesOnly.setText("Show root causes only");
        this.showRootCausesOnly.addSelectionListener((SelectionListener)this);
        return 1;
    }

    protected void initializeBasicChildListeners() {
    }

    protected void updateCustomWidgets(boolean enable) {
    }

    protected ByteBlowerNewAction createNewAction() {
        return null;
    }

    protected ByteBlowerCutAction createCutAction() {
        return null;
    }

    protected ByteBlowerCopyAction createCopyAction() {
        return null;
    }

    protected ByteBlowerPasteAction createPasteAction() {
        return null;
    }

    protected ByteBlowerDeleteAction createDeleteAction() {
        return null;
    }

    public int getFirstSelectedIndex() {
        return 0;
    }

    protected Class getParentClass() {
        return null;
    }

    public void updateWidgets() {
        if (this.itemExpandAll.isDisposed()) {
            return;
        }
        this.getLabel().setText(this.getOverviewString());
        boolean isExpandable = this.treeIsExpandable();
        this.showRootCausesOnly.setSelection(ByteBlowerPreferences.getShowRootCausesOnly());
        this.showRootCausesOnly.setEnabled(isExpandable);
        this.itemExpandAll.setEnabled(isExpandable);
        this.itemCollapseAll.setEnabled(isExpandable);
        super.updateWidgets();
    }

    private boolean treeIsExpandable() {
        return !ByteBlowerStatusContainer.getInstance().isEmpty();
    }

    protected TreeViewer createTreeViewer() {
        SolutionTreeViewer viewer = new SolutionTreeViewer(this);
        viewer.setComparator(new SolutionComparator());
        this.rootCauseFilter = new RootCauseFilter();
        this.rootCauseFilter.setShowRootCausesOnly(ByteBlowerPreferences.getShowRootCausesOnly());
        viewer.setFilters(new ViewerFilter[]{this.rootCauseFilter});
        viewer.addDoubleClickListener(this);
        return viewer;
    }

    public static boolean openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean openWebpage(URL url) {
        try {
            return SolutionComposite.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (event.getSource() == treeViewer) {
            ITreeSelection sel = (ITreeSelection)treeViewer.getSelection();
            Object selectedObject = sel.getFirstElement();
            if (selectedObject instanceof ByteBlowerStatus) {
                EObject item;
                ByteBlowerStatus status = (ByteBlowerStatus)selectedObject;
                if (status.getCauseStatuses().isEmpty()) {
                    item = status.getItem();
                } else {
                    ByteBlowerStatus firstCause = (ByteBlowerStatus)status.getCauseStatuses().get(0);
                    item = firstCause.getItem();
                    this.selectAndReveal(item);
                }
                this.jump((EByteBlowerObject)item);
                try {
                    String helpUrl = status.getHelpUrl();
                    if (helpUrl != null) {
                        URL url = new URL(helpUrl);
                        SolutionComposite.openWebpage(url);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (selectedObject instanceof EByteBlowerObject) {
                this.jump((EByteBlowerObject)selectedObject);
            }
            if (selectedObject == null) {
                return;
            }
            boolean toggle = treeViewer.getExpandedState(selectedObject);
            if (toggle) {
                treeViewer.collapseToLevel(selectedObject, 1);
            } else {
                treeViewer.expandToLevel(selectedObject, 1);
            }
        }
    }

    private void jump(EByteBlowerObject object) {
        this.jumper.jump((EObject)object);
    }

    private Image createImage(String img) {
        ImageDescriptor imageDescr = ImageDescriptor.createFromFile(ImageCache.class, (String)img);
        return imageDescr.createImage();
    }

    private int createToolbar() {
        this.toolbar = new ToolBar((Composite)this, 256);
        this.itemExpandAll = new ToolItem(this.toolbar, 0);
        this.itemExpandAllImage = this.createImage("config/e_expandall.gif");
        this.itemExpandAll.setImage(this.itemExpandAllImage);
        this.itemExpandAllDisabledImage = this.createImage("config/d_expandall.gif");
        this.itemExpandAll.setDisabledImage(this.itemExpandAllDisabledImage);
        this.itemExpandAll.setToolTipText("Expand All");
        this.itemExpandAll.addSelectionListener((SelectionListener)this);
        this.itemCollapseAll = new ToolItem(this.toolbar, 0);
        this.itemCollapseAllImage = this.createImage("config/e_collapseall.gif");
        this.itemCollapseAll.setImage(this.itemCollapseAllImage);
        this.itemCollapseAllDisabledImage = this.createImage("config/d_collapseall.gif");
        this.itemCollapseAll.setDisabledImage(this.itemCollapseAllDisabledImage);
        this.itemCollapseAll.setToolTipText("Collapse All");
        this.itemCollapseAll.addSelectionListener((SelectionListener)this);
        return 2;
    }

    private void collapseAll() {
        this.getTreeViewer().collapseAll();
    }

    private void expandAll() {
        this.getTreeViewer().expandAll();
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.itemExpandAll) {
            this.expandAll();
        } else if (widget == this.itemCollapseAll) {
            this.collapseAll();
        } else if (widget == this.showRootCausesOnly) {
            boolean show = this.showRootCausesOnly.getSelection();
            this.asyncExec(() -> this.setShowRootCausesOnly(show));
        }
        super.widgetSelected(event);
    }

    private void setShowRootCausesOnly(boolean show) {
        this.showRootCausesOnly.setSelection(show);
        ByteBlowerPreferences.setShowRootCausesOnly((boolean)show);
        this.rootCauseFilter.setShowRootCausesOnly(show);
        this.getTreeViewer().refresh();
        this.updateWidgets();
    }

    protected CellEditor[] createCellEditors() {
        return null;
    }

    protected ICellModifier getCellModifier() {
        return null;
    }

    private class ChangeAdapter
    implements Adapter {
        private ChangeAdapter() {
        }

        public void notifyChanged(Notification msg) {
            SolutionComposite.this.asyncExec(() -> SolutionComposite.this.updateWidgets());
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }
}

