/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.utils.StyledStringBuilder;
import com.excentis.products.byteblower.gui.views.Activator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class OnboardingExcentisCloudDialog
extends MessageDialog {
    private static final String TITLE_MSG = "Introducing Excentis Cloud!";
    private static final String BUTTON_0_MSG = "Close";
    private static final String BUTTON_1_MSG = "Have a Peek";
    private static final int CLOUD_CONNECT_IDX = 1;
    private static final String DONT_SHOW = "Don't show again.";
    private static final String SIGNUP_URL = "https://www.excentis.com/insights/byteblower-report-cloud";

    private OnboardingExcentisCloudDialog(Shell parentShell) {
        super(parentShell, TITLE_MSG, null, null, 0, 1, new String[]{BUTTON_0_MSG, BUTTON_1_MSG});
    }

    public static void run() {
        if (ByteBlowerPreferences.showCloudOnboarding()) {
            Display display = Display.getDefault();
            display.asyncExec(OnboardingExcentisCloudDialog::launchUI);
        }
    }

    protected Control createCustomArea(Composite parent) {
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)new GridLayout(1, true));
        this.buildImage(row);
        this.buildIntroText(row);
        this.buildCheckbox(row);
        return parent;
    }

    private void buildCheckbox(Composite row) {
        final Button hideNextTime = new Button(row, 32);
        hideNextTime.setText(DONT_SHOW);
        hideNextTime.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean shouldHide = hideNextTime.getSelection();
                ByteBlowerPreferences.setCloudShowOnboarding((!shouldHide ? 1 : 0) != 0);
                Activator.log(String.format("Hiding Excentis cloud = %s", shouldHide));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void buildImage(Composite row) {
        Image image = ImageCache.getImageFromString((String)"icons/excentis_cloud.png");
        Label imLabel = new Label(row, 128);
        imLabel.setImage(image);
    }

    private void buildIntroText(Composite row) {
        StyledStringBuilder builder = new StyledStringBuilder();
        builder.append("\n");
        builder.append("COMING SOON", StyledStringBuilder.FontStyle.BOLD);
        builder.append("\n");
        builder.append("\n");
        builder.append("\u2022 ");
        builder.append("Automatically upload", StyledStringBuilder.FontStyle.BOLD);
        builder.append(" test results to the cloud\n");
        builder.append("\u2022 ");
        builder.append("New and improved ");
        builder.append("ByteBlower Cloud Reports", StyledStringBuilder.FontStyle.BOLD);
        builder.append("\n");
        builder.append("\u2022 ");
        builder.append("Combine & Compare", StyledStringBuilder.FontStyle.BOLD);
        builder.append(" reports");
        builder.append("\n");
        StyledText text = new StyledText(row, 0);
        text.setText(builder.toString());
        text.setStyleRanges(builder.styles());
        text.setEditable(false);
        text.setEnabled(false);
        text.setForeground(row.getForeground());
        text.setBackground(row.getBackground());
    }

    private static void launchUI() {
        Display display = Display.getCurrent();
        Logger logger = Logger.getGlobal();
        if (display == null) {
            String msg = "Unexpected launch: the onboarding dialog must be called in the UI thread.";
            logger.warning(msg);
            return;
        }
        Shell shell = display.getActiveShell();
        if (shell == null || shell.isDisposed()) {
            String msg = "Application closed before showing Onboarding dialog";
            logger.info(msg);
            return;
        }
        OnboardingExcentisCloudDialog dialog = new OnboardingExcentisCloudDialog(shell);
        int result = dialog.open();
        if (result == 1) {
            OnboardingExcentisCloudDialog.connectUser();
        }
    }

    private static void connectUser() {
        try {
            IWebBrowser vv = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            URL target = URI.create(SIGNUP_URL).toURL();
            vv.openURL(target);
        }
        catch (MalformedURLException e) {
            Logger.getGlobal().log(Level.SEVERE, "Malformed target URL to sign up the user.", e);
        }
        catch (PartInitException e) {
            Logger.getGlobal().log(Level.SEVERE, "UI Platform can't open external website. Not able to sign up the user.", e);
        }
    }
}

