/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.GeneratedReportsComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

class DeleteSelectedTestResults
extends ByteBlowerDeleteAction<TestDataReference> {
    private GeneratedReportsComposite reportsComposite;

    public DeleteSelectedTestResults(ByteBlowerViewerComposite<TestDataReference> composite) {
        super("Test Result", "Test Results", composite);
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete Test Results", (String)"All selected test results will be deleted. Are you sure ?")) {
            List selection = this.getSelectedObjects();
            for (TestDataReference ref : selection) {
                TestDataReferenceController.create(ref).delete();
            }
            this.composite.getNewAction().update();
            this.composite.hardRefresh();
            this.reportsComposite.updateComposite();
        }
    }

    public void update() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        for (TestDataReference ref : selection) {
            if (!TestDataReferenceController.create(ref).filesExist()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void setGeneratedReportsComposite(GeneratedReportsComposite composite) {
        this.reportsComposite = composite;
    }
}

