/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.actions.IEnablementChangedListener;
import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerBasicTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.views.archive.actions.NewReportAction;
import com.excentis.products.byteblower.gui.views.archive.actions.OpenProjectAction;
import com.excentis.products.byteblower.gui.views.archive.composites.ChangeRunTitleDialog;
import com.excentis.products.byteblower.gui.views.archive.composites.DeleteSelectedTestResults;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenarioLabelProvider;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenariosComparator;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenariosPopupMenu;
import com.excentis.products.byteblower.gui.views.archive.composites.FilterOperation;
import com.excentis.products.byteblower.gui.views.archive.composites.ReportComparator;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceError;
import com.excentis.products.byteblower.results.dataprovider.data.TestDataReferenceManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Tag;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import com.excentis.products.byteblower.results.dataprovider.generator.MetaDataPersistenceGenerationError;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Test;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ExecutedScenariosComposite
extends ByteBlowerBasicTableComposite<TestDataReference>
implements TestDataReference.PostPersistListener,
ModifyListener,
IDoubleClickListener {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final String PREOPEN_TEXT = "Opening project ..";
    private static final String SUCCESS_OPEN_TEXT = "Success..";
    private static final String FAILED_OPEN_TEXT = "Failed to open..";
    private static final String DEFAULT_BACKUPBUTTON_TEXT = "Open Project Backup";
    private static final String FILTER_TOOLTIP = "Filter on any field or tag visible below.\nFor example: \"TCP*Finished\"";
    private Text filterText;
    private Button openBackupButton;
    private Button deleteButton;
    private TestDataReferenceManager testDataReferenceManager;
    private TestDataReference selectedTestDataReference;
    private OpenProjectAction openBackupAction = new OpenProjectAction();

    public ExecutedScenariosComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "ExecutedScenariosComposite", actionInterface, focusDispatcher, (ITableLabelProvider)new ExecutedScenarioLabelProvider());
        this.initializeChildClass();
        TestDataReference.addPostPersistListener((TestDataReference.PostPersistListener)this);
        ByteBlowerTableViewer tableViewer = this.getTableViewer();
        tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        tableViewer.initializeComparator(0, ByteBlowerComparator.Direction.DESCENDING);
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer viewer) {
        return new ExecutedScenariosComparator(viewer);
    }

    public void dispose() {
        TestDataReference.removePostPersistListener((TestDataReference.PostPersistListener)this);
        super.dispose();
    }

    private void updateInput(TestDataReference entity) {
        if (!this.isDisposed()) {
            List<TestDataReference> refs = this.getTestDataReferences(entity);
            this.setInput(refs);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ExecutedScenariosComposite.this.filterText.isDisposed()) {
                        ExecutedScenariosComposite.this.filterText.setText("");
                    }
                }
            });
        }
    }

    protected void updateAllActions() {
        List<TestDataReference> refs = this.getTestDataReferences();
        String labelText = this.getTableLabel();
        Color labelColor = null;
        if (refs == null || refs.isEmpty()) {
            labelText = String.valueOf(labelText) + "  None.  Create or open a Project and execute Scenarios first.";
            labelColor = ExcentisColors.red;
        }
        this.setLabelText(labelText);
        this.setLabelForeground(labelColor);
        super.updateAllActions();
    }

    public void updateWidgets() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean backupAvailable = false;
                if (ExecutedScenariosComposite.this.selectedTestDataReference != null) {
                    backupAvailable = ReportViewer.getInstance().backupAvailable(ExecutedScenariosComposite.this.selectedTestDataReference);
                }
                if (!ExecutedScenariosComposite.this.openBackupButton.isDisposed()) {
                    ExecutedScenariosComposite.this.openBackupButton.setEnabled(backupAvailable);
                }
            }
        });
    }

    protected void updateStatusLine() {
        if (this.statusLineManager == null) {
            return;
        }
        if (this.selectedTestDataReference == null) {
            super.updateStatusLine();
        } else {
            List tags = this.selectedTestDataReference.getTags();
            String tagsInfo = tags.isEmpty() ? "No Tags" : "Tags: " + this.buildTagString(tags);
            this.statusLineManager.setMessage(tagsInfo);
        }
    }

    private String buildTagString(List<Tag> tags) {
        ArrayList<String> names = new ArrayList<String>(tags.size());
        for (Tag tag : tags) {
            names.add(tag.getName());
        }
        Collections.sort(names);
        return String.join((CharSequence)", ", names);
    }

    public Object getInitialInput() {
        return this.getTestDataReferences();
    }

    protected void afterInitialization() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                List refs;
                Object input = ExecutedScenariosComposite.this.getInput();
                if (input != null && !(refs = (List)input).isEmpty()) {
                    ExecutedScenariosComposite.this.selectedTestDataReference = (TestDataReference)refs.get(0);
                    ExecutedScenariosComposite.this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)ExecutedScenariosComposite.this.selectedTestDataReference));
                }
            }
        });
    }

    List<TestDataReference> getTestDataReferences() {
        return this.getTestDataReferences(null);
    }

    private List<TestDataReference> getTestDataReferences(TestDataReference newEntity) {
        Label label = this.getLabel();
        if (label.isDisposed()) {
            return null;
        }
        List<TestDataReference> testDataReferences = Collections.emptyList();
        try {
            boolean validEntity;
            TestDataReferenceManager manager = this.getTestDataReferenceManager();
            testDataReferences = this.getReportableEntities(manager);
            boolean bl = validEntity = newEntity != null && (TestStatus.CANCELLED == newEntity.getStatus() || TestStatus.ERROR == newEntity.getStatus() || TestStatus.FINISHED == newEntity.getStatus());
            if (validEntity && !testDataReferences.contains(newEntity)) {
                testDataReferences.add(newEntity);
            }
            return testDataReferences;
        }
        catch (MetaDataPersistenceGenerationError e) {
            LOGGER.log(Level.SEVERE, "Did not find test references", e);
            return testDataReferences;
        }
    }

    private List<TestDataReference> getReportableEntities(TestDataReferenceManager manager) {
        List testDataReferences = manager.getReportableEntities();
        return testDataReferences;
    }

    private TestDataReferenceManager getTestDataReferenceManager() throws MetaDataPersistenceError, MetaDataPersistenceGenerationError {
        if (this.testDataReferenceManager == null) {
            MetaDataPersistenceController mdpc = MetaDataPersistenceController.getInstance();
            mdpc.forceInitialize();
            this.testDataReferenceManager = new TestDataReferenceManager(mdpc);
        }
        return this.testDataReferenceManager;
    }

    protected String getTableLabel() {
        return "Executed Scenarios:";
    }

    protected String[] getColumnNames() {
        return ExecutedScenarioLabelProvider.columnNames;
    }

    protected int[] getColumnWeights() {
        return ExecutedScenarioLabelProvider.columnWeights;
    }

    protected int createTopWidgets() {
        this.filterText = new Text((Composite)this, 2944);
        this.filterText.addModifyListener((ModifyListener)this);
        this.filterText.setEnabled(true);
        this.filterText.setToolTipText(FILTER_TOOLTIP);
        this.filterText.setMessage("Filter");
        GridData filterGrid = new GridData();
        filterGrid.widthHint = 300;
        this.filterText.setLayoutData((Object)filterGrid);
        this.deleteButton = new Button((Composite)this, 0);
        this.deleteButton.setText("Delete");
        this.deleteButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.setEnabled(false);
        this.getDeleteAction().addEnablementListener(new IEnablementChangedListener(){

            public void enablementChanged(boolean enabled) {
                if (!ExecutedScenariosComposite.this.deleteButton.isDisposed()) {
                    ExecutedScenariosComposite.this.deleteButton.setEnabled(enabled);
                }
            }
        });
        this.openBackupButton = new Button((Composite)this, 0);
        this.openBackupButton.setText(DEFAULT_BACKUPBUTTON_TEXT);
        this.openBackupButton.addSelectionListener((SelectionListener)this);
        this.openBackupButton.setEnabled(false);
        return 3;
    }

    protected void initializeChildClass() {
    }

    protected CellEditor[] createCellEditors() {
        return null;
    }

    protected ICellModifier getCellModifier() {
        return null;
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        this.getTable().setFocus();
        if (widget == this.deleteButton) {
            this.doDelete();
        } else if (widget == this.openBackupButton) {
            this.openBackup();
        }
    }

    private void doDelete() {
        this.actionInterface.doDelete();
        this.updateComposite();
    }

    private void updateComposite() {
        this.updateWidgets();
    }

    private void openBackup() {
        TestDataReference reference = this.selectedTestDataReference;
        this.openBackupButton.setText(PREOPEN_TEXT);
        boolean success = this.openBackupAction.run(reference);
        if (success) {
            this.openBackupButton.setText(SUCCESS_OPEN_TEXT);
        } else {
            this.openBackupButton.setText(FAILED_OPEN_TEXT);
        }
        Job resetAnimation = new Job("reset button text"){

            protected IStatus run(IProgressMonitor monitor) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ExecutedScenariosComposite.this.openBackupButton.isDisposed()) {
                            (this).ExecutedScenariosComposite.this.openBackupButton.setText(ExecutedScenariosComposite.DEFAULT_BACKUPBUTTON_TEXT);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        resetAnimation.setSystem(true);
        resetAnimation.setPriority(10);
        resetAnimation.schedule(500L);
    }

    public void viewerSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        TestDataReference localReference = null;
        if (event != null && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
            localReference = (TestDataReference)selection.getFirstElement();
        }
        this.selectedTestDataReference = localReference;
        this.updateWidgets();
        super.viewerSelectionChanged(event);
    }

    protected void initializeBasicChildListeners() {
    }

    protected void updateCustomWidgets(boolean enable) {
    }

    protected Class<?> getParentClass() {
        return null;
    }

    protected ByteBlowerNewAction<TestDataReference> createNewAction() {
        return new NewReportAction((ByteBlowerViewerComposite<TestDataReference>)this);
    }

    protected ByteBlowerCutAction<TestDataReference> createCutAction() {
        return null;
    }

    protected ByteBlowerCopyAction<TestDataReference> createCopyAction() {
        return null;
    }

    protected ByteBlowerPasteAction<TestDataReference> createPasteAction() {
        return null;
    }

    protected ByteBlowerDeleteAction<TestDataReference> createDeleteAction() {
        return new DeleteSelectedTestResults((ByteBlowerViewerComposite<TestDataReference>)this);
    }

    protected void projectChanged(ByteBlowerProject project) {
    }

    public void postPersist(TestDataReference entity) {
        this.updateInput(entity);
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.filterText) {
            String filter = this.filterText.getText();
            FilterOperation newFilter = new FilterOperation(filter, this);
            newFilter.schedule();
        }
    }

    void changeSelectedRunTitles() {
        ChangeRunTitleDialog dialog;
        String firstRunTitle = ((TestDataReference)this.getFirstSelectedObject()).getTestRunTitle();
        if (firstRunTitle == null) {
            firstRunTitle = "";
        }
        if ((dialog = new ChangeRunTitleDialog(this.getShell(), firstRunTitle)).open() == 0) {
            this.modifySelectedRunTitles(dialog.getRunTitle());
        }
    }

    private void modifySelectedRunTitles(String runTitle) {
        for (TestDataReference selectedEntity : this.getSelectedObjects()) {
            this.modifyRunTitle(selectedEntity, runTitle);
        }
    }

    private void modifyRunTitle(TestDataReference testDataReference, String runTitle) {
        testDataReference.setTestRunTitle(runTitle);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)testDataReference);
        if (TestDataReferenceController.create(testDataReference).databaseExists()) {
            Long testId = testDataReference.getId();
            TestDataPersistenceController tdpc = TestDataPersistenceController.getInstance((Long)testId);
            TestManager testManager = new TestManager(tdpc);
            Test testEntity = testManager.find();
            testEntity.setRunTitle(runTitle);
            testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)testEntity);
        }
    }

    protected ByteBlowerPopupMenu createPopupMenu() {
        return new ExecutedScenariosPopupMenu(this.getShell(), this.actionInterface, this);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedTestDataReference != null) {
            ReportViewer.openRecentHtmlReport((TestDataReference)this.selectedTestDataReference);
        }
    }

    void exportSelectedTestResults() {
        ArrayList<ReportFileFormat> addedFormats = new ArrayList<ReportFileFormat>();
        ArrayList<Report> reports = new ArrayList<Report>();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (TestDataReference testDataReference : this.getSelectedObjects()) {
            addedFormats.clear();
            reports.clear();
            for (ReportGeneration reportGeneration : testDataReference.getReportGenerations()) {
                for (Report report : reportGeneration.getReports()) {
                    File file = new File(report.getFileUrl());
                    if (!file.exists() || file.isDirectory()) continue;
                    reports.add(report);
                }
            }
            Collections.sort(reports, new ReportComparator());
            for (Report report : reports) {
                ReportFileFormat format = report.getFileFormat();
                if (addedFormats.contains(format)) continue;
                addedFormats.add(format);
                String filename = report.getFileUrl();
                if (fileNames.contains(filename)) continue;
                fileNames.add(filename);
            }
        }
        TestDataReferenceController.exportReports(fileNames, this.getShell());
    }
}

