/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenariosComposite;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class ExecutedScenariosPopupMenu
extends ByteBlowerPopupMenu {
    private static final int POPUP_POS_NEW_REPORT = 0;
    private static final int POPUP_POS_DELETE = 1;
    private static final int POPUP_POS_EXPORT = 2;
    private static final int POPUP_POS_CHANGE_RUN_TITLE = 3;
    private IByteBlowerAction actionInterface;
    private ExecutedScenariosComposite composite;

    public ExecutedScenariosPopupMenu(Shell shell, IByteBlowerAction actionInterface, ExecutedScenariosComposite composite) {
        super(shell);
        this.actionInterface = actionInterface;
        this.composite = composite;
    }

    protected void initializeMenu() {
        MenuItem item = new MenuItem(this.menu, 8, 0);
        item.setText("Generate New Reports");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutedScenariosPopupMenu.this.generateNewReports();
            }
        });
        item = new MenuItem(this.menu, 8, 1);
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutedScenariosPopupMenu.this.actionInterface.doDelete();
            }
        });
        item = new MenuItem(this.menu, 8, 2);
        item.setText("Export Reports...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutedScenariosPopupMenu.this.exportSelectedTestResults();
            }
        });
        item = new MenuItem(this.menu, 8, 3);
        item.setText("Change Run Title...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutedScenariosPopupMenu.this.changeRunTitle();
            }
        });
    }

    private void changeRunTitle() {
        this.composite.changeSelectedRunTitles();
    }

    private void exportSelectedTestResults() {
        this.composite.exportSelectedTestResults();
    }

    private void generateNewReports() {
        this.composite.getNewAction().run();
    }

    protected void initializeListeners() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ExecutedScenariosPopupMenu.this.composite.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MenuItem[] items = ExecutedScenariosPopupMenu.this.menu.getItems();
                        int selection = (this).ExecutedScenariosPopupMenu.this.composite.getStructuredSelection().size();
                        items[3].setEnabled(selection > 0);
                        items[1].setEnabled((this).ExecutedScenariosPopupMenu.this.actionInterface.isDeleteEnabled());
                        items[0].setEnabled((this).ExecutedScenariosPopupMenu.this.actionInterface.isNewEnabled());
                    }
                });
            }
        });
    }
}

