/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.actions.IEnablementChangedListener;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerBasicTableComposite;
import com.excentis.products.byteblower.gui.views.archive.actions.DeleteReportsAction;
import com.excentis.products.byteblower.gui.views.archive.composites.DeleteSelectedTestResults;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenariosComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.GeneratedReportsComparator;
import com.excentis.products.byteblower.gui.views.archive.composites.GeneratedReportsLabelProvider;
import com.excentis.products.byteblower.gui.views.archive.composites.GeneratedReportsPopupMenu;
import com.excentis.products.byteblower.gui.views.archive.composites.NewSingleReportAction;
import com.excentis.products.byteblower.gui.views.archive.composites.ReportComparator;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GeneratedReportsComposite
extends ByteBlowerBasicTableComposite<Report>
implements Report.PostPersistListener {
    private Text folder;
    private Button newButton;
    private Button deleteButton;
    private Button openReportButton;
    private ReportViewer reportViewer = ReportViewer.getInstance();

    protected void afterInitialization() {
        Composite archiveLocation = new Composite((Composite)this, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = this.getNofTopWidgets();
        archiveLocation.setLayoutData((Object)layoutData);
        archiveLocation.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(archiveLocation, 0);
        label.setText("Archive Location:");
        this.folder = new Text(archiveLocation, 2052);
        GridData gridData = new GridData(768);
        this.folder.setLayoutData((Object)gridData);
        this.folder.setText(ByteBlowerPreferences.getArchiveLocation());
        this.folder.setEditable(false);
        Button btnBrowse = new Button(archiveLocation, 0);
        btnBrowse.setText("...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratedReportsComposite.this.browseArchiveLocation();
                super.widgetSelected(e);
            }
        });
        this.initializeListener();
        super.afterInitialization();
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer viewer) {
        return new GeneratedReportsComparator(viewer);
    }

    private void initializeListener() {
        IEclipsePreferences prefs = ByteBlowerPreferences.getPreferences();
        prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey() == "archiveLocation") {
                    String value = event.getNewValue().toString();
                    GeneratedReportsComposite.this.folder.setText(value);
                }
            }
        });
    }

    private void browseArchiveLocation() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the folder where you want reports and archives to be stored");
        String dirName = ByteBlowerPreferences.getArchiveLocation();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            ByteBlowerPreferences.setArchiveLocation((String)selectedDirectory);
            this.folder.setText(selectedDirectory);
        }
    }

    public GeneratedReportsComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, ExecutedScenariosComposite executedScenariosComposite) {
        super(parent, "GeneratedReportsComposite", actionInterface, focusDispatcher, (ITableLabelProvider)new GeneratedReportsLabelProvider(), (ByteBlowerBasicTableComposite)executedScenariosComposite);
        this.initializeChildClass();
        Report.addPostPersistListener((Report.PostPersistListener)this);
        DeleteSelectedTestResults parentDeleteAction = (DeleteSelectedTestResults)this.getParentByteBlowerComposite().getDeleteAction();
        parentDeleteAction.setGeneratedReportsComposite(this);
    }

    public void dispose() {
        Report.removePostPersistListener((Report.PostPersistListener)this);
        super.dispose();
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        this.updateComposite();
    }

    void updateComposite() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                GeneratedReportsComposite.this.updateWidgets();
                GeneratedReportsComposite.this.updateInput();
            }
        });
    }

    private void updateInput() {
        boolean empty;
        ArrayList<Report> reports = null;
        List selectedTestDataReferences = this.getExecutedScenariosComposite().getSelectedObjects();
        if (selectedTestDataReferences != null) {
            reports = new ArrayList<Report>();
            for (TestDataReference ref : selectedTestDataReferences) {
                List reportGenerations = ref.getReportGenerations();
                for (ReportGeneration reportGeneration : reportGenerations) {
                    for (Report report : reportGeneration.getReports()) {
                        reports.add(report);
                    }
                }
            }
            Collections.sort(reports, new ReportComparator());
        }
        String label = "Generated Reports:";
        boolean bl = empty = reports == null || reports.isEmpty();
        if (empty) {
            label = String.valueOf(label) + " None";
        }
        final String text = label;
        this.setInput(reports);
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GeneratedReportsComposite.this.setLabelText(text);
                    GeneratedReportsComposite.this.getTable().setHeaderVisible(!empty);
                    GeneratedReportsComposite.this.updateWidgets();
                }
            });
        }
    }

    public void updateWidgets() {
        if (this.newButton.isDisposed() || this.openReportButton.isDisposed() || this.deleteButton.isDisposed()) {
            return;
        }
        this.getExecutedScenariosComposite().getNewAction().addEnablementListener(new IEnablementChangedListener(){

            public void enablementChanged(boolean enabled) {
                if (!GeneratedReportsComposite.this.newButton.isDisposed()) {
                    GeneratedReportsComposite.this.newButton.setEnabled(enabled);
                }
            }
        });
        String url = this.getReportUrl();
        boolean enabled = false;
        if (url != null) {
            File file = new File(url);
            enabled = file.exists();
        }
        this.openReportButton.setEnabled(enabled);
    }

    private boolean htmlReportExists() {
        TestDataReference ref = this.getSelectedTestDataReference();
        if (ref != null) {
            return TestDataReferenceController.create(ref).reportExists(ReportFileFormat.HTML);
        }
        return false;
    }

    protected void projectChanged(ByteBlowerProject project) {
    }

    public Object getInitialInput() {
        return null;
    }

    protected String getTableLabel() {
        return "Generated Reports:";
    }

    protected String[] getColumnNames() {
        return GeneratedReportsLabelProvider.columnNames;
    }

    protected int[] getColumnWeights() {
        return GeneratedReportsLabelProvider.columnWeights;
    }

    protected int createTopWidgets() {
        this.newButton = new Button((Composite)this, 0);
        this.deleteButton = new Button((Composite)this, 0);
        this.openReportButton = new Button((Composite)this, 0);
        this.newButton.setText("Generate New Reports");
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.getDeleteAction().addEnablementListener(new IEnablementChangedListener(){

            public void enablementChanged(boolean enabled) {
                if (!GeneratedReportsComposite.this.deleteButton.isDisposed()) {
                    GeneratedReportsComposite.this.deleteButton.setEnabled(enabled);
                }
            }
        });
        this.openReportButton.setText("Open Report");
        return 3;
    }

    private void openSelectedReport() {
        Report report = (Report)this.getFirstSelectedObject();
        if (report != null) {
            ReportViewer.getInstance().openReport((Report)this.getFirstSelectedObject());
        }
    }

    private TestDataReference getSelectedTestDataReference() {
        return (TestDataReference)this.getExecutedScenariosComposite().getFirstSelectedObject();
    }

    protected void initializeBasicChildListeners() {
        this.newButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        this.openReportButton.addSelectionListener((SelectionListener)this);
        this.addControlListener((ControlListener)this);
        this.getTableViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GeneratedReportsComposite.this.openSelectedReport();
            }
        });
    }

    private void doNew() {
        this.getExecutedScenariosComposite().getNewAction().run();
    }

    private void doDelete() {
        this.actionInterface.doDelete();
        this.updateComposite();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        String url;
        Widget widget = event.widget;
        this.getTable().setFocus();
        if (widget == this.newButton) {
            this.doNew();
        } else if (widget == this.deleteButton) {
            this.doDelete();
        } else if (widget == this.openReportButton && (url = this.getReportUrl()) != null) {
            this.reportViewer.openReport(url);
        }
    }

    private String getReportUrl() {
        TestDataReference ref;
        String url = null;
        Report report = (Report)this.getFirstSelectedObject();
        if (report != null) {
            url = report.getFileUrl();
            File file = new File(report.getFileUrl());
            if (!file.exists()) {
                url = null;
            }
        }
        if (url == null && (ref = this.getSelectedTestDataReference()) != null) {
            url = TestDataReferenceController.create(ref).getReportUrl(ReportFileFormat.HTML);
        }
        return url;
    }

    public void viewerSelectionChanged(SelectionChangedEvent event) {
        this.updateWidgets();
        super.viewerSelectionChanged(event);
    }

    protected void updateStatusLine() {
        if (this.statusLineManager == null) {
            return;
        }
        List reports = this.getSelectedObjects();
        if (reports.size() == 1) {
            this.statusLineManager.setMessage(((Report)this.getFirstSelectedObject()).getFileUrl());
        } else {
            super.updateStatusLine();
        }
    }

    protected CellEditor[] createCellEditors() {
        return null;
    }

    protected ICellModifier getCellModifier() {
        return null;
    }

    protected void updateCustomWidgets(boolean enable) {
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return null;
    }

    private ByteBlowerViewerComposite<TestDataReference> getExecutedScenariosComposite() {
        return (ExecutedScenariosComposite)this.getParentByteBlowerComposite();
    }

    public void postPersist(Report entity) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                GeneratedReportsComposite.this.updateInput();
            }
        });
    }

    protected ByteBlowerPopupMenu createPopupMenu() {
        return new GeneratedReportsPopupMenu(this.getShell(), this.actionInterface, this);
    }

    protected ByteBlowerNewAction<Report> createNewAction() {
        return new NewSingleReportAction((ByteBlowerViewerComposite<Report>)this);
    }

    protected ByteBlowerCutAction<Report> createCutAction() {
        return null;
    }

    protected ByteBlowerCopyAction<Report> createCopyAction() {
        return null;
    }

    protected ByteBlowerPasteAction<Report> createPasteAction() {
        return null;
    }

    protected ByteBlowerDeleteAction<Report> createDeleteAction() {
        return new DeleteReportsAction(this);
    }

    protected void initializeChildClass() {
    }
}

