/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.batch.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerRunTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTablePopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerRunAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.batch.BatchCellModifier;
import com.excentis.products.byteblower.gui.views.batch.actions.CopyBatch;
import com.excentis.products.byteblower.gui.views.batch.actions.CutBatch;
import com.excentis.products.byteblower.gui.views.batch.actions.DeleteBatch;
import com.excentis.products.byteblower.gui.views.batch.actions.NewBatch;
import com.excentis.products.byteblower.gui.views.batch.actions.PasteBatch;
import com.excentis.products.byteblower.gui.views.batch.composites.BatchComparator;
import com.excentis.products.byteblower.gui.views.scenario.composites.RunPopupMenu;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class BatchComposite
extends ByteBlowerRunTableComposite<Batch> {
    private static final String[] COLUMN_NAMES = new String[]{Messages.getString("BatchView.Column.Name"), Messages.getString("BatchView.Column.Duration")};
    private static final int[] COLUMN_WEIGHTS = new int[]{1, 1};
    private Batch currentSelection;
    private Adapter statusUpdateAdapter = new StatusUpdateAdapter();

    protected ByteBlowerTablePopupMenu createPopupMenu() {
        return new RunPopupMenu(this.getShell(), this.actionInterface, (IByteBlowerRunAction)this, (IByteBlowerCopyDownAction)this, (IByteBlowerTableViewer)this.getTableViewer());
    }

    public BatchComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "BatchComposite", actionInterface, focusDispatcher);
        this.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Batch newBatch = (Batch)selection.getFirstElement();
                if (newBatch == BatchComposite.this.currentSelection) {
                    return;
                }
                if (BatchComposite.this.currentSelection != null) {
                    BatchController oldBatchController = ControllerFactory.create((Batch)BatchComposite.this.currentSelection);
                    oldBatchController.removeAdapter(BatchComposite.this.statusUpdateAdapter);
                }
                if (newBatch != null) {
                    BatchController newBatchController = ControllerFactory.create((Batch)newBatch);
                    newBatchController.addAdapter(BatchComposite.this.statusUpdateAdapter);
                }
                BatchComposite.this.currentSelection = newBatch;
            }
        });
        this.currentSelection = (Batch)this.getFirstSelectedObject();
        GuiRunner.getInstance().addListener(new GuiRunner.ActiveJobListener(){

            public void activeScenarioJobChanged() {
                BatchComposite.this.updateRunButton();
            }

            public void activeScenarioPaused(GuiRunner.Resumer resume) {
            }

            public void activeScenarioResumed() {
            }
        });
    }

    public void doJump() {
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        NameCellEditor nameEditor = new NameCellEditor((Composite)table);
        editors[0] = nameEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new BatchCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return COLUMN_WEIGHTS;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 6;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Batch.class;
    }

    protected String getTableLabel() {
        return Messages.getString("BatchView.Overview.Label");
    }

    protected String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    public boolean isCopyDownEnabled() {
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public boolean isJumpEnabled() {
        return false;
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    public void doRun() {
        Batch batch = this.getSelectedBatch();
        if (batch == null) {
            System.out.println("Batch is null");
            return;
        }
        GuiRunner.getInstance().scheduleBatch(batch);
    }

    public boolean isRunEnabled() {
        Batch selectedBatch;
        StructuredSelection selection;
        boolean canRun;
        boolean enable = false;
        boolean bl = canRun = !GuiRunner.getInstance().isRunning();
        if (canRun && (selection = this.getStructuredSelection()).size() > 0 && selection.getFirstElement() instanceof Batch && (selectedBatch = (Batch)selection.getFirstElement()) != null) {
            BatchReader reader = ReaderFactory.create((Batch)selectedBatch);
            enable = !reader.hasErrorStatus();
        }
        return enable;
    }

    private Batch getSelectedBatch() {
        return (Batch)this.getFirstSelectedObject();
    }

    protected String getRunButtonText() {
        return "Run";
    }

    protected String getRunButtonTooltipText() {
        return "Run Selected Batch";
    }

    protected ByteBlowerNewAction<Batch> createNewAction() {
        return new NewBatch(this);
    }

    protected ByteBlowerCutAction<Batch> createCutAction() {
        return new CutBatch(this);
    }

    protected ByteBlowerCopyAction<Batch> createCopyAction() {
        return new CopyBatch(this);
    }

    protected ByteBlowerPasteAction<Batch> createPasteAction() {
        return new PasteBatch(this);
    }

    protected ByteBlowerDeleteAction<Batch> createDeleteAction() {
        return new DeleteBatch(this);
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new BatchComparator(columnViewer);
    }

    private class StatusUpdateAdapter
    extends AdapterImpl {
        private StatusUpdateAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Scenario.class)) {
                case 1: {
                    BatchComposite.this.updateRunButton();
                    return;
                }
            }
        }
    }
}

