/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.dhcp;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import org.eclipse.jface.viewers.ICellEditorValidator;

class DhcpTimeoutCellValidator
implements ICellEditorValidator {
    private final HighResolutionCalendar minTime;
    private final HighResolutionCalendar maxTime;

    public DhcpTimeoutCellValidator(String minTimeInNanos, String maxTimeInNanos) {
        this.minTime = new HighResolutionCalendar(minTimeInNanos);
        this.maxTime = new HighResolutionCalendar(maxTimeInNanos);
    }

    public String isValid(Object value) {
        if (value == null) {
            return "NULL value is invalid";
        }
        if (value instanceof String) {
            String valueString = (String)value;
            if (!HighResolutionCalendarParser.relativeTimeInputPatternMatches((String)valueString)) {
                return "Invalid Relative Time string";
            }
            HighResolutionCalendar currentTime = new HighResolutionCalendar();
            HighResolutionCalendarParser.setRelativeTime((String)valueString, (HighResolutionCalendar)currentTime);
            if (currentTime.after((Object)this.maxTime)) {
                return "Time value is too big";
            }
            if (currentTime.before((Object)this.minTime)) {
                return "Time value is too low";
            }
            return null;
        }
        return "unknown batch action type";
    }
}

