/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.flow.FlowTableComposite;
import com.excentis.products.byteblower.gui.views.flow.FlowTemplateEditor;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyMulticastDescription;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyPortDescription;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingView;
import com.excentis.products.byteblower.gui.views.multicast.MulticastView;
import com.excentis.products.byteblower.gui.views.port.PortView;
import com.excentis.products.byteblower.gui.views.tcp.TcpView;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.MulticastGroupController;
import com.excentis.products.byteblower.model.control.TcpFlowController;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

class FlowCellModifier
implements ICellModifier {
    private FlowTableComposite flowTableComposite;

    public FlowCellModifier(FlowTableComposite flowTableComposite) {
        this.flowTableComposite = flowTableComposite;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.flowTableComposite.getColumnIndex(property);
        Flow flow = (Flow)element;
        FlowReader reader = ReaderFactory.create((Flow)flow);
        switch (columnIndex) {
            case 4: {
                return reader.supportsLatencyMeasurement();
            }
            case 5: {
                return reader.supportsOosMeasurement();
            }
            case 6: {
                return reader.canEditTos();
            }
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.flowTableComposite.getColumnIndex(property);
        Flow flow = (Flow)element;
        switch (columnIndex) {
            case 0: {
                return flow.getName();
            }
            case 1: {
                return flow.getFlowTemplate();
            }
            case 2: {
                return flow.getSource();
            }
            case 3: {
                return flow.getDestination();
            }
            case 4: {
                return new Integer(flow.getLatencyAndJitterType().getValue());
            }
            case 5: {
                return new Integer(flow.getOutOfSequenceDetection().getValue());
            }
            case 6: {
                return flow.getTos();
            }
        }
        System.err.println("FlowItemProvider#getValue() : invalid case !");
        return null;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.flowTableComposite.getColumnIndex(property);
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        TableItem item = (TableItem)element;
        if (item == null) {
            return;
        }
        Flow flow = (Flow)item.getData();
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                String newName = ((String)value).trim();
                if (!OldNamingTools.nameIsUnique((EObject)flow, (String)newName)) break;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Flow Name", (EByteBlowerObject)flow, ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME, (Object)newName);
                operation.run();
                break;
            }
            case 4: {
                int index = (Integer)value;
                if (index < 0 || index > 2) {
                    System.out.println("ERROR : invalid combobox index : only 0 or 1 or 2 is allowed");
                    return;
                }
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Latency And Jitter", (EByteBlowerObject)flow, ByteblowerguimodelPackage.Literals.FLOW__LATENCY_AND_JITTER_TYPE, (Object)LatencyAndJitterType.get((int)index));
                operation.run();
                break;
            }
            case 5: {
                int index = (Integer)value;
                if (index != 0 && index != 1) {
                    System.out.println("ERROR : invalid combobox index : only 0 or 1");
                    return;
                }
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Out Of Sequence Detection", (EByteBlowerObject)flow, ByteblowerguimodelPackage.Literals.FLOW__OUT_OF_SEQUENCE_DETECTION, (Object)OutOfSequenceType.get((int)index));
                operation.run();
                break;
            }
            case 2: {
                if (value.equals(new UserFriendlyPortDescription.PortIPv4Create())) {
                    this.createBBPort(project, flow, ByteblowerguimodelPackage.Literals.FLOW__SOURCE, SupportedLayer3Configuration.IPV4).run();
                    break;
                }
                if (value.equals(new UserFriendlyPortDescription.PortIPv6Create())) {
                    this.createBBPort(project, flow, ByteblowerguimodelPackage.Literals.FLOW__SOURCE, SupportedLayer3Configuration.IPV6).run();
                    break;
                }
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation(project, "Change Flow Source", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__SOURCE, value);
                operation.run();
                break;
            }
            case 1: {
                FlowTemplateEditor.UserFriendlyTemplateDescription descValue = (FlowTemplateEditor.UserFriendlyTemplateDescription)value;
                if (descValue.isCreate()) {
                    if (descValue.getTemplate() instanceof TcpFlow) {
                        this.createTCP(project, flow).run();
                        break;
                    }
                    if (!(descValue.getTemplate() instanceof FrameBlastingFlow)) break;
                    this.createFB(project, flow).run();
                    break;
                }
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation(project, "Change Flow Template", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE, (Object)descValue.getTemplate());
                operation.run();
                break;
            }
            case 3: {
                if (value.equals(new UserFriendlyPortDescription.PortIPv4Create())) {
                    this.createBBPort(project, flow, ByteblowerguimodelPackage.Literals.FLOW__DESTINATION, SupportedLayer3Configuration.IPV4).run();
                    break;
                }
                if (value.equals(new UserFriendlyPortDescription.PortIPv6Create())) {
                    this.createBBPort(project, flow, ByteblowerguimodelPackage.Literals.FLOW__DESTINATION, SupportedLayer3Configuration.IPV6).run();
                    break;
                }
                if (value.equals(new UserFriendlyMulticastDescription.MulticastCreate())) {
                    this.createMulticast(project, flow, ByteblowerguimodelPackage.Literals.FLOW__DESTINATION).run();
                    break;
                }
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation(project, "Change Flow destination", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__DESTINATION, value);
                operation.run();
                break;
            }
            case 6: {
                Byte tos = (Byte)value;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change TOS", (EByteBlowerObject)flow, ByteblowerguimodelPackage.Literals.FLOW__TOS, (Object)tos);
                operation.run();
                break;
            }
            default: {
                return;
            }
        }
    }

    private UndoableByteBlowerOperation createMulticast(ByteBlowerProject project, Flow flow, EReference flowDestination) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithMulticastGroupListReference multicastCreation = projectController.addMulticastGroup();
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(multicastCreation.getCommand());
        final MulticastGroup multicast = (MulticastGroup)((MulticastGroupController)((List)multicastCreation.getCommandReference()).get(0)).getObject();
        ByteBlowerSetOperation srcPortSet = new ByteBlowerSetOperation(project, "Change Flow", (EObject)flow, flowDestination, (Object)multicast);
        compoundController.appendCommand(srcPortSet.getCompoundCommand());
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New Multicast group", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FlowCellModifier.this.delayedShow(multicast);
            }
        });
        return operation;
    }

    private void delayedShow(final MulticastGroup group) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp != null && !disp.isDisposed()) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MulticastView.showAndSelect(group);
                }
            });
        }
    }

    private void delayedShow(final ByteBlowerGuiPort port) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp != null && !disp.isDisposed()) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PortView.showAndSelect(port);
                }
            });
        }
    }

    private void delayedShow(final FrameBlastingFlow flowTemplate) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp != null && !disp.isDisposed()) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FrameBlastingView.showAndSelect(flowTemplate);
                }
            });
        }
    }

    private void delayedShow(final TcpFlow flowTemplate) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp != null && !disp.isDisposed()) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TcpView.showAndSelect(flowTemplate);
                }
            });
        }
    }

    private UndoableByteBlowerOperation createBBPort(ByteBlowerProject project, Flow flow, EReference target, SupportedLayer3Configuration netConfig) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithByteBlowerGuiPortListReference portCreation = projectController.addByteBlowerGuiPort(netConfig);
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(portCreation.getCommand());
        final ByteBlowerGuiPort bbPort = (ByteBlowerGuiPort)((ByteBlowerGuiPortController)((List)portCreation.getCommandReference()).get(0)).getObject();
        ByteBlowerSetOperation srcPortSet = new ByteBlowerSetOperation(project, "Change Flow", (EObject)flow, target, (Object)bbPort);
        compoundController.appendCommand(srcPortSet.getCompoundCommand());
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New BB port", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FlowCellModifier.this.delayedShow(bbPort);
            }
        });
        return operation;
    }

    private UndoableByteBlowerOperation createFB(ByteBlowerProject project, Flow flow) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithFrameBlastingFlowListReference fbCreation = projectController.addPopulatedFrameBlastingFlows(1);
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(fbCreation.getCommand());
        final FrameBlastingFlow flowTemplate = (FrameBlastingFlow)((FrameBlastingFlowController)((List)fbCreation.getCommandReference()).get(0)).getObject();
        ByteBlowerSetOperation templateOp = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Template", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE, (Object)flowTemplate);
        compoundController.appendCommand(templateOp.getCompoundCommand());
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New FB template", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FlowCellModifier.this.delayedShow(flowTemplate);
            }
        });
        return operation;
    }

    private UndoableByteBlowerProjectOperation createTCP(ByteBlowerProject project, Flow flow) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithTcpFlowListReference tcpCreation = projectController.addTcpFlow();
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(tcpCreation.getCommand());
        final TcpFlow flowTemplate = (TcpFlow)((TcpFlowController)((List)tcpCreation.getCommandReference()).get(0)).getObject();
        ByteBlowerSetOperation templateOp = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Template", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE, (Object)flowTemplate);
        compoundController.appendCommand(templateOp.getCompoundCommand());
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New TCP template", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FlowCellModifier.this.delayedShow(flowTemplate);
            }
        });
        return operation;
    }
}

