/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.flow.FlowSettingsText;
import com.excentis.products.byteblower.gui.views.flow.FlowTableComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.SelectPortsDialog;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

class FlowSettingsComposite
extends ByteBlowerComposite {
    private FlowSettingsText settingsReport;
    private Label lblSettings;
    private Button btnEditEavesDroppers;
    private Flow selectedFlow = null;
    private FlowChangeNotification flowListeners = new FlowChangeNotification();

    public FlowSettingsComposite(Composite parent, FlowTableComposite flowTableComposite) {
        super(parent, (IByteBlowerComposite)flowTableComposite);
        this.initialize();
    }

    private void initialize() {
        this.lblSettings = new Label((Composite)this, 0);
        this.btnEditEavesDroppers = new Button((Composite)this, 0);
        this.btnEditEavesDroppers.addSelectionListener((SelectionListener)this);
        this.settingsReport = new FlowSettingsText((Composite)this, 2048);
        this.setLayout((Layout)new GridLayout(2, false));
        this.lblSettings.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.settingsReport.setLayoutData(gridData);
        this.lblSettings.setText(Messages.getString("FlowView.Label.Settings"));
        this.btnEditEavesDroppers.setText(Messages.getString("FlowView.Button.EditEavesdroppers"));
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.btnEditEavesDroppers) {
            this.editEavesDroppers();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private Set<ByteBlowerGuiPort> destinationPorts() {
        HashSet<ByteBlowerGuiPort> result = new HashSet<ByteBlowerGuiPort>();
        AddressableDestination destination = this.selectedFlow.getDestination();
        if (destination instanceof ByteBlowerGuiPort) {
            result.add((ByteBlowerGuiPort)destination);
        } else if (destination instanceof MulticastGroup) {
            MulticastGroup group = (MulticastGroup)destination;
            for (MulticastMemberPort port : group.getMulticastMemberPort()) {
                result.add(port.getByteBlowerGuiPort());
            }
        }
        return result;
    }

    private void editEavesDroppers() {
        if (this.selectedFlow != null) {
            ArrayList<ByteBlowerGuiPort> potentialPorts = new ArrayList<ByteBlowerGuiPort>();
            Set<ByteBlowerGuiPort> forbiddenPorts = this.destinationPorts();
            for (ByteBlowerGuiPort port : ByteBlowerGuiResourceController.getProject().getByteBlowerGuiPort()) {
                if (forbiddenPorts.contains(port)) continue;
                potentialPorts.add(port);
            }
            SelectPortsDialog dlg = new SelectPortsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Eavesdroppers", potentialPorts, (Collection)this.selectedFlow.getByteBlowerGuiPort(), (Collection)this.selectedFlow.getByteBlowerGuiPort());
            if (dlg.open() == 0) {
                Collection selectedPorts = dlg.getCheckedByteBlowerGuiPorts();
                UniqueEList removedEaves = new UniqueEList();
                removedEaves.addAll((Collection)this.selectedFlow.getByteBlowerGuiPort());
                removedEaves.addAll(selectedPorts);
                UniqueEList newEaves = new UniqueEList((Collection)removedEaves);
                newEaves.removeAll((Collection)this.selectedFlow.getByteBlowerGuiPort());
                removedEaves.removeAll(selectedPorts);
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Eavesdroppers");
                for (ByteBlowerGuiPort eave : removedEaves) {
                    Command remCommand = RemoveCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.selectedFlow, (Object)ByteblowerguimodelPackage.Literals.FLOW__BYTE_BLOWER_GUI_PORT, (Object)eave);
                    operation.appendCommand(remCommand);
                }
                for (ByteBlowerGuiPort eave : newEaves) {
                    Command addCommand = AddCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.selectedFlow, (Object)ByteblowerguimodelPackage.Literals.FLOW__BYTE_BLOWER_GUI_PORT, (Object)eave);
                    operation.appendCommand(addCommand);
                }
                operation.run();
            }
        }
    }

    private boolean anythingDisposed() {
        return this.lblSettings.isDisposed() || this.btnEditEavesDroppers.isDisposed() || this.settingsReport.isDisposed();
    }

    public void updateWidgets() {
        boolean enableEaves;
        if (this.anythingDisposed()) {
            return;
        }
        boolean flowSelected = this.selectedFlow != null;
        boolean enable = ByteBlowerGuiResourceController.getInstance().isOpen();
        this.lblSettings.setEnabled(enable && flowSelected);
        boolean bl = enableEaves = enable && flowSelected;
        if (flowSelected) {
            this.flowListeners.listenTo(this.selectedFlow);
            if (this.selectedFlow.getFlowTemplate() instanceof TcpFlow && this.selectedFlow.getByteBlowerGuiPort().size() == 0) {
                enableEaves = false;
            }
        }
        this.btnEditEavesDroppers.setEnabled(enableEaves);
        this.settingsReport.setEnabled(enable && flowSelected);
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        Flow newFlow = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            newFlow = (Flow)selection.getFirstElement();
        }
        this.setFlow(newFlow);
    }

    private void setFlow(Flow newFlow) {
        if (newFlow != this.selectedFlow) {
            this.selectedFlow = newFlow;
            this.updateWidgets();
            this.settingsReport.setFlow(this.selectedFlow);
        }
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.setFlow(null);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
    }

    private class FlowChangeNotification
    extends AdapterImpl {
        private FlowChangeNotification() {
        }

        private void listenTo(Flow flow) {
            for (Adapter g : flow.eAdapters()) {
                if (g != this) continue;
                return;
            }
            flow.eAdapters().add((Object)this);
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() == FlowSettingsComposite.this.selectedFlow && !FlowSettingsComposite.this.isDisposed()) {
                FlowSettingsComposite.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FlowSettingsComposite.this.updateWidgets();
                    }
                });
            }
        }
    }
}

