/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.jface.viewers.ByteCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTablePopupMenu;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.flow.FlowCellModifier;
import com.excentis.products.byteblower.gui.views.flow.FlowDestinationEditor;
import com.excentis.products.byteblower.gui.views.flow.FlowSourcePortEditor;
import com.excentis.products.byteblower.gui.views.flow.FlowTemplateEditor;
import com.excentis.products.byteblower.gui.views.flow.actions.CopyFlowAction;
import com.excentis.products.byteblower.gui.views.flow.actions.CutFlowAction;
import com.excentis.products.byteblower.gui.views.flow.actions.DeleteFlowAction;
import com.excentis.products.byteblower.gui.views.flow.actions.NewFlowAction;
import com.excentis.products.byteblower.gui.views.flow.actions.PasteFlowAction;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingView;
import com.excentis.products.byteblower.gui.views.multicast.MulticastView;
import com.excentis.products.byteblower.gui.views.port.PortView;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.gui.views.tcp.TcpView;
import com.excentis.products.byteblower.gui.widgets.dialogs.FlowDestinationDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.SelectByteBlowerPortDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.SelectFlowTemplateDialog;
import com.excentis.products.byteblower.gui.wizards.rfc2544.RFC2544EditWizard;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

class FlowTableComposite
extends ByteBlowerAmountTableComposite<Flow> {
    private static final String[] columnNames = new String[]{Messages.getString("FlowView.Column.Name"), Messages.getString("FlowView.Column.FlowTemplate"), Messages.getString("FlowView.Column.Source"), Messages.getString("FlowView.Column.Destination"), Messages.getString("FlowView.Column.LatencyAndJitter"), Messages.getString("FlowView.Column.OutOfSequence"), Messages.getString("FlowView.Column.Tos")};
    private static final int[] columnWeights = new int[]{2, 2, 2, 2, 1, 2, 1};
    private static final String[] latencyAndJitterChoices = new String[]{LatencyAndJitterType.NO.getName(), LatencyAndJitterType.AVERAGE.getName(), LatencyAndJitterType.DISTRIBUTION.getName()};
    private static final String[] sequenceChoices = new String[]{"No", "Yes"};

    public FlowTableComposite(Composite parent, IByteBlowerAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "FlowTableComposite", byteBlowerAction, focusDispatcher);
        this.initializeChildClass();
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[0] = new NameCellEditor((Composite)table);
        editors[1] = new FlowTemplateEditor((Composite)table);
        editors[2] = new FlowSourcePortEditor((Composite)table);
        editors[3] = new FlowDestinationEditor((Composite)table, this);
        ComboBoxCellEditor latencyAndJitterBox = new ComboBoxCellEditor((Composite)table, latencyAndJitterChoices, 8);
        latencyAndJitterBox.setActivationStyle(1);
        editors[4] = latencyAndJitterBox;
        ComboBoxCellEditor sequenceBox = new ComboBoxCellEditor((Composite)table, sequenceChoices, 8);
        sequenceBox.setActivationStyle(1);
        editors[5] = sequenceBox;
        ByteCellEditor tosEditor = new ByteCellEditor((Composite)table);
        editors[6] = tosEditor;
        return editors;
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public int[] getColumnWeights() {
        return columnWeights;
    }

    public boolean isJumpEnabled() {
        boolean enable = false;
        Flow flow = (Flow)this.getFirstSelectedObject();
        if (flow != null) {
            int currentColumn = this.getCurrentColumn();
            switch (currentColumn) {
                case 1: {
                    enable = flow.getFlowTemplate() != null;
                    break;
                }
                case 2: {
                    enable = flow.getSource() != null;
                    break;
                }
                case 3: {
                    AddressableDestination dest = flow.getDestination();
                    enable = dest instanceof ByteBlowerGuiPort || dest instanceof MulticastGroup;
                    break;
                }
            }
        }
        return enable;
    }

    public void doJump() {
        Flow flow = (Flow)this.getFirstSelectedObject();
        int currentColumn = this.getCurrentColumn();
        switch (currentColumn) {
            case 1: {
                FlowTemplate flowTemplate = flow.getFlowTemplate();
                if (flowTemplate instanceof FrameBlastingFlow) {
                    FrameBlastingView.showAndSelect((FrameBlastingFlow)flowTemplate);
                    break;
                }
                if (flowTemplate instanceof TcpFlow) {
                    TcpView.showAndSelect((TcpFlow)flowTemplate);
                    break;
                }
                if (!(flowTemplate instanceof FrameBlastingBenchmark)) break;
                RFC2544EditWizard g = new RFC2544EditWizard((FrameBlastingBenchmark)flowTemplate);
                Shell current = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                WizardDialog dialog = new WizardDialog(current, (IWizard)g);
                dialog.open();
                break;
            }
            case 2: {
                PortView.showAndSelect((ByteBlowerGuiPort)flow.getSource());
                break;
            }
            case 3: {
                AddressableDestination dest = flow.getDestination();
                if (dest instanceof ByteBlowerGuiPort) {
                    PortView.showAndSelect((ByteBlowerGuiPort)dest);
                    break;
                }
                if (!(dest instanceof MulticastGroup)) break;
                MulticastView.showAndSelect((MulticastGroup)dest);
            }
        }
    }

    protected ICellModifier getCellModifier() {
        return new FlowCellModifier(this);
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        int currentColumn = this.getCurrentColumn();
        Flow selectedFlow = (Flow)this.getFirstSelectedObject();
        switch (currentColumn) {
            case 0: {
                return true;
            }
            case 1: {
                return selectedFlow.getFlowTemplate() != null;
            }
            case 2: {
                return selectedFlow.getSource() != null;
            }
            case 3: {
                return selectedFlow.getDestination() != null;
            }
            case 4: 
            case 5: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownEnabled() {
        int currentColumn = this.getCurrentColumn();
        Flow selectedFlow = (Flow)this.getFirstSelectedObject();
        switch (currentColumn) {
            case 1: {
                return selectedFlow.getFlowTemplate() != null;
            }
            case 2: {
                return selectedFlow.getSource() != null;
            }
            case 3: {
                return selectedFlow.getDestination() != null;
            }
            case 4: 
            case 5: {
                return true;
            }
            case 6: {
                return selectedFlow.getFlowTemplate() instanceof TcpFlow;
            }
        }
        return false;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 7;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Flow.class;
    }

    protected void editSelectedFlow() {
        Flow selectedFlow = (Flow)this.getFirstSelectedObject();
        if (selectedFlow != null) {
            switch (this.getCurrentColumn()) {
                case 1: {
                    this.editFlowTemplate(selectedFlow);
                    break;
                }
                case 2: {
                    this.editSource(selectedFlow);
                    break;
                }
                case 3: {
                    this.editDestination(selectedFlow);
                }
            }
        }
    }

    private void editDestination(Flow flow) {
        FlowDestinationDialog dialog = new FlowDestinationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), flow);
        if (dialog.open() == 0) {
            ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Destination");
            FlowController flowController = ControllerFactory.create((Flow)flow);
            FlowDestinationDialog.DestinationInfo info = dialog.getDestinationInfo();
            switch (info.getType()) {
                case 0: {
                    return;
                }
                case 1: 
                case 2: {
                    AddressableDestination destination = (AddressableDestination)info.getValue();
                    operation.appendCommand(flowController.createSetDestinationCommand(destination));
                    break;
                }
                case 3: {
                    String address = (String)info.getValue();
                    operation.appendCommand(flowController.createSetBroadcastDestinationCommand(address));
                    break;
                }
                case 4: {
                    String address = (String)info.getValue();
                    operation.appendCommand(flowController.createSetUnicastDestinationCommand(address));
                }
            }
            operation.run();
        }
    }

    private void editSource(Flow flow) {
        ByteBlowerGuiPort source = (ByteBlowerGuiPort)flow.getSource();
        SelectByteBlowerPortDialog dialog = new SelectByteBlowerPortDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("FlowView.Edit.Source.DialogTitle"), source);
        if (dialog.open() == 0) {
            source = dialog.getSelectedByteBlowerPort();
            ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Source", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__SOURCE, (Object)source);
            operation.run();
        }
    }

    private void editFlowTemplate(Flow flow) {
        FlowTemplate oldFlowTemplate = flow.getFlowTemplate();
        SelectFlowTemplateDialog dialog = new SelectFlowTemplateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), flow.getName(), oldFlowTemplate);
        if (dialog.open() == 0) {
            FlowTemplate newFlowTemplate = dialog.getSelectedFlowTemplate();
            ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Template", (EObject)flow, ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE, (Object)newFlowTemplate);
            operation.run();
        }
    }

    protected ByteBlowerTablePopupMenu createPopupMenu() {
        ByteBlowerTablePopupMenu popup = super.createPopupMenu();
        Menu menu = popup.getMenu();
        final MenuItem item = new MenuItem(menu, 0);
        item.setText("Add to new scenario...");
        this.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                String itemText;
                List selection = FlowTableComposite.this.getSelectedObjects();
                item.setEnabled(!selection.isEmpty());
                switch (selection.size()) {
                    case 0: {
                        itemText = "Add to new scenario...";
                        break;
                    }
                    case 1: {
                        itemText = String.format("Add '%s' to new scenario...", ((Flow)selection.get(0)).getName());
                        break;
                    }
                    default: {
                        itemText = String.format("Add %d flows to new scenario...", selection.size());
                    }
                }
                item.setText(itemText);
            }
        });
        item.addSelectionListener((SelectionListener)new FlowsIntoScenario());
        return popup;
    }

    protected String getTableLabel() {
        return Messages.getString("FlowView.Label");
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    protected ByteBlowerNewAction<Flow> createNewAction() {
        return new NewFlowAction(this);
    }

    protected ByteBlowerCutAction<Flow> createCutAction() {
        return new CutFlowAction(this);
    }

    protected ByteBlowerCopyAction<Flow> createCopyAction() {
        return new CopyFlowAction(this);
    }

    protected ByteBlowerPasteAction<Flow> createPasteAction() {
        return new PasteFlowAction(this);
    }

    protected ByteBlowerDeleteAction<Flow> createDeleteAction() {
        return new DeleteFlowAction(this);
    }

    private final class FlowsIntoScenario
    implements SelectionListener {
        private FlowsIntoScenario() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            List flows = FlowTableComposite.this.getSelectedObjects();
            CompoundCommand compound = new CompoundCommand();
            ByteBlowerProjectController bbProjectController = new ByteBlowerProjectController(ByteBlowerGuiResourceController.getProject());
            ByteBlowerProjectController.CommandWithScenarioListReference scenarioCommand = bbProjectController.addScenario();
            compound.append(scenarioCommand.getCommand());
            ScenarioController scenario = (ScenarioController)((List)scenarioCommand.getCommandReference()).get(0);
            ScenarioFlowEventController.CommandWithFlowMeasurementListReference flowMeasurementCommand = scenario.addFlowMeasurements(flows.size(), 0);
            compound.append(flowMeasurementCommand.getCommand());
            List measurements = (List)flowMeasurementCommand.getCommandReference();
            int idx = 0;
            while (idx < flows.size() && idx < measurements.size()) {
                FlowMeasurementController measurement = (FlowMeasurementController)measurements.get(idx);
                Flow flow = (Flow)flows.get(idx);
                Command insertCmd = measurement.setFlow(flow);
                compound.append(insertCmd);
                ++idx;
            }
            UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(FlowTableComposite.this.getProject(), "Add flows into new scenario", (Command)compound);
            operation.run();
            ScenarioView.showAndSelect((Scenario)scenario.getObject());
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

