/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.views.flow.UserFriendlyDescription;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.EByteBlowerObject;

class UserFriendlyPortDescription
implements UserFriendlyDescription {
    private final ByteBlowerGuiPort port;

    static UserFriendlyPortDescription empty() {
        return new UserFriendlyPortDescription(null){

            @Override
            public String toString() {
                return "No ports configured";
            }
        };
    }

    public UserFriendlyPortDescription(ByteBlowerGuiPort port) {
        this.port = port;
    }

    public ByteBlowerGuiPort getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        if (this.port.isSetIpv6Configuration() && this.port.getIpv6Configuration().getIsActive().booleanValue()) {
            return "[IPv6] " + this.port.getName();
        }
        return "[IPv4] " + this.port.getName();
    }

    @Override
    public EByteBlowerObject get() {
        return this.getPort();
    }

    @Override
    public boolean isCreation() {
        return false;
    }

    public static class PortIPv4Create
    extends UserFriendlyPortDescription {
        public PortIPv4Create() {
            super(null);
        }

        @Override
        public String toString() {
            return "New IPv4 ByteBlower Port...";
        }

        @Override
        public boolean isCreation() {
            return true;
        }

        public int hashCode() {
            return 2;
        }

        public boolean equals(Object obj) {
            return obj instanceof PortIPv4Create;
        }
    }

    public static class PortIPv6Create
    extends UserFriendlyPortDescription {
        public PortIPv6Create() {
            super(null);
        }

        @Override
        public String toString() {
            return "New IPv6 ByteBlower Port...";
        }

        @Override
        public boolean isCreation() {
            return true;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof PortIPv6Create;
        }
    }
}

