/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.frame.FrameOverviewControl;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

class FrameCellModifier
implements ICellModifier {
    private FrameOverviewControl frameOverviewControl;

    public FrameCellModifier(FrameOverviewControl frameOverviewControl) {
        this.frameOverviewControl = frameOverviewControl;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.frameOverviewControl.getColumnIndex(property);
        Object result = null;
        Frame frameBlasting = (Frame)element;
        switch (columnIndex) {
            case 0: {
                result = frameBlasting.getName();
                break;
            }
            case 1: {
                result = frameBlasting.getBytesHexString().length() / 2;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.frameOverviewControl.getColumnIndex(property);
        TableItem item = (TableItem)element;
        Frame frame = (Frame)item.getData();
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                String newName = ((String)value).trim();
                if (!OldNamingTools.nameIsUnique((EObject)frame, (String)newName)) break;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Frame Name", (EByteBlowerObject)frame, ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME, (Object)newName);
                operation.run();
                break;
            }
            case 1: {
                this.changeLength(frame, (Integer)value);
                break;
            }
            default: {
                System.out.println("invalid case !");
                return;
            }
        }
    }

    private void changeLength(Frame frame, int newLength) {
        if (newLength >= 60 && newLength <= 8192) {
            Command command = ControllerFactory.create((Frame)frame).setFrameSize(newLength);
            ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Size of the frame");
            operation.appendCommand(command);
            operation.run();
        }
    }
}

