/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerViewPart;
import com.excentis.products.byteblower.gui.views.frame.FrameAdapter;
import com.excentis.products.byteblower.gui.views.frame.FrameOverviewControl;
import com.excentis.products.byteblower.gui.views.frame.SettingsComposite;
import com.excentis.products.byteblower.gui.views.hex.gui.HexEditorControl;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class FrameView
extends ByteBlowerViewPart {
    public static final String ID = "com.excentis.products.byteblower.gui.views.FrameView";
    private static final int[] topWeights = new int[]{1, 2, 2};
    private FrameController frameController;
    private FrameAdapter frameAdapter = new FrameAdapter(this);
    private FrameOverviewControl framesComposite;
    private SettingsComposite settingsComposite;
    private HexEditorControl hexEditorControl;
    private boolean updating = false;

    @Override
    protected int[] getTopWeights() {
        return topWeights;
    }

    public HexEditorControl getHexEditorControl() {
        return this.hexEditorControl;
    }

    public void hiliteShiftSelection() {
        this.hexEditorControl.hiliteShiftSelection();
    }

    @Override
    protected ByteBlowerComposite createTopLeftControl(Composite parent) {
        this.framesComposite = new FrameOverviewControl(parent, this);
        return this.framesComposite;
    }

    @Override
    protected ByteBlowerComposite createTopMiddleControl(Composite parent) {
        this.settingsComposite = new SettingsComposite(this, parent);
        this.framesComposite.addSelectionListener((IByteBlowerComposite)this.settingsComposite);
        return this.settingsComposite;
    }

    @Override
    protected ByteBlowerComposite createTopRightControl(Composite parent) {
        this.hexEditorControl = new HexEditorControl(this, parent);
        this.framesComposite.addSelectionListener((IByteBlowerComposite)this.hexEditorControl);
        return this.hexEditorControl;
    }

    public FrameController getFrameController() {
        return this.frameController;
    }

    public Frame getFrame() {
        return this.frameController == null ? null : this.frameController.getFrame();
    }

    public void setSelectedFrame(Frame frame) {
        if (frame == null) {
            this.frameController = null;
        } else {
            if (this.frameController != null) {
                Frame previousFrame = this.frameController.getFrame();
                previousFrame.eAdapters().remove((Object)this.frameAdapter);
            }
            frame.eAdapters().add((Object)this.frameAdapter);
            this.frameController = ControllerFactory.create((Frame)frame);
        }
    }

    public void executeCommand(Command command) {
        if (command == null) {
            return;
        }
        ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Frame");
        operation.appendCommand(command);
        operation.run();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    void notifyChangedBytes(Frame frame) {
        if (this.getFrame() != frame) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FrameView.this.update();
            }
        });
    }

    private void startUpdate() {
        this.updating = true;
        if (this.frameController != null) {
            this.frameController.update();
        }
    }

    private void update() {
        if (this.getFrameComposite().isDisposed()) {
            return;
        }
        try {
            this.startUpdate();
            this.hexEditorControl.update();
            this.settingsComposite.updateVisibleLayer();
        }
        finally {
            this.updating = false;
        }
    }

    public static void showAndSelect(Frame frame) {
        FrameView view = FrameView.showFrameView();
        view.getFrameComposite().selectAndReveal(frame);
    }

    private FrameOverviewControl getFrameComposite() {
        return (FrameOverviewControl)this.getTopLeft();
    }

    public IByteBlowerComposite getFrameTableComposite() {
        return this.getTopLeft();
    }
}

