/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.MacAddressTextFactory;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frame.Layer3Composite;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Layer2Composite
extends FrameComposite {
    private ScrolledComposite l2ScrolledComposite;
    private Composite ethernetComposite;
    private Composite ethernetErrorComposite;
    private Label lblEthernetVersion;
    private Text textDestMac;
    private Text textSourceMac;
    private Button radioL2TypePredefined;
    private Text textL3Type;
    private Combo cmbL2Type;
    private Button radioL2DestAutomatic;
    private Button radioL2DestManual;
    private Button radioL2SourceAutomatic;
    private Button radioL2SourceManual;
    private Text textL2TotLenManual;
    private Button radioL2TypeManual;
    private Label errorL2;
    private Text textL2TotLenManualError;

    public Layer2Composite(Composite parent, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.lblEthernetVersion = new Label((Composite)this, 0);
        new Button((Composite)this, 0).setVisible(false);
        this.l2ScrolledComposite = new ScrolledComposite((Composite)this, 2816);
        this.lblEthernetVersion.setText(Messages.getString("FrameView.L2.EthernetVersion"));
        this.lblEthernetVersion.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.l2ScrolledComposite.setLayoutData((Object)gridData);
        this.l2ScrolledComposite.setLayout((Layout)new GridLayout());
        this.createL2_EthernetSettings();
        this.l2ScrolledComposite.setExpandHorizontal(true);
        this.l2ScrolledComposite.setExpandVertical(true);
        this.layout();
    }

    private void createErrorComposite() {
        this.ethernetErrorComposite = new Composite((Composite)this.l2ScrolledComposite, 0);
        this.ethernetErrorComposite.setLayoutData((Object)new GridData(1808));
        this.ethernetErrorComposite.setLayout((Layout)new GridLayout());
        this.errorL2 = new Label(this.ethernetErrorComposite, 0);
        this.errorL2.setLayoutData((Object)new GridData(768));
        this.errorL2.setText("\n\n");
        Composite compL2TotLen = new Composite(this.ethernetErrorComposite, 2048);
        compL2TotLen.setLayoutData((Object)new GridData(768));
        compL2TotLen.setLayout((Layout)new GridLayout(3, false));
        Label lblL2TotLen = new Label(compL2TotLen, 0);
        lblL2TotLen.setText(Messages.getString("FrameView.L2.TotalLength"));
        this.textL2TotLenManualError = new Text(compL2TotLen, 2048);
        this.textL2TotLenManualError.setLayoutData((Object)new GridData(768));
        this.textL2TotLenManualError.setTextLimit(4);
        this.textL2TotLenManualError.setEnabled(true);
        this.textL2TotLenManualError.addFocusListener((FocusListener)this);
        this.textL2TotLenManualError.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int keyCode = keyEvent.keyCode;
                if (keyCode == 13 || keyCode == 0x1000050) {
                    Layer2Composite.this.changeFrameLength(Layer2Composite.this.textL2TotLenManualError.getText());
                }
            }
        });
    }

    private void createL2_EthernetSettings() {
        this.createErrorComposite();
        this.ethernetComposite = new Composite((Composite)this.l2ScrolledComposite, 0);
        this.ethernetComposite.setLayoutData((Object)new GridData(1808));
        this.ethernetComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblL2Dest = new Label(this.ethernetComposite, 0);
        lblL2Dest.setText(Messages.getString("FrameView.L2.Dest"));
        Composite compL2Dest = new Composite(this.ethernetComposite, 2048);
        compL2Dest.setLayoutData((Object)new GridData(768));
        compL2Dest.setLayout((Layout)new GridLayout(2, false));
        this.radioL2DestAutomatic = new Button(compL2Dest, 16);
        this.radioL2DestAutomatic.setText(Messages.getString("FrameView.L2.Automatic"));
        Label invisiblefill = new Label(compL2Dest, 0);
        invisiblefill.setVisible(false);
        this.radioL2DestManual = new Button(compL2Dest, 16);
        this.radioL2DestManual.setText(Messages.getString("FrameView.L2.Manual"));
        this.radioL2DestAutomatic.setSelection(true);
        this.textDestMac = MacAddressTextFactory.instance().create(compL2Dest, 2048);
        this.textDestMac.setLayoutData((Object)new GridData(768));
        this.textDestMac.setEnabled(false);
        this.textDestMac.addModifyListener((ModifyListener)this);
        this.radioL2DestManual.addMouseListener((MouseListener)this);
        this.radioL2DestAutomatic.addMouseListener((MouseListener)this);
        Label lblL2Source = new Label(this.ethernetComposite, 0);
        lblL2Source.setText(Messages.getString("FrameView.L2.Source"));
        Composite compL2Source = new Composite(this.ethernetComposite, 2048);
        compL2Source.setLayoutData((Object)new GridData(768));
        compL2Source.setLayout((Layout)new GridLayout(2, false));
        this.radioL2SourceAutomatic = new Button(compL2Source, 16);
        this.radioL2SourceAutomatic.setText(Messages.getString("FrameView.L2.Automatic"));
        Label invisiblefill2 = new Label(compL2Source, 0);
        invisiblefill2.setVisible(false);
        this.radioL2SourceManual = new Button(compL2Source, 16);
        this.radioL2SourceManual.setText(Messages.getString("FrameView.L2.Manual"));
        this.radioL2SourceAutomatic.setSelection(true);
        this.textSourceMac = MacAddressTextFactory.instance().create(compL2Source, 2048);
        this.textSourceMac.setLayoutData((Object)new GridData(768));
        this.textSourceMac.setEnabled(false);
        this.textSourceMac.addModifyListener((ModifyListener)this);
        this.radioL2SourceManual.addMouseListener((MouseListener)this);
        this.radioL2SourceAutomatic.addMouseListener((MouseListener)this);
        Label lblL2Type = new Label(this.ethernetComposite, 0);
        lblL2Type.setText(Messages.getString("FrameView.L2.Type"));
        Composite compL2Type = new Composite(this.ethernetComposite, 2048);
        compL2Type.setLayoutData((Object)new GridData(768));
        compL2Type.setLayout((Layout)new GridLayout(2, false));
        this.radioL2TypePredefined = new Button(compL2Type, 16);
        this.radioL2TypePredefined.setText(Messages.getString("FrameView.L2.Predefined"));
        this.cmbL2Type = new Combo(compL2Type, 2056);
        GridData gridData = new GridData(768);
        this.cmbL2Type.setLayoutData((Object)gridData);
        int i = 0;
        while (i < Layer3Composite.L3Types.length) {
            this.cmbL2Type.add(Layer3Composite.L3Types[i]);
            ++i;
        }
        this.cmbL2Type.select(0);
        this.cmbL2Type.addSelectionListener((SelectionListener)this);
        this.radioL2TypeManual = new Button(compL2Type, 16);
        this.radioL2TypeManual.setText("Manual (hex):");
        this.textL3Type = HexTextFactory.create((Composite)compL2Type, (int)2048, (int)4);
        this.textL3Type.setLayoutData((Object)new GridData(768));
        this.textL3Type.setEnabled(false);
        this.textL3Type.addModifyListener((ModifyListener)this);
        this.radioL2TypePredefined.addMouseListener((MouseListener)this);
        this.radioL2TypeManual.addMouseListener((MouseListener)this);
        Label lblL2TotLen = new Label(this.ethernetComposite, 0);
        lblL2TotLen.setText(Messages.getString("FrameView.L2.TotalLength"));
        Composite compL2TotLen = new Composite(this.ethernetComposite, 2048);
        compL2TotLen.setLayoutData((Object)new GridData(768));
        compL2TotLen.setLayout((Layout)new GridLayout(2, false));
        this.textL2TotLenManual = IntegerTextFactory.instance().create(compL2TotLen, 60L, 8192L);
        this.textL2TotLenManual.setLayoutData((Object)new GridData(768));
        this.textL2TotLenManual.setEnabled(true);
        this.textL2TotLenManual.addFocusListener((FocusListener)this);
        this.textL2TotLenManual.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int keyCode = keyEvent.keyCode;
                if (keyCode == 13 || keyCode == 0x1000050) {
                    Layer2Composite.this.changeFrameLength(Layer2Composite.this.textL2TotLenManual.getText());
                }
            }
        });
    }

    private EthernetPacket getEthernet() {
        return this.frameView.getFrameController().getEthernet();
    }

    private void updateL2TypeCombo() {
        EthernetPacket ethernet = this.getEthernet();
        int type = ethernet.getType();
        boolean predef = true;
        switch (type) {
            case 2048: {
                predef = true;
                this.cmbL2Type.select(1);
                break;
            }
            case 34525: {
                predef = true;
                this.cmbL2Type.select(2);
                break;
            }
            case 2054: {
                predef = true;
                this.cmbL2Type.select(0);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioL2TypePredefined.setSelection(predef);
        this.cmbL2Type.setEnabled(predef);
        this.radioL2TypeManual.setSelection(!predef);
        this.textL3Type.setEnabled(!predef);
    }

    private void updateL2TypeText(int selectedIndex) {
        StringBuilder type = new StringBuilder();
        switch (selectedIndex) {
            case 1: {
                type.append(Integer.toHexString(2048).toUpperCase());
                break;
            }
            case 2: {
                type.append(Integer.toHexString(34525).toUpperCase());
                break;
            }
            case 0: {
                type.append(Integer.toHexString(2054).toUpperCase());
                break;
            }
        }
        while (type.length() < 4) {
            type.insert(0, "0");
        }
        this.textL3Type.setText(type.toString());
    }

    public void updateL2() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        boolean enable = (frame = this.frameView.getFrame()) != null;
        this.lblEthernetVersion.setVisible(enable);
        this.l2ScrolledComposite.setVisible(enable);
        if (enable) {
            EthernetPacket ethernet = this.getEthernet();
            boolean error = ethernet.isInvalid();
            if (error) {
                this.updateL2EthernetErrorComposite(frame);
            } else {
                this.updateL2EthernetComposite(frame, ethernet);
            }
        }
    }

    private void updateL2EthernetComposite(Frame frame, EthernetPacket ethernet) {
        if (this.l2ScrolledComposite.getContent() != this.ethernetComposite) {
            Point pt = this.ethernetComposite.computeSize(-1, -1);
            this.l2ScrolledComposite.setMinWidth(pt.x);
            this.l2ScrolledComposite.setMinHeight(pt.y);
            this.setContent(this.ethernetComposite);
        }
        boolean autoDestMac = frame.getL2AutoDestMac();
        this.radioL2DestAutomatic.setSelection(autoDestMac);
        this.radioL2DestManual.setSelection(!autoDestMac);
        this.textDestMac.setEnabled(!autoDestMac);
        int caretPos = this.textDestMac.getCaretPosition();
        this.textDestMac.setText(ethernet.getDA());
        this.textDestMac.setSelection(caretPos, caretPos);
        boolean autoSourceMac = frame.getL2AutoSourceMac();
        this.radioL2SourceAutomatic.setSelection(autoSourceMac);
        this.radioL2SourceManual.setSelection(!autoSourceMac);
        this.textSourceMac.setEnabled(!autoSourceMac);
        caretPos = this.textSourceMac.getCaretPosition();
        this.textSourceMac.setText(ethernet.getSA());
        this.textSourceMac.setSelection(caretPos, caretPos);
        int l3Type = ethernet.getType();
        String type = Integer.toHexString(l3Type).toUpperCase();
        while (type.length() != 4) {
            type = "0" + type;
        }
        caretPos = this.textL3Type.getCaretPosition();
        this.textL3Type.setText(type);
        this.textL3Type.setSelection(caretPos, caretPos);
        this.updateL2TypeCombo();
        int ethernetSize = ethernet.getSize() / 8;
        if (frame.getBytesHexString().length() / 2 != ethernetSize) {
            System.out.println("ERROR : ETHERNETSIZE != BYTEHEXSTRING :" + ethernetSize + "    " + frame.getBytesHexString().length() / 2);
        }
        caretPos = this.textL2TotLenManual.getCaretPosition();
        this.textL2TotLenManual.setText(Integer.toString(ethernetSize));
        this.textL2TotLenManual.setSelection(caretPos, caretPos);
    }

    private void updateL2EthernetErrorComposite(Frame frame) {
        int frameBitSize;
        if (this.l2ScrolledComposite.getContent() != this.ethernetErrorComposite) {
            Point pt = this.ethernetErrorComposite.computeSize(-1, -1);
            this.l2ScrolledComposite.setMinWidth(pt.x);
            this.l2ScrolledComposite.setMinHeight(pt.y);
            this.setContent(this.ethernetErrorComposite);
        }
        if ((frameBitSize = frame.getBytesHexString().length() * 4) < 480) {
            this.errorL2.setText(Messages.getString("FrameView.Error.L2.TooSmall"));
        } else if (frameBitSize > 65536) {
            this.errorL2.setText(Messages.getString("FrameView.Error.L2.TooBig"));
        }
        int caretPos = this.textL2TotLenManualError.getCaretPosition();
        int frameSize = this.frameView.getFrameController().getByteSize(ThroughputType.FRAME_ONLY);
        this.textL2TotLenManualError.setText(Integer.toString(frameSize));
        this.textL2TotLenManualError.setSelection(caretPos, caretPos);
    }

    private void setContent(Composite composite) {
        Point pt = composite.computeSize(-1, -1);
        this.l2ScrolledComposite.setMinWidth(pt.x);
        this.l2ScrolledComposite.setMinHeight(pt.y);
        this.l2ScrolledComposite.setContent((Control)composite);
        this.l2ScrolledComposite.pack();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!Layer2Composite.this.l2ScrolledComposite.isDisposed() && !Layer2Composite.this.isDisposed()) {
                    Layer2Composite.this.l2ScrolledComposite.layout();
                    Layer2Composite.this.layout();
                }
            }
        });
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        FrameController frameController = this.getFrameController();
        Command command = null;
        if (control == this.textDestMac) {
            String destMac = this.textDestMac.getText();
            if (MacAddressController.isComplete((String)destMac)) {
                command = frameController.setEthernetDA(destMac);
            }
        } else if (control == this.textSourceMac) {
            String sourceMac = this.textSourceMac.getText();
            if (MacAddressController.isComplete((String)sourceMac)) {
                command = frameController.setEthernetSA(sourceMac);
            }
        } else if (control == this.textL3Type && HexTextFactory.checkComplete((Text)this.textL3Type)) {
            int newType = Integer.valueOf(this.textL3Type.getText(), 16);
            command = frameController.setL2Type(newType);
        }
        this.frameView.executeCommand(command);
    }

    @Override
    protected Command handleControlEvent(Control control) {
        Command command = null;
        if (control == this.radioL2DestAutomatic) {
            command = this.getFrameController().setL2AutoDestMac(Boolean.TRUE);
        } else if (control == this.radioL2DestManual) {
            command = this.getFrameController().setL2AutoDestMac(Boolean.FALSE);
        } else if (control == this.radioL2SourceAutomatic) {
            command = this.getFrameController().setL2AutoSourceMac(Boolean.TRUE);
        } else if (control == this.radioL2SourceManual) {
            command = this.getFrameController().setL2AutoSourceMac(Boolean.FALSE);
        } else if (control == this.radioL2TypePredefined || control == this.cmbL2Type) {
            this.updateL2TypeText(this.cmbL2Type.getSelectionIndex());
            int newType = Integer.valueOf(this.textL3Type.getText(), 16);
            this.textL3Type.setEnabled(false);
            command = this.getFrameController().setL2Type(newType);
        } else if (control == this.radioL2TypeManual) {
            this.textL3Type.setEnabled(true);
        }
        return command;
    }

    public void focusLost(FocusEvent e) {
        if (this.getFrameController() == null) {
            return;
        }
        Control control = (Control)e.widget;
        if (control == this.textL2TotLenManual) {
            this.changeFrameLength(this.textL2TotLenManual.getText());
            control.getParent().setFocus();
        }
    }

    private void changeFrameLength(String input) {
        int newLength;
        if (!input.isEmpty() && (newLength = Integer.parseInt(input)) >= 60 && newLength <= 8192) {
            Command command = this.getFrameController().setFrameSize(newLength);
            this.frameView.executeCommand(command);
        }
    }
}

