/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.FrameController;
import java.math.BigInteger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Layer4_TcpComposite
extends FrameComposite {
    private Label lblTcpSPA;
    private Text txtTcpSPA;
    private Label lblTcpDPA;
    private Text txtTcpDPA;
    private Label lblTcpSeqNr;
    private Text txtTcpSeqNr;
    private Label lblTcpAckNr;
    private Text txtTcpAckNr;
    private Label lblTcpDataOffset;
    private Text txtTcpDataOffset;
    private Label lblTcpReserved;
    private Text txtTcpReserved;
    private Label lblTcpFlags;
    private Composite compTcpFlags;
    private Button checkTcpFlagCWR;
    private Button checkTcpFlagECE;
    private Button checkTcpFlagURG;
    private Button checkTcpFlagACK;
    private Button checkTcpFlagPSH;
    private Button checkTcpFlagRST;
    private Button checkTcpFlagSYN;
    private Button checkTcpFlagFIN;
    private Label lblTcpWindowSize;
    private Text txtTcpWindowSize;
    private Label lblTcpCheckSum;
    private Composite compTcpCheckSum;
    private Button radioTcpCheckSumAutomatic;
    private Button radioTcpCheckSumManual;
    private Text txtTcpCheckSumManual;
    private Label lblTcpUrgentPointer;
    private Text txtTcpUrgentPointer;
    private Composite composite;

    public Layer4_TcpComposite(Composite parent, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout());
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.lblTcpSPA = new Label(this.composite, 0);
        this.lblTcpSPA.setText(Messages.getString("FrameView.L4.Tcp.SPA"));
        this.txtTcpSPA = IntegerTextFactory.instance().create(this.composite, 65535L);
        this.txtTcpSPA.setLayoutData((Object)new GridData(768));
        this.txtTcpSPA.addModifyListener((ModifyListener)this);
        this.txtTcpSPA.addFocusListener((FocusListener)this);
        this.lblTcpDPA = new Label(this.composite, 0);
        this.lblTcpDPA.setText(Messages.getString("FrameView.L4.Tcp.DPA"));
        this.txtTcpDPA = IntegerTextFactory.instance().create(this.composite, 65535L);
        this.txtTcpDPA.setLayoutData((Object)new GridData(768));
        this.txtTcpDPA.addModifyListener((ModifyListener)this);
        this.txtTcpDPA.addFocusListener((FocusListener)this);
        this.lblTcpSeqNr = new Label(this.composite, 0);
        this.lblTcpSeqNr.setText(Messages.getString("FrameView.L4.Tcp.SeqNr"));
        this.txtTcpSeqNr = HexTextFactory.create((Composite)this.composite, (int)2048, (int)8);
        this.txtTcpSeqNr.setLayoutData((Object)new GridData(768));
        this.txtTcpSeqNr.addModifyListener((ModifyListener)this);
        this.txtTcpSeqNr.addFocusListener((FocusListener)this);
        this.lblTcpAckNr = new Label(this.composite, 0);
        this.lblTcpAckNr.setText(Messages.getString("FrameView.L4.Tcp.AckNr"));
        this.txtTcpAckNr = HexTextFactory.create((Composite)this.composite, (int)2048, (int)8);
        this.txtTcpAckNr.setLayoutData((Object)new GridData(768));
        this.txtTcpAckNr.addModifyListener((ModifyListener)this);
        this.txtTcpAckNr.addFocusListener((FocusListener)this);
        this.lblTcpDataOffset = new Label(this.composite, 0);
        this.lblTcpDataOffset.setText(Messages.getString("FrameView.L4.Tcp.DataOffset"));
        this.txtTcpDataOffset = HexTextFactory.create((Composite)this.composite, (int)2048, (int)1);
        this.txtTcpDataOffset.setLayoutData((Object)new GridData(768));
        this.txtTcpDataOffset.addModifyListener((ModifyListener)this);
        this.txtTcpDataOffset.addFocusListener((FocusListener)this);
        this.lblTcpReserved = new Label(this.composite, 0);
        this.lblTcpReserved.setText(Messages.getString("FrameView.L4.Tcp.Reserved"));
        this.txtTcpReserved = HexTextFactory.create((Composite)this.composite, (int)2048, (int)1);
        this.txtTcpReserved.setLayoutData((Object)new GridData(768));
        this.txtTcpReserved.addModifyListener((ModifyListener)this);
        this.txtTcpReserved.addFocusListener((FocusListener)this);
        this.lblTcpFlags = new Label(this.composite, 0);
        this.lblTcpFlags.setText(Messages.getString("FrameView.L4.Tcp.Flags"));
        this.compTcpFlags = new Composite(this.composite, 2048);
        this.compTcpFlags.setLayoutData((Object)new GridData(768));
        this.compTcpFlags.setLayout((Layout)new GridLayout(2, false));
        this.checkTcpFlagCWR = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagCWR.setText(Messages.getString("FrameView.L4.Tcp.Flag.CWR"));
        this.checkTcpFlagCWR.addSelectionListener((SelectionListener)this);
        Label info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.CWR.info"));
        this.checkTcpFlagECE = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagECE.setText(Messages.getString("FrameView.L4.Tcp.Flag.ECE"));
        this.checkTcpFlagECE.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.ECE.info"));
        this.checkTcpFlagURG = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagURG.setText(Messages.getString("FrameView.L4.Tcp.Flag.URG"));
        this.checkTcpFlagURG.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.URG.info"));
        this.checkTcpFlagACK = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagACK.setText(Messages.getString("FrameView.L4.Tcp.Flag.ACK"));
        this.checkTcpFlagACK.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.ACK.info"));
        this.checkTcpFlagPSH = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagPSH.setText(Messages.getString("FrameView.L4.Tcp.Flag.PSH"));
        this.checkTcpFlagPSH.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.PSH.info"));
        this.checkTcpFlagRST = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagRST.setText(Messages.getString("FrameView.L4.Tcp.Flag.RST"));
        this.checkTcpFlagRST.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.RST.info"));
        this.checkTcpFlagSYN = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagSYN.setText(Messages.getString("FrameView.L4.Tcp.Flag.SYN"));
        this.checkTcpFlagSYN.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.SYN.info"));
        this.checkTcpFlagFIN = new Button(this.compTcpFlags, 32);
        this.checkTcpFlagFIN.setText(Messages.getString("FrameView.L4.Tcp.Flag.FIN"));
        this.checkTcpFlagFIN.addSelectionListener((SelectionListener)this);
        info = new Label(this.compTcpFlags, 0);
        info.setText(Messages.getString("FrameView.L4.Tcp.Flag.FIN.info"));
        this.lblTcpWindowSize = new Label(this.composite, 0);
        this.lblTcpWindowSize.setText(Messages.getString("FrameView.L4.Tcp.WindowSize"));
        this.txtTcpWindowSize = HexTextFactory.create((Composite)this.composite, (int)2048, (int)4);
        this.txtTcpWindowSize.setLayoutData((Object)new GridData(768));
        this.txtTcpWindowSize.addModifyListener((ModifyListener)this);
        this.txtTcpWindowSize.addFocusListener((FocusListener)this);
        this.lblTcpCheckSum = new Label(this.composite, 0);
        this.lblTcpCheckSum.setText(Messages.getString("FrameView.L4.Tcp.Checksum"));
        this.compTcpCheckSum = new Composite(this.composite, 2048);
        this.compTcpCheckSum.setLayoutData((Object)new GridData(768));
        this.compTcpCheckSum.setLayout((Layout)new GridLayout(2, false));
        this.radioTcpCheckSumAutomatic = new Button(this.compTcpCheckSum, 16);
        this.radioTcpCheckSumAutomatic.setText(Messages.getString("FrameView.L4.Tcp.Automatic"));
        this.radioTcpCheckSumAutomatic.addMouseListener((MouseListener)this);
        Label lblDummy = new Label(this.compTcpCheckSum, 0);
        lblDummy.setVisible(false);
        this.radioTcpCheckSumManual = new Button(this.compTcpCheckSum, 16);
        this.radioTcpCheckSumManual.setText("Manual (hex):");
        this.radioTcpCheckSumManual.addMouseListener((MouseListener)this);
        this.txtTcpCheckSumManual = HexTextFactory.create((Composite)this.compTcpCheckSum, (int)2048, (int)4);
        this.txtTcpCheckSumManual.setLayoutData((Object)new GridData(768));
        this.txtTcpCheckSumManual.addModifyListener((ModifyListener)this);
        this.txtTcpCheckSumManual.addFocusListener((FocusListener)this);
        this.lblTcpUrgentPointer = new Label(this.composite, 0);
        this.lblTcpUrgentPointer.setText(Messages.getString("FrameView.L4.Tcp.UrgentPointer"));
        this.txtTcpUrgentPointer = HexTextFactory.create((Composite)this.composite, (int)2048, (int)4);
        this.txtTcpUrgentPointer.setLayoutData((Object)new GridData(768));
        this.txtTcpUrgentPointer.addModifyListener((ModifyListener)this);
        this.txtTcpUrgentPointer.addFocusListener((FocusListener)this);
        this.layout();
    }

    public void updateL4_TcpSettings() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if ((frame = this.frameView.getFrame()) == null) {
            return;
        }
        FrameController controller = this.getFrameController();
        TCPPacket tcp = controller.getCurrentTcp();
        String source = Integer.toString(tcp.getSource()).toUpperCase();
        int caretPos = this.txtTcpSPA.getCaretPosition();
        this.txtTcpSPA.setText(source);
        this.txtTcpSPA.setSelection(caretPos, caretPos);
        String dest = Integer.toString(tcp.getDestination()).toUpperCase();
        caretPos = this.txtTcpDPA.getCaretPosition();
        this.txtTcpDPA.setText(dest);
        this.txtTcpDPA.setSelection(caretPos, caretPos);
        String seq = Long.toHexString(tcp.getSequence()).toUpperCase();
        while (seq.length() < 8) {
            seq = "0" + seq;
        }
        caretPos = this.txtTcpSeqNr.getCaretPosition();
        this.txtTcpSeqNr.setText(seq);
        this.txtTcpSeqNr.setSelection(caretPos, caretPos);
        String ack = Long.toHexString(tcp.getACK()).toUpperCase();
        while (ack.length() < 8) {
            ack = "0" + ack;
        }
        caretPos = this.txtTcpAckNr.getCaretPosition();
        this.txtTcpAckNr.setText(ack);
        this.txtTcpAckNr.setSelection(caretPos, caretPos);
        String offset = Integer.toHexString(tcp.getDataOffset()).toUpperCase();
        caretPos = this.txtTcpDataOffset.getCaretPosition();
        this.txtTcpDataOffset.setText(offset);
        this.txtTcpDataOffset.setSelection(caretPos, caretPos);
        String reserved = Integer.toHexString(tcp.getReserved()).toUpperCase();
        caretPos = this.txtTcpReserved.getCaretPosition();
        this.txtTcpReserved.setText(reserved);
        this.txtTcpReserved.setSelection(caretPos, caretPos);
        String flags = tcp.getFlags();
        this.checkTcpFlagCWR.setSelection(flags.indexOf("CWR") != -1);
        this.checkTcpFlagECE.setSelection(flags.indexOf("ECE") != -1);
        this.checkTcpFlagURG.setSelection(flags.indexOf("URG") != -1);
        this.checkTcpFlagACK.setSelection(flags.indexOf("ACK") != -1);
        this.checkTcpFlagPSH.setSelection(flags.indexOf("PSH") != -1);
        this.checkTcpFlagRST.setSelection(flags.indexOf("RST") != -1);
        this.checkTcpFlagSYN.setSelection(flags.indexOf("SYN") != -1);
        this.checkTcpFlagFIN.setSelection(flags.indexOf("FIN") != -1);
        String window = Integer.toHexString(tcp.getWindow()).toUpperCase();
        while (window.length() < 4) {
            window = "0" + window;
        }
        caretPos = this.txtTcpWindowSize.getCaretPosition();
        this.txtTcpWindowSize.setText(window);
        this.txtTcpWindowSize.setSelection(caretPos, caretPos);
        boolean auto = frame.getL4AutoTcpChecksum();
        this.radioTcpCheckSumAutomatic.setSelection(auto);
        this.radioTcpCheckSumManual.setSelection(!auto);
        this.txtTcpCheckSumManual.setEnabled(!auto);
        int realCheck = tcp.getCheckSum();
        String checksum = Integer.toHexString(realCheck).toUpperCase();
        while (checksum.length() < 4) {
            checksum = "0" + checksum;
        }
        caretPos = this.txtTcpCheckSumManual.getCaretPosition();
        this.txtTcpCheckSumManual.setText(checksum);
        this.txtTcpCheckSumManual.setSelection(caretPos, caretPos);
        String urgent = Integer.toHexString(tcp.getUrgent()).toUpperCase();
        while (urgent.length() < 4) {
            urgent = "0" + urgent;
        }
        caretPos = this.txtTcpUrgentPointer.getCaretPosition();
        this.txtTcpUrgentPointer.setText(urgent);
        this.txtTcpUrgentPointer.setSelection(caretPos, caretPos);
        this.composite.redraw();
        this.composite.layout(true);
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        FrameController controller = this.frameView.getFrameController();
        Command command = null;
        if (control == this.txtTcpSPA) {
            String SPA = this.txtTcpSPA.getText();
            if (SPA.length() != 0) {
                int intSpa = Integer.valueOf(SPA);
                command = controller.setTcpSource(intSpa);
            }
        } else if (control == this.txtTcpDPA) {
            String DPA = this.txtTcpDPA.getText();
            if (DPA.length() != 0) {
                int intDpa = Integer.valueOf(DPA);
                command = controller.setTcpDestination(intDpa);
            }
        } else if (control == this.txtTcpSeqNr) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpSeqNr)) {
                String text = this.txtTcpSeqNr.getText();
                BigInteger bigint = new BigInteger(text, 16);
                long longValue = bigint.longValue();
                command = controller.setTcpSequence(longValue);
            }
        } else if (control == this.txtTcpAckNr) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpAckNr)) {
                String text = this.txtTcpAckNr.getText();
                BigInteger bigint = new BigInteger(text, 16);
                int intValue = bigint.intValue();
                command = controller.setTcpACK(intValue);
            }
        } else if (control == this.txtTcpDataOffset) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpDataOffset)) {
                String text = this.txtTcpDataOffset.getText();
                int intValue = Integer.valueOf(text, 16);
                command = controller.setTcpDataOffset(intValue);
            }
        } else if (control == this.txtTcpReserved) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpReserved)) {
                String text = this.txtTcpReserved.getText();
                int intValue = Integer.valueOf(text, 16);
                command = controller.setTcpReserved(intValue);
            }
        } else if (control == this.txtTcpWindowSize) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpWindowSize)) {
                String text = this.txtTcpWindowSize.getText();
                BigInteger bigint = new BigInteger(text, 16);
                int intValue = bigint.intValue();
                command = controller.setTcpWindow(intValue);
            }
        } else if (control == this.txtTcpCheckSumManual) {
            if (HexTextFactory.checkComplete((Text)this.txtTcpCheckSumManual)) {
                String text = this.txtTcpCheckSumManual.getText();
                int intValue = Integer.valueOf(text, 16);
                command = controller.setTcpCheckSum(intValue);
            }
        } else if (control == this.txtTcpUrgentPointer && HexTextFactory.checkComplete((Text)this.txtTcpUrgentPointer)) {
            String text = this.txtTcpUrgentPointer.getText();
            int intValue = Integer.valueOf(text, 16);
            command = controller.setTcpUrgent(intValue);
        }
        this.frameView.executeCommand(command);
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    Command handleControlEvent(Control control) {
        FrameController frameController = this.getFrameController();
        Command command = null;
        if (control == this.radioTcpCheckSumAutomatic) {
            command = frameController.setL4AutoTcpChecksum();
        } else if (control == this.radioTcpCheckSumManual) {
            command = frameController.setL4AutoTcpChecksum(Boolean.FALSE);
        } else if (control == this.checkTcpFlagCWR) {
            command = frameController.setTcpFlag("CWR", this.checkTcpFlagCWR.getSelection());
        } else if (control == this.checkTcpFlagECE) {
            command = frameController.setTcpFlag("ECE", this.checkTcpFlagECE.getSelection());
        } else if (control == this.checkTcpFlagURG) {
            command = frameController.setTcpFlag("URG", this.checkTcpFlagURG.getSelection());
        } else if (control == this.checkTcpFlagACK) {
            command = frameController.setTcpFlag("ACK", this.checkTcpFlagACK.getSelection());
        } else if (control == this.checkTcpFlagPSH) {
            command = frameController.setTcpFlag("PSH", this.checkTcpFlagPSH.getSelection());
        } else if (control == this.checkTcpFlagRST) {
            command = frameController.setTcpFlag("RST", this.checkTcpFlagRST.getSelection());
        } else if (control == this.checkTcpFlagSYN) {
            command = frameController.setTcpFlag("SYN", this.checkTcpFlagSYN.getSelection());
        } else if (control == this.checkTcpFlagFIN) {
            command = frameController.setTcpFlag("FIN", this.checkTcpFlagFIN.getSelection());
        }
        return command;
    }
}

