/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameFieldModifier;
import com.excentis.products.byteblower.model.FrameL3Type;
import com.excentis.products.byteblower.model.IncrementalFieldModifier;
import com.excentis.products.byteblower.model.RandomFieldModifier;
import com.excentis.products.byteblower.model.UniqueFieldModifier;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.control.FrameFieldModifierController;
import com.excentis.products.byteblower.model.control.IncrementalFieldModifierController;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

class Layer4_UdpComposite
extends FrameComposite {
    private static final int FRAME_MODIFIER_INDEX_INCREMENTAL = 0;
    private static final int FRAME_MODIFIER_INDEX_RANDOM = 1;
    private static final int FRAME_MODIFIER_INDEX_UNIQUE = 2;
    private static final String[] FRAME_FIELD_MODIFIER_TYPES;
    private Label lblUdpSPN;
    private Text txtUdpSPN;
    private Label lblUdpDPN;
    private Text txtUdpDPN;
    private Label lblUdpTotLen;
    private Composite compUdpTotLen;
    private Button radioUdpTotLenAutomatic;
    private Button radioUdpTotLenManual;
    private Text txtUdpTotLenManual;
    private Label lblUdpCheck;
    private Label lblUdpCheckNote;
    private Composite compUdpCheck;
    private Button radioUdpCheckAutomatic;
    private Button radioUdpCheckManual;
    private Text txtUdpCheckManual;
    private Composite composite;
    private Composite compUdpFrameField;
    private Label lblFrameModifierInfo;
    private Button checkFrameModifierEnable;
    private Label lblFrameModifierType;
    private Combo cmbFrameModifierType;
    private Label lblFrameModifierOffset;
    private Text txtFrameModifierOffset;
    private Label lblFrameModifierSize;
    private Spinner spinnerFrameModifierSize;
    private Label lblFrameModifierStep;
    private Text txtFrameModifierStep;

    static {
        FieldModifierType[] types = FieldModifierType.values();
        FRAME_FIELD_MODIFIER_TYPES = new String[types.length];
        FieldModifierType[] fieldModifierTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            FieldModifierType type = fieldModifierTypeArray[n2];
            Layer4_UdpComposite.FRAME_FIELD_MODIFIER_TYPES[type.getComboIndex()] = type.toString();
            ++n2;
        }
    }

    public Layer4_UdpComposite(Composite parent, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout());
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.lblUdpSPN = new Label(this.composite, 0);
        this.lblUdpSPN.setText(Messages.getString("FrameView.L4.Udp.SPN"));
        this.txtUdpSPN = IntegerTextFactory.instance().create(this.composite, 65535L);
        this.txtUdpSPN.setLayoutData((Object)new GridData(768));
        this.txtUdpSPN.addModifyListener((ModifyListener)this);
        this.txtUdpSPN.addFocusListener((FocusListener)this);
        this.lblUdpDPN = new Label(this.composite, 0);
        this.lblUdpDPN.setText(Messages.getString("FrameView.L4.Udp.DPN"));
        this.txtUdpDPN = IntegerTextFactory.instance().create(this.composite, 65535L);
        this.txtUdpDPN.setLayoutData((Object)new GridData(768));
        this.txtUdpDPN.addModifyListener((ModifyListener)this);
        this.lblUdpTotLen = new Label(this.composite, 0);
        this.lblUdpTotLen.setText(Messages.getString("FrameView.L4.Udp.TotLen"));
        this.compUdpTotLen = new Composite(this.composite, 2048);
        this.compUdpTotLen.setLayoutData((Object)new GridData(768));
        this.compUdpTotLen.setLayout((Layout)new GridLayout(2, false));
        this.radioUdpTotLenAutomatic = new Button(this.compUdpTotLen, 16);
        this.radioUdpTotLenAutomatic.setText(Messages.getString("FrameView.L4.Udp.Automatic"));
        this.radioUdpTotLenAutomatic.addMouseListener((MouseListener)this);
        Label lblDummy = new Label(this.compUdpTotLen, 0);
        lblDummy.setVisible(false);
        this.radioUdpTotLenManual = new Button(this.compUdpTotLen, 16);
        this.radioUdpTotLenManual.setText(Messages.getString("FrameView.L4.Udp.Manual"));
        this.radioUdpTotLenManual.addMouseListener((MouseListener)this);
        this.txtUdpTotLenManual = HexTextFactory.create((Composite)this.compUdpTotLen, (int)2048, (int)4);
        this.txtUdpTotLenManual.setLayoutData((Object)new GridData(768));
        this.txtUdpTotLenManual.setEnabled(false);
        this.txtUdpTotLenManual.addModifyListener((ModifyListener)this);
        this.txtUdpTotLenManual.addFocusListener((FocusListener)this);
        this.lblUdpCheck = new Label(this.composite, 0);
        this.lblUdpCheck.setText(Messages.getString("FrameView.L4.Udp.Checksum"));
        this.compUdpCheck = new Composite(this.composite, 2048);
        this.compUdpCheck.setLayoutData((Object)new GridData(768));
        this.compUdpCheck.setLayout((Layout)new GridLayout(2, false));
        this.radioUdpCheckAutomatic = new Button(this.compUdpCheck, 16);
        this.radioUdpCheckAutomatic.setText(Messages.getString("FrameView.L4.Udp.Automatic"));
        this.radioUdpCheckAutomatic.addMouseListener((MouseListener)this);
        Label lblDummy2 = new Label(this.compUdpCheck, 0);
        lblDummy2.setVisible(false);
        this.radioUdpCheckManual = new Button(this.compUdpCheck, 16);
        this.radioUdpCheckManual.setText(Messages.getString("FrameView.L4.Udp.Manual"));
        this.radioUdpCheckManual.addMouseListener((MouseListener)this);
        this.txtUdpCheckManual = HexTextFactory.create((Composite)this.compUdpCheck, (int)2048, (int)4);
        this.txtUdpCheckManual.setLayoutData((Object)new GridData(768));
        this.txtUdpCheckManual.addModifyListener((ModifyListener)this);
        this.txtUdpCheckManual.addFocusListener((FocusListener)this);
        Composite frameModLine = new Composite((Composite)this, 0);
        frameModLine.setLayoutData((Object)new GridData(768));
        frameModLine.setLayout((Layout)new GridLayout(2, false));
        this.checkFrameModifierEnable = new Button(frameModLine, 32);
        this.checkFrameModifierEnable.addSelectionListener((SelectionListener)this);
        this.checkFrameModifierEnable.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Enable"));
        this.compUdpFrameField = new Composite((Composite)this, 2048);
        this.compUdpFrameField.setLayoutData((Object)new GridData(768));
        this.compUdpFrameField.setLayout((Layout)new GridLayout(1, false));
        this.lblFrameModifierInfo = new Label(this.compUdpFrameField, 0);
        this.lblFrameModifierInfo.setLayoutData((Object)new GridData(768));
        this.lblFrameModifierInfo.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Desc"));
        Composite compUdpFrameFieldInner = new Composite(this.compUdpFrameField, 0);
        compUdpFrameFieldInner.setLayoutData((Object)new GridData(768));
        compUdpFrameFieldInner.setLayout((Layout)new GridLayout(2, false));
        this.lblFrameModifierType = new Label(compUdpFrameFieldInner, 0);
        this.lblFrameModifierType.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Type"));
        this.cmbFrameModifierType = new Combo(compUdpFrameFieldInner, 8);
        this.cmbFrameModifierType.setLayoutData((Object)new GridData(768));
        this.cmbFrameModifierType.setItems(FRAME_FIELD_MODIFIER_TYPES);
        VerifyListener noNegative = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                if (result.isEmpty()) {
                    e.doit = true;
                } else {
                    try {
                        Integer value = Integer.valueOf(result);
                        e.doit = value >= 0;
                    }
                    catch (Exception exception) {
                        e.doit = false;
                    }
                }
            }
        };
        this.lblFrameModifierOffset = new Label(compUdpFrameFieldInner, 0);
        this.lblFrameModifierOffset.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Offset"));
        this.txtFrameModifierOffset = IntegerTextFactory.instance().create(compUdpFrameFieldInner, 9999L);
        this.txtFrameModifierOffset.setLayoutData((Object)new GridData(768));
        this.txtFrameModifierOffset.addModifyListener((ModifyListener)this);
        this.txtFrameModifierOffset.addVerifyListener(noNegative);
        this.txtFrameModifierOffset.setToolTipText("Offset of the modified value, in bytes.\nThe first byte of the UDP payload has offset 0.");
        this.lblFrameModifierSize = new Label(compUdpFrameFieldInner, 0);
        this.lblFrameModifierSize.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Size"));
        this.spinnerFrameModifierSize = new Spinner(compUdpFrameFieldInner, 2048);
        this.spinnerFrameModifierSize.setMinimum(1);
        this.spinnerFrameModifierSize.setMaximum(8);
        this.spinnerFrameModifierSize.setTextLimit(1);
        this.spinnerFrameModifierSize.setToolTipText("Size of the modified value, in bytes.");
        this.spinnerFrameModifierSize.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text;
                e.text = text = e.text;
                int length = text.length();
                char[] chars = new char[length];
                text.getChars(0, length, chars, 0);
                int i = 0;
                while (i < length) {
                    if ('0' >= chars[i] || chars[i] >= '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.spinnerFrameModifierSize.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Layer4_UdpComposite.this.updateL4_UdpSettings();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.spinnerFrameModifierSize.setLayoutData((Object)new GridData(768));
        this.spinnerFrameModifierSize.addModifyListener((ModifyListener)this);
        this.cmbFrameModifierType.addSelectionListener((SelectionListener)this);
        this.lblFrameModifierStep = new Label(compUdpFrameFieldInner, 0);
        this.lblFrameModifierStep.setText(Messages.getString("FrameView.L4.Udp.FrameFieldModifier.Step"));
        this.txtFrameModifierStep = IntegerTextFactory.instance().create(compUdpFrameFieldInner, 1L, 9999L);
        this.txtFrameModifierStep.setLayoutData((Object)new GridData(768));
        this.txtFrameModifierStep.addModifyListener((ModifyListener)this);
        this.txtFrameModifierStep.addVerifyListener(noNegative);
        this.txtFrameModifierStep.setToolTipText("This value is used to increment with.\nThe initial value is the current value.");
        this.layout();
    }

    public void updateL4_UdpSettings() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if ((frame = this.frameView.getFrame()) == null) {
            return;
        }
        FrameController controller = this.frameView.getFrameController();
        UDPPacket udp = controller.getCurrentUdp();
        String source = Integer.toString(udp.getSource()).toUpperCase();
        int caretPos = this.txtUdpSPN.getCaretPosition();
        this.txtUdpSPN.setText(source);
        this.txtUdpSPN.setSelection(caretPos, caretPos);
        String dest = Integer.toString(udp.getDestination()).toUpperCase();
        caretPos = this.txtUdpDPN.getCaretPosition();
        this.txtUdpDPN.setText(dest);
        this.txtUdpDPN.setSelection(caretPos, caretPos);
        boolean auto = frame.getL4AutoTotLen();
        this.radioUdpTotLenAutomatic.setSelection(auto);
        this.radioUdpTotLenManual.setSelection(!auto);
        this.txtUdpTotLenManual.setEnabled(!auto);
        String len = Integer.toHexString(udp.getLength()).toUpperCase();
        while (len.length() < 4) {
            len = "0" + len;
        }
        caretPos = this.txtUdpTotLenManual.getCaretPosition();
        this.txtUdpTotLenManual.setText(len);
        this.txtUdpTotLenManual.setSelection(caretPos, caretPos);
        auto = frame.getL4AutoUdpChecksum();
        this.radioUdpCheckAutomatic.setSelection(auto);
        this.radioUdpCheckManual.setSelection(!auto);
        this.txtUdpCheckManual.setEnabled(!auto);
        String checkSum = Integer.toHexString(udp.getCheckSum()).toUpperCase();
        while (checkSum.length() < 4) {
            checkSum = "0" + checkSum;
        }
        caretPos = this.txtUdpCheckManual.getCaretPosition();
        this.txtUdpCheckManual.setText(checkSum);
        this.txtUdpCheckManual.setSelection(caretPos, caretPos);
        if (frame.getL3Type() == FrameL3Type.IPV4_LITERAL) {
            if (this.lblUdpCheckNote == null) {
                this.lblUdpCheckNote = new Label(this.compUdpCheck, 0);
                this.lblUdpCheckNote.setText(Messages.getString("FrameView.L4.Udp.ChecksumNote"));
                this.lblUdpCheckNote.setVisible(true);
            }
        } else if (this.lblUdpCheckNote != null) {
            this.lblUdpCheckNote.setVisible(false);
            this.lblUdpCheckNote.dispose();
            this.lblUdpCheckNote = null;
        }
        this.compUdpCheck.layout(true);
        this.compUdpCheck.redraw();
        this.updateL4_FrameModifier(frame);
        this.composite.redraw();
        this.composite.layout(true);
    }

    private void updateL4_FrameModifier(Frame frame) {
        FrameReader reader = ReaderFactory.create((Frame)frame);
        boolean enabled = reader.hasFrameModifiers();
        this.checkFrameModifierEnable.setSelection(enabled);
        this.lblFrameModifierInfo.setEnabled(enabled);
        this.lblFrameModifierType.setEnabled(enabled);
        this.cmbFrameModifierType.setEnabled(enabled);
        String tooltip = "";
        if (enabled) {
            FrameFieldModifier modifier = reader.getFrameFieldModifier();
            if (modifier instanceof IncrementalFieldModifier) {
                this.cmbFrameModifierType.select(0);
                this.updateL4_IncrementalFieldModifier((IncrementalFieldModifier)modifier);
                tooltip = "Increments a value in the UDP payload,\nfor each transmitted Frame.";
            } else if (modifier instanceof RandomFieldModifier) {
                this.cmbFrameModifierType.select(1);
                this.updateL4_RandomFieldModifier((RandomFieldModifier)modifier);
                tooltip = "Changes a value in the UDP payload randomly,\nfor each transmitted Frame.";
            } else if (modifier instanceof UniqueFieldModifier) {
                this.cmbFrameModifierType.select(2);
                tooltip = "Changes a value in the UDP payload,\nto make sure that multiple Flows, using the same Frame, become uniquely distinguishable.\nThis happens only once, during initialization of the test Scenario.";
                this.updateL4_UniqueFieldModifier((UniqueFieldModifier)modifier);
            }
        } else {
            this.disableL4_FrameFieldModifiers();
        }
        this.cmbFrameModifierType.setToolTipText(tooltip);
    }

    private void disableL4_FrameFieldModifiers() {
        this.lblFrameModifierType.setEnabled(false);
        this.lblFrameModifierType.setEnabled(false);
        this.lblFrameModifierOffset.setEnabled(false);
        this.txtFrameModifierOffset.setEnabled(false);
        this.lblFrameModifierSize.setEnabled(false);
        this.spinnerFrameModifierSize.setEnabled(false);
        this.lblFrameModifierStep.setEnabled(false);
        this.txtFrameModifierStep.setEnabled(false);
        if (this.cmbFrameModifierType.getSelectionIndex() == -1) {
            this.cmbFrameModifierType.select(1);
        }
    }

    private void updateL4_FrameFieldModifier(FrameFieldModifier modifier) {
        this.lblFrameModifierOffset.setEnabled(true);
        this.txtFrameModifierOffset.setEnabled(true);
        this.lblFrameModifierSize.setEnabled(true);
        this.spinnerFrameModifierSize.setEnabled(true);
        int offset = modifier.getOffset();
        this.txtFrameModifierOffset.setText(Integer.toString(offset));
        int size = modifier.getFieldLength();
        this.spinnerFrameModifierSize.setSelection(size);
    }

    private void updateL4_UniqueFieldModifier(UniqueFieldModifier modifier) {
        this.updateL4_FrameFieldModifier((FrameFieldModifier)modifier);
        this.lblFrameModifierStep.setEnabled(false);
        this.txtFrameModifierStep.setEnabled(false);
    }

    private void updateL4_RandomFieldModifier(RandomFieldModifier modifier) {
        this.updateL4_FrameFieldModifier((FrameFieldModifier)modifier);
        this.lblFrameModifierStep.setEnabled(false);
        this.txtFrameModifierStep.setEnabled(false);
    }

    private void updateL4_IncrementalFieldModifier(IncrementalFieldModifier modifier) {
        this.updateL4_FrameFieldModifier((FrameFieldModifier)modifier);
        this.lblFrameModifierStep.setEnabled(true);
        this.txtFrameModifierStep.setEnabled(true);
        long step = modifier.getStepSize();
        this.txtFrameModifierStep.setText(Long.toString(step));
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        FrameController controller = this.getFrameController();
        Command command = null;
        if (control == this.txtUdpSPN) {
            String SPN = this.txtUdpSPN.getText();
            if (SPN.length() != 0) {
                int intSpn = Integer.parseInt(SPN);
                command = controller.setUdpSource(intSpn);
            }
        } else if (control == this.txtUdpDPN) {
            String DPN = this.txtUdpDPN.getText();
            if (DPN.length() != 0) {
                int intDpn = Integer.parseInt(DPN);
                command = controller.setUdpDestination(intDpn);
            }
        } else if (control == this.txtUdpTotLenManual) {
            if (HexTextFactory.checkComplete((Text)this.txtUdpTotLenManual)) {
                String totlen = this.txtUdpTotLenManual.getText();
                int inttotlen = Integer.parseInt(totlen, 16);
                command = controller.setUdpLength(inttotlen);
            }
        } else if (control == this.txtUdpCheckManual) {
            if (HexTextFactory.checkComplete((Text)this.txtUdpCheckManual)) {
                String check = this.txtUdpCheckManual.getText();
                int intcheck = Integer.parseInt(check, 16);
                command = controller.setUdpCheckSum(intcheck);
            }
        } else if (control == this.txtFrameModifierOffset) {
            command = this.createSetOffsetCommand(controller);
        } else if (control == this.spinnerFrameModifierSize) {
            command = this.createSetFieldLengthCommand(controller);
        } else if (control == this.txtFrameModifierStep) {
            command = this.createSetStepSizeCommand(controller);
        }
        this.frameView.executeCommand(command);
    }

    private Command createSetStepSizeCommand(FrameController controller) {
        IncrementalFieldModifier modifier = (IncrementalFieldModifier)controller.getFrameFieldModifier();
        IncrementalFieldModifierController modifierController = ControllerFactory.create((IncrementalFieldModifier)modifier);
        return this.createSetStepSizeCommand(modifierController);
    }

    private Command createSetStepSizeCommand(IncrementalFieldModifierController controller) {
        String txt = this.txtFrameModifierStep.getText();
        if (txt.isEmpty()) {
            return null;
        }
        Integer step = Integer.valueOf(this.txtFrameModifierStep.getText());
        return controller.setStepSize((long)step.intValue());
    }

    private Command createSetFieldLengthCommand(FrameController controller) {
        FrameFieldModifier modifier = controller.getFrameFieldModifier();
        FrameFieldModifierController modifierController = ControllerFactory.create((FrameFieldModifier)modifier);
        return this.createSetFieldLengthCommand(modifierController);
    }

    private Command createSetFieldLengthCommand(FrameFieldModifierController<?> controller) {
        String txt = this.spinnerFrameModifierSize.getText();
        if (txt.isEmpty()) {
            return null;
        }
        Integer size = Integer.valueOf(this.spinnerFrameModifierSize.getText());
        if (size < this.spinnerFrameModifierSize.getMinimum() || this.spinnerFrameModifierSize.getMaximum() < size) {
            return null;
        }
        return controller.setFieldlength(size.intValue());
    }

    private Command createSetOffsetCommand(FrameController controller) {
        FrameFieldModifier modifier = controller.getFrameFieldModifier();
        FrameFieldModifierController modifierController = ControllerFactory.create((FrameFieldModifier)modifier);
        return this.createSetOffsetCommand(modifierController);
    }

    private Command createSetOffsetCommand(FrameFieldModifierController<?> controller) {
        String txt = this.txtFrameModifierOffset.getText();
        if (txt.isEmpty()) {
            return null;
        }
        Integer offset = Integer.valueOf(this.txtFrameModifierOffset.getText());
        return controller.setOffset(offset.intValue());
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    Command handleControlEvent(Control control) {
        FrameController controller = this.getFrameController();
        CompoundCommandController compound = CompoundCommandController.createInstance();
        if (control == this.radioUdpTotLenAutomatic) {
            compound.appendCommand(controller.setL4AutoTotLen());
        } else if (control == this.radioUdpTotLenManual) {
            compound.appendCommand(controller.setL4AutoTotLen(Boolean.FALSE));
        } else if (control == this.radioUdpCheckAutomatic) {
            compound.appendCommand(controller.setL4AutoUdpChecksum());
        } else if (control == this.radioUdpCheckManual) {
            compound.appendCommand(controller.setL4AutoUdpChecksum(Boolean.FALSE));
        } else if (control == this.checkFrameModifierEnable || control == this.cmbFrameModifierType) {
            boolean enable = this.checkFrameModifierEnable.getSelection();
            if (enable) {
                if (control == this.cmbFrameModifierType) {
                    compound.appendCommand(controller.unsetFrameModifier());
                }
                int frameModifierIndex = this.getSelectedFrameModifierIndex();
                switch (frameModifierIndex) {
                    case 0: {
                        FrameController.CommandWithFrameModifierReference ref = controller.setFrameModifierIncremental();
                        compound.appendCommand(ref.getCommand());
                        IncrementalFieldModifierController incrementalModifierController = ControllerFactory.create((IncrementalFieldModifier)((IncrementalFieldModifier)ref.getCommandReference()));
                        compound.appendCommand(this.createSetOffsetCommand((FrameFieldModifierController<?>)incrementalModifierController));
                        compound.appendCommand(this.createSetFieldLengthCommand((FrameFieldModifierController<?>)incrementalModifierController));
                        compound.appendCommand(this.createSetStepSizeCommand(incrementalModifierController));
                        break;
                    }
                    case 1: {
                        FrameController.CommandWithFrameModifierReference ref = controller.setFrameModifierRandom();
                        compound.appendCommand(ref.getCommand());
                        FrameFieldModifierController modifierController = ref.getController();
                        compound.appendCommand(this.createSetOffsetCommand(modifierController));
                        compound.appendCommand(this.createSetFieldLengthCommand(modifierController));
                        break;
                    }
                    case 2: {
                        FrameController.CommandWithFrameModifierReference ref = controller.setFrameModifierUnique();
                        compound.appendCommand(ref.getCommand());
                        FrameFieldModifierController modifierController = ref.getController();
                        compound.appendCommand(this.createSetOffsetCommand(modifierController));
                        compound.appendCommand(this.createSetFieldLengthCommand(modifierController));
                    }
                }
            } else {
                compound.appendCommand(controller.unsetFrameModifier());
            }
        }
        return compound.unwrap();
    }

    private int getSelectedFrameModifierIndex() {
        return this.cmbFrameModifierType.getSelectionIndex();
    }

    private static enum FieldModifierType {
        INCREMENTAL(0, "FrameView.L4.UDP.FrameFieldModifier.IncrementType"),
        RANDOM(1, "FrameView.L4.UDP.FrameFieldModifier.RandomType"),
        UNIQUE(2, "FrameView.L4.UDP.FrameFieldModifier.UniqueType");

        final String comboDescription;
        final int comboIndex;

        private FieldModifierType(int index, String descLocation) {
            this.comboIndex = index;
            this.comboDescription = Messages.getString(descLocation);
        }

        public String toString() {
            return this.comboDescription;
        }

        public int getComboIndex() {
            return this.comboIndex;
        }
    }
}

