/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.gui.project.WizardLauncher;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frame.Layer2Composite;
import com.excentis.products.byteblower.gui.views.frame.Layer3Composite;
import com.excentis.products.byteblower.gui.views.frame.Layer4Composite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

class SettingsComposite
extends ByteBlowerComposite
implements SelectionListener {
    private FrameView frameView;
    private Label lblSettings;
    private Button btnImport;
    static final int L3_ARP_INDEX = 0;
    static final int L3_IPv4_INDEX = 1;
    static final int L3_IPv6_INDEX = 2;
    private TabFolder folder;
    private Layer2Composite compositeL2;
    private Layer3Composite compositeL3;
    private Layer4Composite compositeL4;

    public SettingsComposite(FrameView frameView, Composite parent) {
        super(parent, frameView.getFrameTableComposite());
        this.frameView = frameView;
        this.initialize();
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.lblSettings = new Label((Composite)this, 0);
        this.lblSettings.setText(Messages.getString("FrameView.Label.Settings"));
        this.lblSettings.setLayoutData((Object)new GridData(768));
        this.btnImport = new Button((Composite)this, 0);
        this.btnImport.setText("PCAP import...");
        this.btnImport.addSelectionListener((SelectionListener)this);
        this.btnImport.setEnabled(this.getProject() != null);
        IOpenCloseListener importEnable = new IOpenCloseListener(){

            public void projectOpenedOrClosed(ByteBlowerProject project) {
                Display disp = PlatformUI.getWorkbench().getDisplay();
                final 1 self = this;
                final boolean shouldEnable = project != null;
                disp.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SettingsComposite.this.btnImport.isDisposed()) {
                            ProjectSwitchNotifier.getInstance().removeOpenCloseListener(self);
                        } else {
                            (this).SettingsComposite.this.btnImport.setEnabled(shouldEnable);
                        }
                    }
                });
            }
        };
        ProjectSwitchNotifier.getInstance().addOpenCloseListener(importEnable);
        Composite settingsComposite = new Composite((Composite)this, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        settingsComposite.setLayoutData((Object)gridData);
        this.fillSettingsComposite(settingsComposite);
        settingsComposite.setLayout((Layout)new FillLayout());
    }

    private void fillSettingsComposite(Composite parent) {
        this.folder = new TabFolder(parent, 0);
        TabItem tabL2 = new TabItem(this.folder, 0);
        tabL2.setText(Messages.getString("FrameView.Tab.L2"));
        TabItem tabL3 = new TabItem(this.folder, 0);
        tabL3.setText(Messages.getString("FrameView.Tab.L3"));
        TabItem tabL4 = new TabItem(this.folder, 0);
        tabL4.setText(Messages.getString("FrameView.Tab.L4"));
        this.compositeL2 = new Layer2Composite((Composite)this.folder, this.frameView);
        this.compositeL3 = new Layer3Composite((Composite)this.folder, this.frameView);
        this.compositeL4 = new Layer4Composite((Composite)this.folder, this.frameView);
        tabL2.setControl((Control)this.compositeL2);
        tabL3.setControl((Control)this.compositeL3);
        tabL4.setControl((Control)this.compositeL4);
        this.folder.addSelectionListener((SelectionListener)this);
        this.updateVisibleLayer();
    }

    public void updateVisibleLayer() {
        this.updateVisibleLayer(false);
    }

    private void updateVisibleLayer(boolean force) {
        FrameController frameController = this.getFrameController();
        boolean frameSelected = frameController != null;
        this.folder.setEnabled(frameSelected);
        this.lblSettings.setEnabled(frameSelected);
        if (force) {
            this.compositeL2.updateL2();
            this.compositeL3.updateL3();
            this.compositeL4.updateL4();
        } else if (this.compositeL2.isVisible()) {
            this.compositeL2.updateL2();
        } else if (this.compositeL3.isVisible()) {
            this.compositeL3.updateL3();
        } else if (this.compositeL4.isVisible()) {
            this.compositeL4.updateL4();
        }
    }

    private FrameController getFrameController() {
        return this.frameView.getFrameController();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        Control control = (Control)event.widget;
        if (control == this.folder) {
            int tabIndex = this.folder.getSelectionIndex();
            switch (tabIndex) {
                case 0: {
                    this.compositeL2.updateL2();
                    break;
                }
                case 1: {
                    this.compositeL3.updateL3();
                    break;
                }
                case 2: {
                    this.compositeL4.updateL4();
                }
            }
        } else if (control == this.btnImport) {
            WizardLauncher.getNamed((String)"Pcap import").launch();
        }
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        this.updateVisibleLayer();
    }

    public void updateWidgets() {
    }

    protected void projectChanged(ByteBlowerProject project) {
        super.projectChanged(project);
        this.frameView.setSelectedFrame(null);
        this.updateVisibleLayer(true);
    }
}

