/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frameblasting;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingComposite;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingSettingsText;
import com.excentis.products.byteblower.gui.widgets.dialogs.FrameBlastingSettingsDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.ProjectPropertiesDialog;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

class FrameBlastingSettingsComposite
extends ByteBlowerComposite
implements SelectionListener {
    private Label lblSettings;
    private Button btnPreferences;
    private Button btnEdit;
    private FrameBlastingSettingsText settingsText;
    private FrameBlastingFlow flowTemplate;
    private FrameBlastingComposite frameBlastingComposite;
    private ChangeAdapter changeAdapter;
    private static final int GRID_COLUMNS = 2;

    public FrameBlastingSettingsComposite(Composite parent, FrameBlastingComposite frameBlastingComposite) {
        super(parent, (IByteBlowerComposite)frameBlastingComposite);
        this.frameBlastingComposite = frameBlastingComposite;
        this.changeAdapter = new ChangeAdapter();
        this.createContents();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        GridData labelLayoutData = new GridData(768);
        this.lblSettings.setLayoutData((Object)labelLayoutData);
        this.lblSettings.addMouseListener((MouseListener)new DoubleClickSettingsOpener());
        GridData fillLayoutData = new GridData(1808);
        fillLayoutData.horizontalSpan = 2;
        this.settingsText.setLayoutData(fillLayoutData);
        this.settingsText.addMouseListener((MouseListener)new DoubleClickSettingsOpener());
        fillLayoutData = new GridData(768);
        fillLayoutData.horizontalSpan = 2;
        this.btnPreferences.setLayoutData((Object)fillLayoutData);
        this.btnEdit.setEnabled(false);
    }

    private void createContents() {
        this.lblSettings = new Label((Composite)this, 0);
        this.lblSettings.setText("Settings:");
        this.btnEdit = new Button((Composite)this, 0);
        this.btnEdit.setImage(ImageCache.getImageFromString((String)"icons/gear_icon.png"));
        this.btnEdit.setText("Edit...");
        this.btnEdit.addSelectionListener((SelectionListener)this);
        this.settingsText = new FrameBlastingSettingsText(this);
        this.btnPreferences = new Button((Composite)this, 0);
        this.btnPreferences.setText("Intended Load Preferences...");
        this.btnPreferences.addSelectionListener((SelectionListener)this);
    }

    private void updateFlowEditBtn(FrameBlastingFlow flowTemplate) {
        boolean editAllowed;
        boolean bl = editAllowed = flowTemplate != null && flowTemplate.getFrameBlastingFrames().size() > 0;
        if (editAllowed) {
            for (FrameBlastingFrame flowFrame : flowTemplate.getFrameBlastingFrames()) {
                boolean bl2 = editAllowed = editAllowed && flowFrame != null && flowFrame.getFrame() != null;
            }
        }
        if (!this.btnEdit.isDisposed()) {
            this.btnEdit.setEnabled(editAllowed);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnEdit) {
            this.editFrameblasting();
        } else if (e.widget == this.btnPreferences) {
            ProjectPropertiesDialog properties = new ProjectPropertiesDialog(this.getShell(), 1);
            properties.open();
        }
    }

    private void editFrameblasting() {
        StructuredSelection selection = this.frameBlastingComposite.getStructuredSelection();
        if (selection.size() == 1) {
            FrameBlastingFlow fb = (FrameBlastingFlow)selection.getFirstElement();
            FrameBlastingSettingsDialog dialog = new FrameBlastingSettingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), fb);
            dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void updateForFlowChange(FrameBlastingFlow newlySelectedFlowTemplate) {
        if (this.flowTemplate != null) {
            this.flowTemplate.eAdapters().remove((Object)this.changeAdapter);
        }
        if (newlySelectedFlowTemplate != null) {
            newlySelectedFlowTemplate.eAdapters().add((Object)this.changeAdapter);
        }
        this.flowTemplate = newlySelectedFlowTemplate;
        this.settingsText.updateText(newlySelectedFlowTemplate);
        this.updateFlowEditBtn(newlySelectedFlowTemplate);
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        FrameBlastingFlow selectedFlowTemplate = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            selectedFlowTemplate = (FrameBlastingFlow)selection.getFirstElement();
        }
        this.updateForFlowChange(selectedFlowTemplate);
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.btnEdit.setEnabled(false);
        this.settingsText.updateText(null);
    }

    public void updateWidgets() {
    }

    private class ChangeAdapter
    implements Adapter {
        private ChangeAdapter() {
        }

        public void notifyChanged(Notification notification) {
            FrameBlastingFlow changedObject;
            Object notifier = notification.getNotifier();
            if (notifier instanceof FrameBlastingFlow && (changedObject = (FrameBlastingFlow)notifier) == FrameBlastingSettingsComposite.this.flowTemplate) {
                switch (notification.getFeatureID(FrameBlastingFlow.class)) {
                    case 1: 
                    case 6: 
                    case 7: {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!((ChangeAdapter)ChangeAdapter.this).FrameBlastingSettingsComposite.this.settingsText.isDisposed()) {
                                    ((ChangeAdapter)ChangeAdapter.this).FrameBlastingSettingsComposite.this.settingsText.updateText(changedObject);
                                }
                                FrameBlastingSettingsComposite.this.updateFlowEditBtn(((ChangeAdapter)ChangeAdapter.this).FrameBlastingSettingsComposite.this.flowTemplate);
                            }
                        });
                        return;
                    }
                }
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }

    private class DoubleClickSettingsOpener
    extends MouseAdapter {
        private DoubleClickSettingsOpener() {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
            if (!FrameBlastingSettingsComposite.this.btnEdit.isDisposed() && FrameBlastingSettingsComposite.this.btnEdit.isEnabled()) {
                FrameBlastingSettingsComposite.this.editFrameblasting();
            }
        }
    }
}

