/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import com.excentis.products.byteblower.gui.views.Activator;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTable;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableItem;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTablePointer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

class HexTableBuffer {
    private static final long BUFFER_DEFAULT_THRESHOLD = 65536L;
    private HexTable table;
    private String[] buffer = null;
    private File file = null;
    private int regionSize = 0;

    public HexTableBuffer(HexTable table) {
        this.table = table;
    }

    public void storeTableRegion(HexTablePointer p) {
        this.storeTableRegion(p.getRowIndex(), p.getColumnIndex());
    }

    private void storeTableRegion(int rowIndexBegin, int columnIndexBegin) {
        int lastItemIndex = this.table.getItemCount() - 1;
        HexTableItem lastItem = this.table.getItem(lastItemIndex);
        this.storeTableRegion(rowIndexBegin, columnIndexBegin, lastItemIndex, lastItem.getItemSize() - 1);
    }

    private void storeTableRegion(int rowIndexBegin, int columnIndexBegin, int rowIndexEnd, int columnIndexEnd) {
        int dataToBackup;
        this.regionSize = dataToBackup = this.table.getTableSize(rowIndexBegin, columnIndexBegin, rowIndexEnd, columnIndexEnd);
        if ((long)dataToBackup > 65536L) {
            this.saveData(rowIndexBegin, columnIndexBegin, rowIndexEnd, columnIndexEnd);
        } else {
            this.putData(rowIndexBegin, columnIndexBegin, rowIndexEnd, columnIndexEnd);
        }
    }

    public void restoreTableRegion(HexTablePointer p) {
        if (this.file != null) {
            this.loadData(p);
        } else {
            this.getData(p);
        }
    }

    private boolean putData(int rowIndexBegin, int columnIndexBegin, int rowIndexEnd, int columnIndexEnd) {
        Cursor waitCursor = new Cursor((Device)this.table.getDisplay(), 1);
        this.table.getShell().setCursor(waitCursor);
        int bufferIndex = 0;
        this.buffer = new String[this.table.getTableSize(rowIndexBegin, columnIndexBegin, rowIndexEnd, columnIndexEnd)];
        if (rowIndexBegin == rowIndexEnd) {
            HexTableItem item = this.table.getItem(rowIndexBegin);
            int i = columnIndexBegin;
            while (i <= columnIndexEnd) {
                this.buffer[bufferIndex++] = item.getText(i + 1);
                ++i;
            }
        } else {
            HexTableItem item = this.table.getItem(rowIndexBegin);
            int i = columnIndexBegin;
            while (i < 16) {
                this.buffer[bufferIndex++] = item.getText(i + 1);
                ++i;
            }
            i = rowIndexBegin + 1;
            while (i < rowIndexEnd) {
                item = this.table.getItem(i);
                int j = 0;
                while (j < 16) {
                    this.buffer[bufferIndex++] = item.getText(j + 1);
                    ++j;
                }
                ++i;
            }
            item = this.table.getItem(rowIndexEnd);
            i = 0;
            while (i <= columnIndexEnd) {
                this.buffer[bufferIndex++] = item.getText(i + 1);
                ++i;
            }
        }
        this.table.getShell().setCursor(null);
        waitCursor.dispose();
        return true;
    }

    private boolean getData(HexTablePointer p) {
        if (this.buffer == null) {
            return false;
        }
        Cursor waitCursor = new Cursor((Device)this.table.getDisplay(), 1);
        this.table.getShell().setCursor(waitCursor);
        int row = p.getRowIndex();
        int column = p.getColumnIndex() + 1;
        HexTableItem item = this.table.getItem(row);
        int i = 0;
        while (i < this.buffer.length) {
            if (column > 16) {
                item = this.table.getItem(++row);
                column = 1;
            }
            item.setText(column++, this.buffer[i]);
            ++i;
        }
        item.itemFiller();
        this.table.getShell().setCursor(null);
        waitCursor.dispose();
        return true;
    }

    private void saveData(int rowIndexBegin, int columnIndexBegin, int rowIndexEnd, int columnIndexEnd) {
        block22: {
            Cursor waitCursor = new Cursor((Device)this.table.getDisplay(), 1);
            this.table.getShell().setCursor(waitCursor);
            this.file = this.getTempFile();
            if (this.file.exists()) {
                this.file.delete();
            }
            BufferedWriter fileWriter = null;
            try {
                try {
                    fileWriter = new BufferedWriter(new FileWriter(this.file, false));
                    if (rowIndexBegin == rowIndexEnd) {
                        HexTableItem item = this.table.getItem(rowIndexBegin);
                        int i = columnIndexBegin;
                        while (i <= columnIndexEnd) {
                            fileWriter.write(item.getText(i + 1));
                            fileWriter.newLine();
                            ++i;
                        }
                    } else {
                        HexTableItem item = this.table.getItem(rowIndexBegin);
                        int i = columnIndexBegin;
                        while (i < 16) {
                            fileWriter.write(item.getText(i + 1));
                            fileWriter.newLine();
                            ++i;
                        }
                        i = rowIndexBegin + 1;
                        while (i < rowIndexEnd) {
                            item = this.table.getItem(i);
                            int j = 0;
                            while (j < 16) {
                                fileWriter.write(item.getText(j + 1));
                                fileWriter.newLine();
                                ++j;
                            }
                            ++i;
                        }
                        item = this.table.getItem(rowIndexEnd);
                        i = 0;
                        while (i <= columnIndexEnd) {
                            fileWriter.write(item.getText(i + 1));
                            fileWriter.newLine();
                            ++i;
                        }
                    }
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error opening or writing to the file " + this.file.getAbsolutePath() + "!"));
                    this.table.getShell().setCursor(null);
                    waitCursor.dispose();
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException iOException2) {
                            MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                        }
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                this.table.getShell().setCursor(null);
                waitCursor.dispose();
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                    }
                }
                throw throwable;
            }
            this.table.getShell().setCursor(null);
            waitCursor.dispose();
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                }
            }
        }
    }

    private void loadData(HexTablePointer p) {
        block30: {
            if (this.file == null) {
                return;
            }
            Cursor waitCursor = new Cursor((Device)this.table.getDisplay(), 1);
            this.table.getShell().setCursor(waitCursor);
            int row = p.getRowIndex();
            int column = p.getColumnIndex() + 2;
            HexTableItem item = this.table.getItem(row);
            BufferedReader fileReader = null;
            try {
                String s;
                fileReader = new BufferedReader(new FileReader(this.file));
                while ((s = fileReader.readLine()) != null) {
                    if (column > 16) {
                        item = this.table.getItem(++row);
                        column = 1;
                    }
                    item.setText(column++, s);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)this.table.getShell(), (String)"FileNotFoundException", (String)("Error opening file " + this.file.getAbsolutePath() + "!"));
                this.table.getShell().setCursor(null);
                waitCursor.dispose();
                item.itemFiller();
                if (fileReader == null) break block30;
                try {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                        this.file.delete();
                    }
                    break block30;
                }
                finally {
                    this.file.delete();
                }
            }
            catch (IOException iOException) {
                try {
                    MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error reading file " + this.file.getAbsolutePath() + "!"));
                }
                catch (Throwable throwable) {
                    block32: {
                        this.table.getShell().setCursor(null);
                        waitCursor.dispose();
                        item.itemFiller();
                        if (fileReader != null) {
                            try {
                                try {
                                    fileReader.close();
                                }
                                catch (IOException iOException2) {
                                    MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                                    this.file.delete();
                                    break block32;
                                }
                            }
                            catch (Throwable throwable2) {
                                this.file.delete();
                                throw throwable2;
                            }
                            this.file.delete();
                        }
                    }
                    throw throwable;
                }
                this.table.getShell().setCursor(null);
                waitCursor.dispose();
                item.itemFiller();
                if (fileReader == null) break block30;
                try {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException3) {
                        MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                        this.file.delete();
                    }
                    break block30;
                }
                finally {
                    this.file.delete();
                }
            }
            this.table.getShell().setCursor(null);
            waitCursor.dispose();
            item.itemFiller();
            if (fileReader != null) {
                try {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        MessageDialog.openError((Shell)this.table.getShell(), (String)"IOException", (String)("Error closing file " + this.file.getAbsolutePath() + "!"));
                        this.file.delete();
                    }
                }
                finally {
                    this.file.delete();
                }
            }
        }
    }

    private File getTempFile() {
        IPath path = Activator.getDefault().getStateLocation();
        Random random = new Random();
        do {
            String filename = "tmp" + Math.abs(random.nextInt()) + ".bin";
            this.file = new File(String.valueOf(path.toOSString()) + File.separatorChar + filename);
        } while (this.file.exists());
        random = null;
        return this.file;
    }

    public int getTableRegionSize() {
        return this.regionSize;
    }
}

