/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui.events;

import com.excentis.products.byteblower.gui.views.hex.gui.HexEditorControl;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTable;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableItem;
import com.excentis.products.byteblower.gui.views.hex.gui.events.CellEditorKeyListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CursorKeyListener
extends KeyAdapter {
    private final HexEditorControl hexEditorControl;
    private final TableCursor cursor;
    private final ControlEditor editor;
    private Text text = null;
    private CellEditorKeyListener cellEditorKeyListener = null;
    private int eventColumnIndex;
    private HexTableItem eventItem;

    public CursorKeyListener(HexEditorControl hexEditorControl, TableCursor cursor, ControlEditor editor) {
        this.hexEditorControl = hexEditorControl;
        this.cursor = cursor;
        this.editor = editor;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000009) {
            this.keyInsert();
            this.hexEditorControl.updateStatusPanel();
            return;
        }
        if (e.keyCode == 131072) {
            CellEditorKeyListener.updateShiftPos();
            this.keyShift(true);
            return;
        }
        if (Character.digit(e.character, 16) == -1 && e.keyCode != 127) {
            return;
        }
        TableItem row = this.cursor.getRow();
        int column = this.cursor.getColumn();
        if (column == 0 || column > 16) {
            return;
        }
        if (row.getText(column).compareTo("  ") == 0) {
            return;
        }
        HexTable table = this.hexEditorControl.getHexTable();
        int rowIndex = table.getSelectionIndex();
        this.eventColumnIndex = this.cursor.getColumn();
        this.eventItem = table.getItem(rowIndex);
        if (e.keyCode == 127) {
            e.doit = false;
            return;
        }
        this.text = new Text((Composite)this.cursor, 0);
        this.text.insert("" + e.character);
        this.text.setTextLimit(2);
        this.editor.setEditor((Control)this.text);
        this.text.setFocus();
        this.cellEditorKeyListener = new CellEditorKeyListener(this.hexEditorControl, this.cursor, this.editor, this.text);
        this.text.addKeyListener((KeyListener)this.cellEditorKeyListener);
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 131072) {
            this.keyShift(false);
            return;
        }
    }

    private void keyShift(boolean enable) {
        HexEditorControl.isShifting = enable;
    }

    private void keyInsert() {
        HexTable table = this.hexEditorControl.getHexTable();
        int tableSize = table.getTableSize();
        if (tableSize >= 8192) {
            MessageDialog.openInformation((Shell)table.getShell(), (String)"Frame size", (String)"The maximum frame size is reached. (8192 bytes)");
            return;
        }
        int rowIndex = table.getSelectionIndex();
        int columnIndex = this.cursor.getColumn();
        HexTableItem item = table.getItem(rowIndex);
        if (columnIndex == 0 || columnIndex == 16 || item.getText(columnIndex).equals("  ")) {
            return;
        }
        table.insertData(1, 0, rowIndex, columnIndex - 1, true);
        this.hexEditorControl.saveFrame();
    }

    public CellEditorKeyListener getCellEditorKeyListener() {
        return this.cellEditorKeyListener;
    }

    public Text getText() {
        return this.text == null || this.text.isDisposed() ? null : this.text;
    }

    public HexTableItem getEventItem() {
        return this.eventItem;
    }

    public int getEventColumn() {
        return this.eventColumnIndex;
    }
}

