/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.ip;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.EByteBlowerObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.MulticastSourceGroupController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;

public final class IpCopyDown
extends EByteBlowerObjectCopyDown<IpAddress> {
    protected CopyDownInfo copyDownSpecial(IpAddress selectedEObject, IpAddress affectedEObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        MulticastSourceGroupController controller;
        IpAddress newAddress;
        Object value;
        IpAddressReader selectedReader = ReaderFactory.create((IpAddress)selectedEObject);
        IpAddressController affectedController = ControllerFactory.create((IpAddress)affectedEObject);
        if (selectedReader.isIPv4() == affectedController.isIPv4()) {
            FeatureInfo featureInfo = translator.getFeatureInfo();
            int originalFeatureType = featureInfo.getFeatureType();
            featureInfo.setFeatureType(4);
            translator.setFeatureInfo(featureInfo);
            copyDownInfo = super.copyDownGenerically((EObject)selectedEObject, (EObject)affectedEObject, copyDownInfo, translator, operation, mode, takenNames);
            featureInfo.setFeatureType(originalFeatureType);
            translator.setFeatureInfo(featureInfo);
            return copyDownInfo;
        }
        if (copyDownInfo == null) {
            copyDownInfo = new CopyDownInfo((Object)selectedEObject, null, false);
        }
        if ((value = copyDownInfo.getValue()) instanceof BasicEList) {
            BasicEList list = (BasicEList)value;
            NetworkAddressBytes bytes = new NetworkAddressBytes();
            bytes.addAll((Collection)list);
            value = IpAddressController.createFromBytes((NetworkAddressBytes)bytes);
            value = (IpAddress)value;
        }
        if (value instanceof IpAddress) {
            IpAddress previousIp = (IpAddress)value;
            IpAddressController previousController = ControllerFactory.create((IpAddress)previousIp);
            newAddress = previousIp;
            MulticastSourceGroup sourceGroup = (MulticastSourceGroup)selectedEObject.eContainer();
            controller = ControllerFactory.create((MulticastSourceGroup)sourceGroup);
            if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                throw new RuntimeException("Decrement is currently not supported.");
            }
            if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                newAddress = previousController.getIncrementedAddress();
            } else if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                newAddress = (IpAddress)previousController.copy();
            }
        } else {
            throw new RuntimeException("Unsupported IP copy down object.");
        }
        copyDownInfo.setValue((Object)newAddress.getBytes());
        int index = affectedController.getIndexInContainer();
        Command command = controller.addIpAddress(newAddress, index);
        operation.appendCommand(command);
        operation.appendCommand(affectedController.createDeleteCommand());
        return copyDownInfo;
    }
}

