/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.multicast;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.editors.AbstractCellModifier;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastMemberComposite;
import com.excentis.products.byteblower.model.MulticastFilterType;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.MulticastMemberPortController;
import com.excentis.products.byteblower.model.reader.MulticastMemberPortReader;
import com.excentis.products.byteblower.model.reader.MulticastSourceGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.swt.widgets.TableItem;

public class MulticastMemberPortCellModifier
extends AbstractCellModifier {
    private MulticastMemberComposite composite;

    public MulticastMemberPortCellModifier(MulticastMemberComposite composite) {
        this.composite = composite;
    }

    public boolean canModify(Object element, String property) {
        if (!(element instanceof MulticastMemberPort)) {
            return false;
        }
        MulticastMemberPort multicastMemberPort = (MulticastMemberPort)element;
        int columnIndex = this.composite.getColumnIndex(property);
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                this.composite.updateProtocolVersionCombo();
                return true;
            }
            case 2: {
                MulticastMemberPortReader reader = ReaderFactory.create((MulticastMemberPort)multicastMemberPort);
                boolean canmodify = reader.canUseSourceSpecificMulticast();
                if (canmodify) {
                    this.composite.updateSourceFilterCombo();
                }
                return canmodify;
            }
            case 3: {
                MulticastMemberPortReader reader = ReaderFactory.create((MulticastMemberPort)multicastMemberPort);
                boolean canmodify = reader.canUseSourceSpecificMulticast();
                if (canmodify) {
                    this.composite.updateSourceGroupCombo();
                }
                return canmodify;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.composite.getColumnIndex(property);
        MulticastMemberPort member = (MulticastMemberPort)element;
        MulticastMemberPortReader reader = ReaderFactory.create((MulticastMemberPort)member);
        switch (columnIndex) {
            case 0: {
                return reader.getByteBlowerGuiPort();
            }
            case 1: {
                return reader.getMulticastProtocolVersion();
            }
            case 2: {
                return reader.getMulticastSourceFilter();
            }
            case 3: {
                MulticastSourceGroupReader sourceGroupReader = reader.getMulticastSourceGroupReader();
                return sourceGroupReader.objectIsNull() ? 0 : sourceGroupReader.getIndexInContainer() + 1;
            }
        }
        System.out.println("MulticastMemberPortItemProvider::getValue(): Unknown columnIndex '" + String.valueOf(columnIndex) + "'");
        return null;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.composite.getColumnIndex(property);
        Object itemData = null;
        if (element instanceof TableItem) {
            TableItem tableItem = (TableItem)element;
            itemData = tableItem.getData();
        }
        if (!(itemData instanceof MulticastMemberPort)) {
            return;
        }
        MulticastMemberPort multicastMemberPort = (MulticastMemberPort)itemData;
        MulticastMemberPortController multicastMemberPortController = ControllerFactory.create((MulticastMemberPort)multicastMemberPort);
        switch (columnIndex) {
            case 1: {
                if (!(value instanceof Enumerator)) break;
                this.runUndoableOperation("Change Multicast Member Protocol Version", multicastMemberPortController.setMulticastProtocolVersion((Enumerator)value));
                break;
            }
            case 2: {
                if (!(value instanceof MulticastFilterType)) break;
                this.runUndoableOperation("Change Multicast Member Source Filter", multicastMemberPortController.setMulticastSourceFilter((MulticastFilterType)value));
                break;
            }
            case 3: {
                MulticastSourceGroup selectedSourceGroup = null;
                int intValue = (Integer)value;
                if (intValue == -1) {
                    return;
                }
                if (intValue > 0) {
                    EList sourceGroups = ByteBlowerGuiResourceController.getProjectReader().getMulticastSourceGroups();
                    selectedSourceGroup = (MulticastSourceGroup)sourceGroups.get(intValue - 1);
                }
                this.runUndoableOperation("Change Multicast Source Group", multicastMemberPortController.setMulticastSourceGroup(selectedSourceGroup));
                break;
            }
            default: {
                System.out.println("MulticastMemberPortCellModifier::modify(): Unknown columnIndex '" + String.valueOf(columnIndex) + "'");
            }
        }
    }
}

