/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.multicast.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.EnumeratorCellEditor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAddRemoveTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.multicast.MulticastMemberPortCellModifier;
import com.excentis.products.byteblower.gui.views.multicast.MulticastView;
import com.excentis.products.byteblower.gui.views.multicast.actions.AddRemoveMulticastMemberAction;
import com.excentis.products.byteblower.gui.views.multicast.actions.CopyMulticastMemberAction;
import com.excentis.products.byteblower.gui.views.multicast.actions.CutMulticastMemberAction;
import com.excentis.products.byteblower.gui.views.multicast.actions.DeleteMulticastMemberAction;
import com.excentis.products.byteblower.gui.views.multicast.actions.PasteMulticastMemberAction;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastGroupComposite;
import com.excentis.products.byteblower.gui.views.port.PortView;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.MulticastFilterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.MulticastMemberPortController;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class MulticastMemberComposite
extends ByteBlowerAddRemoveTableComposite<MulticastMemberPort> {
    private static final String[] columnNames = new String[]{Messages.getString("MulticastView.Column.PortName"), Messages.getString("MulticastView.Column.IgmpVersion"), Messages.getString("MulticastView.Column.MulticastSourceFilter"), Messages.getString("MulticastView.Column.MulticastSourceGroup")};
    private static final int[] columnWeights = new int[]{1, 1, 1, 1};
    private EnumeratorCellEditor sourceFilterEditor;
    private ComboBoxCellEditor sourceGroupEditor;
    private MulticastMemberPortCellModifier cellModifier;

    public MulticastMemberComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, MulticastGroupComposite parentComposite) {
        super(parent, "MulticastMemberComposite", actionInterface, focusDispatcher, (ByteBlowerModelTableComposite)parentComposite);
        this.initializeChildClass();
    }

    public Class<?> getViewedClass() {
        return MulticastMemberPort.class;
    }

    public int getChildFeatureId() {
        return 6;
    }

    protected String getTableLabel() {
        return Messages.getString("MulticastView.Label.AddedPorts");
    }

    protected String[] getColumnNames() {
        return columnNames;
    }

    protected int[] getColumnWeights() {
        return columnWeights;
    }

    protected ByteBlowerNewAction<MulticastMemberPort> createNewAction() {
        return new AddRemoveMulticastMemberAction(this);
    }

    protected ByteBlowerCutAction<MulticastMemberPort> createCutAction() {
        return new CutMulticastMemberAction(this);
    }

    protected ByteBlowerCopyAction<MulticastMemberPort> createCopyAction() {
        return new CopyMulticastMemberAction(this);
    }

    protected ByteBlowerPasteAction<MulticastMemberPort> createPasteAction() {
        return new PasteMulticastMemberAction(this);
    }

    protected ByteBlowerDeleteAction<MulticastMemberPort> createDeleteAction() {
        return new DeleteMulticastMemberAction((ByteBlowerModelTableComposite<MulticastMemberPort>)this);
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[0] = null;
        EnumeratorCellEditor multicastVersionEditor = new EnumeratorCellEditor((Composite)table, 8);
        editors[1] = multicastVersionEditor;
        this.sourceFilterEditor = new EnumeratorCellEditor((Composite)table, MulticastFilterType.VALUES, 8);
        editors[2] = this.sourceFilterEditor;
        this.sourceGroupEditor = new ComboBoxCellEditor((Composite)table, this.getSourceGroupNames(), 8);
        this.sourceGroupEditor.setActivationStyle(1);
        editors[3] = this.sourceGroupEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        this.cellModifier = new MulticastMemberPortCellModifier(this);
        return this.cellModifier;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        Object currentInput;
        MulticastGroup group = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            group = (MulticastGroup)selection.getFirstElement();
        }
        if (group != (currentInput = this.getInput())) {
            this.setInput(group);
            this.updateWidgets();
        }
    }

    public void doJump() {
        MulticastMemberPort memberPort = (MulticastMemberPort)this.getFirstSelectedObject();
        switch (this.getCurrentColumn()) {
            case 0: {
                PortView.showAndSelect(memberPort.getByteBlowerGuiPort());
                break;
            }
            case 3: {
                MulticastView.showAndSelect(memberPort.getMulticastSourceGroup());
                break;
            }
        }
    }

    public Object getInitialInput() {
        return Collections.emptyList();
    }

    protected void updateCustomWidgets(boolean enable) {
    }

    protected Class<?> getParentClass() {
        return MulticastGroup.class;
    }

    public void updateSourceFilterCombo() {
    }

    public void updateProtocolVersionCombo() {
        ByteBlowerTableViewer tableViewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        if (selection.size() == 1) {
            EnumeratorCellEditor portCombo;
            MulticastMemberPort multicastMemberPort = (MulticastMemberPort)selection.getFirstElement();
            MulticastMemberPortController multicastMemberPortController = ControllerFactory.create((MulticastMemberPort)multicastMemberPort);
            List<? extends Enumerator> selectionList = this.getMulticastVersionChoices((MulticastMemberPortController<? extends MulticastMemberPort>)multicastMemberPortController);
            CellEditor[] celleditors = this.getCellEditors();
            if (celleditors != null && (portCombo = (EnumeratorCellEditor)celleditors[1]) != null) {
                portCombo.setItems(selectionList);
            }
        }
    }

    private List<? extends Enumerator> getMulticastVersionChoices(MulticastMemberPortController<? extends MulticastMemberPort> multicastMemberPortController) {
        return multicastMemberPortController.getMulticastProtocolVersionValues();
    }

    public void updateSourceGroupCombo() {
        this.sourceGroupEditor.setItems(this.getSourceGroupNames());
    }

    private String[] getSourceGroupNames() {
        int count = 0;
        ByteBlowerProjectReader reader = ByteBlowerGuiResourceController.getProjectReader();
        EList sourceGroups = null;
        if (reader != null) {
            sourceGroups = reader.getMulticastSourceGroups();
            count = sourceGroups.size();
        }
        String[] names = new String[1 + count];
        names[0] = "";
        if (sourceGroups != null) {
            int i = 0;
            for (MulticastSourceGroup sourceGroup : sourceGroups) {
                names[++i] = sourceGroup.getName();
            }
        }
        return names;
    }

    public boolean isCopyDownEnabled() {
        boolean enable = false;
        switch (this.getCurrentColumn()) {
            case 1: 
            case 2: 
            case 3: {
                enable = true;
            }
        }
        return enable;
    }

    public boolean isCopyDownIncEnabled() {
        boolean enable = false;
        switch (this.getCurrentColumn()) {
            case 3: {
                MulticastMemberPort memberPort = (MulticastMemberPort)this.getFirstSelectedObject();
                enable = memberPort.getMulticastSourceGroup() != null;
            }
        }
        return enable;
    }

    public boolean isJumpEnabled() {
        boolean enable = false;
        MulticastMemberPort memberPort = (MulticastMemberPort)this.getFirstSelectedObject();
        switch (this.getCurrentColumn()) {
            case 0: {
                enable = memberPort.getByteBlowerGuiPort() != null;
                break;
            }
            case 3: {
                enable = memberPort.getMulticastSourceGroup() != null;
            }
        }
        return enable;
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.resetInput();
    }
}

