/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpView;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv4PortComposite;
import com.excentis.products.byteblower.gui.views.portforwarding.PortForwardingView;
import com.excentis.products.byteblower.gui.views.vlan.VlanView;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerPortGroupController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.PortForwardingController;
import com.excentis.products.byteblower.model.control.VlanStackController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TreeItem;

public class ByteBlowerIpv4PortCellModifier
implements ICellModifier {
    private Ipv4PortComposite ipv4Composite;

    public ByteBlowerIpv4PortCellModifier(Ipv4PortComposite ipv4Composite) {
        this.ipv4Composite = ipv4Composite;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.ipv4Composite.getColumnIndex(property);
        if (element instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)element));
            boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return !isDockedOnMobileDevice;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (isDockedOnMobileDevice) {
                        return false;
                    }
                    if (reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV4)) {
                        return reader.getIpv4ConfigurationReader().usesFixedAdress();
                    }
                    return false;
                }
                case 7: 
                case 8: {
                    if (!isDockedOnMobileDevice) break;
                    return false;
                }
            }
            return true;
        }
        if (element instanceof ByteBlowerPortGroup) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.ipv4Composite.getColumnIndex(property);
        if (element instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)element));
            Ipv4ConfigurationReader ipv4ConfigReader = reader.getIpv4ConfigurationReader();
            switch (columnIndex) {
                case 0: {
                    return reader.getName();
                }
                case 1: {
                    return reader.getMacAddressReader();
                }
                case 2: {
                    return reader.getDhcpv4();
                }
                case 3: {
                    return ipv4ConfigReader.getAddressReader().getObject();
                }
                case 4: {
                    return ipv4ConfigReader.getGatewayReader().getObject();
                }
                case 5: {
                    return ipv4ConfigReader.getNetmaskReader().getObject();
                }
                case 6: {
                    return reader.getObject();
                }
                case 7: {
                    return reader.getVlanStack();
                }
                case 8: {
                    return reader.getMtuInteger();
                }
                case 9: {
                    return reader.getObject();
                }
            }
        } else if (element instanceof ByteBlowerPortGroup) {
            ByteBlowerPortGroupReader reader = ReaderFactory.create((ByteBlowerPortGroup)((ByteBlowerPortGroup)element));
            switch (columnIndex) {
                case 0: {
                    return reader.getName();
                }
            }
            return false;
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        UndoableByteBlowerControllerOperation operation;
        block47: {
            ByteBlowerProject project;
            Object itemData;
            int columnIndex;
            block46: {
                columnIndex = this.ipv4Composite.getColumnIndex(property);
                TreeItem item = (TreeItem)element;
                itemData = item.getData();
                operation = null;
                project = ByteBlowerGuiResourceController.getProject();
                if (!(itemData instanceof ByteBlowerGuiPort)) break block46;
                ByteBlowerGuiPort byteblowerGuiPort = (ByteBlowerGuiPort)itemData;
                Ipv4Configuration modifyIpv4Configuration = byteblowerGuiPort.getIpv4Configuration();
                ByteBlowerGuiPortController portController = new ByteBlowerGuiPortController(byteblowerGuiPort);
                switch (columnIndex) {
                    case 0: {
                        if (value instanceof String) {
                            operation = new UndoableByteBlowerControllerOperation(project, "Change Port Name", portController.checkAndSetName((String)value));
                        }
                        break block47;
                    }
                    case 1: {
                        if (value instanceof NetworkAddressBytes) {
                            EthernetConfigurationController ethernetConfigurationController = new EthernetConfigurationController((EthernetConfiguration)byteblowerGuiPort.getLayer2Configuration());
                            operation = new UndoableByteBlowerControllerOperation(project, "MAC Address", ethernetConfigurationController.setMacAddress((NetworkAddressBytes)value));
                        }
                        break block47;
                    }
                    case 2: {
                        Ipv4ConfigurationController configController = portController.getIpv4ConfigurationController();
                        if (value instanceof Dhcp) {
                            Dhcp dhcp = (Dhcp)value;
                            operation = new UndoableByteBlowerControllerOperation(project, "Change DHCPv4", configController.setDhcp(dhcp).getCommand());
                        } else if (value instanceof String) {
                            String dhcpOption = (String)value;
                            if (dhcpOption.equals("Fixed")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Set Configuration Fixed", configController.setFixedAddressConfiguration());
                            } else if (dhcpOption.equals("New Dhcp...")) {
                                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                                ByteBlowerProjectController.CommandWithDhcpListReference commandWithDhcpListReference = projectController.addDhcp();
                                CompoundCommandController compoundController = CompoundCommandController.createInstance();
                                compoundController.appendCommand(commandWithDhcpListReference.getCommand());
                                final Dhcp newDhcp = (Dhcp)((DhcpController)((List)commandWithDhcpListReference.getCommandReference()).get(0)).getObject();
                                compoundController.appendCommand(configController.setDhcp(newDhcp).getCommand());
                                operation = new UndoableByteBlowerControllerOperation(project, "New DHCPv4", compoundController.unwrap());
                                operation.addAfterOperationListener(new IAfterOperationListener(){

                                    public void afterOperation(UndoableByteBlowerOperation operation) {
                                        DhcpView.showAndSelect(newDhcp);
                                    }
                                });
                            } else {
                                System.err.println("ByteBlowerIpv4PortCellModifier : invalid DHCP option !");
                            }
                        }
                        break block47;
                    }
                    case 3: {
                        if (modifyIpv4Configuration != null && value instanceof NetworkAddressBytes) {
                            Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(modifyIpv4Configuration);
                            operation = new UndoableByteBlowerControllerOperation(project, "Change IPv4 Address", ipv4ConfigurationController.setIpAddress((NetworkAddressBytes)value));
                        }
                        break block47;
                    }
                    case 4: {
                        if (modifyIpv4Configuration != null && value instanceof NetworkAddressBytes) {
                            Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(modifyIpv4Configuration);
                            operation = new UndoableByteBlowerControllerOperation(project, "Change Default Gateway", ipv4ConfigurationController.setDefaultGateway((NetworkAddressBytes)value));
                        }
                        break block47;
                    }
                    case 5: {
                        if (modifyIpv4Configuration != null && value instanceof NetworkAddressBytes) {
                            Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(modifyIpv4Configuration);
                            operation = new UndoableByteBlowerControllerOperation(project, "Change Netmask", ipv4ConfigurationController.setNetmask((NetworkAddressBytes)value));
                        }
                        break block47;
                    }
                    case 6: {
                        if (value instanceof PortForwarding) {
                            PortForwarding portForwarding = (PortForwarding)value;
                            operation = new UndoableByteBlowerControllerOperation(project, "Change NAT", portController.setPortForwarding(portForwarding));
                        } else if (value instanceof String) {
                            String option = (String)value;
                            if (option.equals("No")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Change NAT", portController.clearNat());
                            } else if (option.equals("Yes")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Change NAT", portController.setNatAutomaticDiscovery());
                            } else if (option.equals("New Port Forwarding...")) {
                                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                                ByteBlowerProjectController.CommandWithPortForwardingListReference commandWithListReference = projectController.addPortForwarding();
                                CompoundCommandController compoundController = CompoundCommandController.createInstance();
                                compoundController.appendCommand(commandWithListReference.getCommand());
                                final PortForwarding newPortForwarding = (PortForwarding)((PortForwardingController)((List)commandWithListReference.getCommandReference()).get(0)).getObject();
                                compoundController.appendCommand(portController.setPortForwarding(newPortForwarding));
                                operation = new UndoableByteBlowerControllerOperation(project, "New Port Forwarding", compoundController.unwrap());
                                operation.addAfterOperationListener(new IAfterOperationListener(){

                                    public void afterOperation(UndoableByteBlowerOperation operation) {
                                        PortForwardingView.showAndSelect(newPortForwarding);
                                    }
                                });
                            } else {
                                System.err.println("ByteBlowerIpv4PortCellModifier : invalid NAT option !");
                            }
                        }
                        break block47;
                    }
                    case 7: {
                        if (value instanceof VlanStack) {
                            VlanStack vlanStack = (VlanStack)value;
                            operation = new UndoableByteBlowerControllerOperation(project, "Change VLAN Stack", portController.setVlanStack((Object)vlanStack).getCommand());
                        } else if (value instanceof String) {
                            String vlanOption = (String)value;
                            if (vlanOption.equals("No")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Change VLAN", portController.clearVlanStack().getCommand());
                            } else if (vlanOption.equals("New VLAN Stack...")) {
                                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                                ByteBlowerProjectController.CommandWithVlanStackListReference commandWithVlanStackListReference = projectController.addVlanStack();
                                CompoundCommandController compoundController = CompoundCommandController.createInstance();
                                compoundController.appendCommand(commandWithVlanStackListReference.getCommand());
                                final VlanStack newVlanStack = (VlanStack)((VlanStackController)((List)commandWithVlanStackListReference.getCommandReference()).get(0)).getObject();
                                compoundController.appendCommand(portController.setVlanStack((Object)newVlanStack).getCommand());
                                operation = new UndoableByteBlowerControllerOperation(project, "New VLAN Stack", compoundController.unwrap());
                                operation.addAfterOperationListener(new IAfterOperationListener(){

                                    public void afterOperation(UndoableByteBlowerOperation operation) {
                                        VlanView.showAndSelect(newVlanStack);
                                    }
                                });
                            } else {
                                System.err.println("ByteBlowerIpv4PortCellModifier : invalid VLAN option !");
                            }
                        }
                        break block47;
                    }
                    case 8: {
                        if (value instanceof Integer) {
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change MTU", portController.setMTU(Long.valueOf(((Integer)value).longValue())));
                        }
                        break block47;
                    }
                    case 9: {
                        break block47;
                    }
                    default: {
                        System.out.println("ByteBlowerIpv4PortCellModifier : invalid case !");
                        return;
                    }
                }
            }
            if (itemData instanceof ByteBlowerPortGroup) {
                switch (columnIndex) {
                    case 0: {
                        if (!(value instanceof String)) break;
                        ByteBlowerPortGroup group = (ByteBlowerPortGroup)itemData;
                        ByteBlowerPortGroupController controller = ControllerFactory.create((ByteBlowerPortGroup)group);
                        operation = new UndoableByteBlowerControllerOperation(project, "Change Group Name", controller.checkAndSetName((String)value));
                    }
                }
            }
        }
        if (operation != null) {
            operation.run();
        }
    }
}

