/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NatCellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    private TreeViewer treeViewer;
    static final String NAT_EDITOR_OPTION_NO = "No";
    static final String NAT_EDITOR_OPTION_AUTO = "Yes";
    static final String NAT_EDITOR_OPTION_NEW = "New Port Forwarding...";

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        CCombo combo = (CCombo)control;
        combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public NatCellEditor(TreeViewer treeViewer) {
        super((Composite)treeViewer.getTree(), new String[0], 0);
        this.treeViewer = treeViewer;
        this.setActivationStyle(1);
    }

    private String[] getItemList() {
        ByteBlowerGuiPort selectedPort = (ByteBlowerGuiPort)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        ByteBlowerProject project = selectedPort.getByteBlowerProject();
        EList portforwardings = project.getPortForwarding();
        int itemCount = portforwardings.size();
        String[] names = new String[3 + itemCount];
        names[0] = NAT_EDITOR_OPTION_NO;
        names[1] = NAT_EDITOR_OPTION_AUTO;
        int i = 2;
        for (PortForwarding portforwarding : portforwardings) {
            names[i++] = portforwarding.getName();
        }
        names[i] = NAT_EDITOR_OPTION_NEW;
        return names;
    }

    public Object doGetValue() {
        Object superValue = super.doGetValue();
        Integer intValue = (Integer)superValue;
        Object returnValue = NAT_EDITOR_OPTION_NO;
        int index = intValue;
        if (index == 0) {
            return NAT_EDITOR_OPTION_NO;
        }
        if (index == 1) {
            return NAT_EDITOR_OPTION_AUTO;
        }
        EList<PortForwarding> allPortForwardings = this.getAllPortForwardings();
        returnValue = (index -= 2) < allPortForwardings.size() ? allPortForwardings.get(index) : NAT_EDITOR_OPTION_NEW;
        return returnValue;
    }

    protected void doSetValue(Object value) {
        int index = 0;
        if (value != null) {
            ByteBlowerGuiPort port = (ByteBlowerGuiPort)value;
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)port);
            PortForwarding portForwarding = reader.getPortForwarding();
            index = portForwarding != null ? this.getAllPortForwardings().indexOf((Object)portForwarding) + 2 : (reader.isNatAutoDiscovery() != false ? 1 : 0);
        }
        this.setItems(this.getItemList());
        super.doSetValue((Object)index);
    }

    private EList<PortForwarding> getAllPortForwardings() {
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        ByteBlowerProject project = (ByteBlowerProject)projectController.getObject();
        return project.getPortForwarding();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.doGetValue() == NAT_EDITOR_OPTION_NEW) {
            this.focusLost();
        }
    }
}

