/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.actions;

import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAmountComposite;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv4PortComposite;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;

public class PastePortAction
extends ByteBlowerPasteAction<EByteBlowerObject> {
    public PastePortAction(IByteBlowerAmountComposite<EByteBlowerObject> composite) {
        super("Port", composite.getByteBlowerViewerComposite());
    }

    protected EByteBlowerObject[] getClipboardObjects() {
        Clipboard clipboard = this.getClipboard();
        EByteBlowerObject[] copiedObjects = (EByteBlowerObject[])clipboard.getContents((Transfer)ByteBlowerTransfer.getInstance(ByteBlowerGuiPort.class));
        return copiedObjects;
    }

    protected int getPastePos() {
        int pastePos = -1;
        EByteBlowerObject first = (EByteBlowerObject)this.composite.getFirstSelectedObject();
        if (first != null) {
            EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)first);
            pastePos = reader.getIndexInContainer() + 1;
        }
        return pastePos;
    }

    protected Command getPasteCommand(EByteBlowerObject[] copiedObjects) {
        int portPosInProject = -1;
        boolean ports = false;
        boolean groups = false;
        int i = 0;
        while (i < copiedObjects.length) {
            EByteBlowerObject obj = copiedObjects[i];
            if (obj instanceof ByteBlowerGuiPort) {
                ports = true;
            } else if (obj instanceof ByteBlowerPortGroup) {
                groups = true;
            }
            ++i;
        }
        if (ports && groups) {
            return null;
        }
        CompoundCommandController compound = CompoundCommandController.createInstance();
        SupportedLayer3Configuration toLayer3Configuration = this.getLayer3Configuration();
        if (ports) {
            ByteBlowerProjectController.CommandWithByteBlowerGuiPortListReference ref = this.getByteBlowerProjectController().pasteByteBlowerGuiPorts(copiedObjects, toLayer3Configuration, portPosInProject);
            compound.appendCommand(ref.getCommand());
        }
        return compound.unwrap();
    }

    private SupportedLayer3Configuration getLayer3Configuration() {
        return this.composite instanceof Ipv4PortComposite ? SupportedLayer3Configuration.IPV4 : SupportedLayer3Configuration.IPV6;
    }
}

