/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.jface.viewers.IntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.Ipv4AddressCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.MacAddressCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NetMaskCellEditor;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerUngroupAction;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAmountComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerAmountTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerBasicTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.IByteBlowerTreeViewer;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpView;
import com.excentis.products.byteblower.gui.views.port.ByteBlowerIpv4PortCellModifier;
import com.excentis.products.byteblower.gui.views.port.ConfigurationCellEditor;
import com.excentis.products.byteblower.gui.views.port.DHCPv4CellEditor;
import com.excentis.products.byteblower.gui.views.port.NatCellEditor;
import com.excentis.products.byteblower.gui.views.port.VlanStackCellEditor;
import com.excentis.products.byteblower.gui.views.port.actions.CopyPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.CutPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.DeletePortAction;
import com.excentis.products.byteblower.gui.views.port.actions.NewPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.PastePortAction;
import com.excentis.products.byteblower.gui.views.port.composites.ByteBlowerPortPopupMenu;
import com.excentis.products.byteblower.gui.views.port.composites.CaptureMenuItemInteractive;
import com.excentis.products.byteblower.gui.views.port.composites.IByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv4PortCopyDown;
import com.excentis.products.byteblower.gui.views.port.composites.PortGroupAction;
import com.excentis.products.byteblower.gui.views.port.composites.PortTreeViewer;
import com.excentis.products.byteblower.gui.views.port.composites.PortUngroupAction;
import com.excentis.products.byteblower.gui.views.port.dnd.PortTableDropAdapter;
import com.excentis.products.byteblower.gui.views.portforwarding.PortForwardingView;
import com.excentis.products.byteblower.gui.views.server.ServerView;
import com.excentis.products.byteblower.gui.views.vlan.VlanView;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;

public class Ipv4PortComposite
extends ByteBlowerAmountTreeComposite<EByteBlowerObject> {
    private static final String COLUMN_PORTNAME = Messages.getString("PortView.Column.PortName");
    private static final String COLUMN_MACADDRESS = Messages.getString("PortView.Column.MacAddress");
    private static final String COLUMN_Layer3Addresses = Messages.getString("PortView.Column.Configuration");
    private static final String COLUMN_IPADDRESS = Messages.getString("PortView.Column.IpAddress");
    private static final String COLUMN_DEFAULTGATEWAY = Messages.getString("PortView.Column.DefaultGateway");
    private static final String COLUMN_NETMASK = Messages.getString("PortView.Column.Netmask");
    private static final String COLUMN_NAT = Messages.getString("PortView.Column.Nat");
    private static final String COLUMN_VLAN = Messages.getString("PortView.Column.Vlan");
    private static final String COLUMN_MTU = Messages.getString("PortView.Column.MTU");
    private static final String COLUMN_DOCKED = Messages.getString("PortView.Column.Docked");
    private static final String[] columnNames = new String[]{COLUMN_PORTNAME, COLUMN_MACADDRESS, COLUMN_Layer3Addresses, COLUMN_IPADDRESS, COLUMN_DEFAULTGATEWAY, COLUMN_NETMASK, COLUMN_NAT, COLUMN_VLAN, COLUMN_MTU, COLUMN_DOCKED};
    private static final int[] columnWeights = new int[]{35, 25, 25, 25, 25, 25, 25, 25, 20, 20};

    public Ipv4PortComposite(Composite parent, IByteBlowerGroupAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "Ipv4PortComposite", (IByteBlowerAction)byteBlowerAction, focusDispatcher);
        this.initializeChildClass();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void doJump() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort port = (ByteBlowerGuiPort)first;
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)port);
            int currentColumn = this.getCurrentColumn();
            switch (currentColumn) {
                case 6: {
                    PortForwardingView.showAndSelect(reader.getPortForwarding());
                    break;
                }
                case 2: {
                    DhcpView.showAndSelect(reader.getDhcpv4());
                    break;
                }
                case 7: {
                    VlanStack vlanStack = reader.getVlanStack();
                    VlanView.showAndSelect(vlanStack);
                    break;
                }
                case 9: {
                    ServerView.showAndSelect(port);
                    break;
                }
            }
        }
    }

    protected CellEditor[] createCellEditors() {
        Tree tree = this.getTree();
        CellEditor[] editors = new CellEditor[columnNames.length];
        NameCellEditor nameEditor = new NameCellEditor((Composite)tree);
        editors[0] = nameEditor;
        MacAddressCellEditor macEditor = new MacAddressCellEditor((Composite)tree);
        editors[1] = macEditor;
        DHCPv4CellEditor ipv4configurationBox = new DHCPv4CellEditor(this.getTreeViewer());
        editors[2] = ipv4configurationBox;
        Ipv4AddressCellEditor ipEditor = new Ipv4AddressCellEditor((Composite)tree);
        editors[3] = ipEditor;
        ipEditor = new Ipv4AddressCellEditor((Composite)tree);
        editors[4] = ipEditor;
        NetMaskCellEditor netMaskEditor = new NetMaskCellEditor((Composite)tree);
        editors[5] = netMaskEditor;
        NatCellEditor natEditor = new NatCellEditor(this.getTreeViewer());
        editors[6] = natEditor;
        VlanStackCellEditor vlanStackEditor = new VlanStackCellEditor(this.getTreeViewer());
        editors[7] = vlanStackEditor;
        IntegerCellEditor mtuEditor = new IntegerCellEditor((Composite)tree, null, Integer.valueOf(256));
        editors[8] = mtuEditor;
        ConfigurationCellEditor configEditor = new ConfigurationCellEditor((Composite)tree);
        editors[9] = configEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new ByteBlowerIpv4PortCellModifier(this);
    }

    protected DropTargetListener getDropTargetListener() {
        return new PortTableDropAdapter((Viewer)this.getByteBlowerTreeViewer(), EByteBlowerObject.class, SupportedLayer3Configuration.IPV4);
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 10;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    protected String getTreeLabel() {
        return "IPv4 ByteBlower Ports:";
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    protected ByteBlowerFilter createViewerFilter() {
        return new ByteBlowerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ByteBlowerPortGroup) {
                    ByteBlowerPortGroup group = (ByteBlowerPortGroup)element;
                    ByteBlowerPortGroupReader reader = ReaderFactory.create((ByteBlowerPortGroup)group);
                    return reader.hasActiveIpv4Configuration();
                }
                if (element instanceof ByteBlowerGuiPort) {
                    ByteBlowerGuiPort port = (ByteBlowerGuiPort)element;
                    ByteBlowerGuiPortReaderImpl reader = new ByteBlowerGuiPortReaderImpl(port);
                    return reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV4);
                }
                return false;
            }
        };
    }

    public boolean isCopyDownEnabled() {
        ByteBlowerGuiPortReader reader = this.getFirstSelectedObjectReader();
        if (reader == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return reader.hasFixedAddress();
            }
            case 4: {
                return reader.hasFixedAddress();
            }
            case 5: {
                return reader.hasFixedAddress();
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        ByteBlowerGuiPortReader reader = this.getFirstSelectedObjectReader();
        if (reader == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return !reader.hasFixedAddress();
            }
            case 3: {
                return reader.hasFixedAddress();
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return reader.usesPortForwarding();
            }
            case 7: {
                return reader.hasValidVlanStack();
            }
            case 8: {
                return true;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        ByteBlowerGuiPortReader reader = this.getFirstSelectedObjectReader();
        if (reader == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return reader.hasFixedAddress();
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return reader.usesPortForwarding();
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public boolean isJumpEnabled() {
        ByteBlowerGuiPortReader reader = this.getFirstSelectedObjectReader();
        if (reader == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 6: {
                return reader.usesPortForwarding();
            }
            case 2: {
                return reader.getDhcpv4() != null;
            }
            case 7: {
                return reader.hasValidVlanStack();
            }
            case 9: {
                return reader.isDocked();
            }
        }
        return false;
    }

    private ByteBlowerGuiPortReader getFirstSelectedObjectReader() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort port = (ByteBlowerGuiPort)first;
            return ReaderFactory.create((ByteBlowerGuiPort)port);
        }
        return null;
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    public Class<?> getViewedClass() {
        return ByteBlowerGuiPort.class;
    }

    protected ByteBlowerNewAction<EByteBlowerObject> createNewAction() {
        return new NewPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerCutAction<EByteBlowerObject> createCutAction() {
        return new CutPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerCopyAction<EByteBlowerObject> createCopyAction() {
        return new CopyPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected TreeViewer createTreeViewer() {
        return new PortTreeViewer((ByteBlowerBasicTreeComposite<EByteBlowerObject>)this, this.getColumnNames(), this.getColumnWeights(), this.createViewerFilter());
    }

    protected ByteBlowerPasteAction<EByteBlowerObject> createPasteAction() {
        return new PastePortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerDeleteAction<EByteBlowerObject> createDeleteAction() {
        return new DeletePortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected IEObjectCopyDown<EByteBlowerObject> createCopyDownLogic() {
        return new Ipv4PortCopyDown();
    }

    public int[] getColumnWeights() {
        return columnWeights;
    }

    protected void initializeTreeChildListeners() {
    }

    protected ByteBlowerPopupMenu createPopupMenu() {
        ByteBlowerPortPopupMenu originalMenu = new ByteBlowerPortPopupMenu(this.getShell(), (IByteBlowerGroupAction)this.actionInterface, (IByteBlowerCopyDownAction)this, (IByteBlowerTreeViewer)this.getByteBlowerTreeViewer());
        Menu base = originalMenu.getMenu();
        new MenuItem(base, 2);
        new CaptureMenuItemInteractive((ByteBlowerViewerComposite<EByteBlowerObject>)this, base);
        return originalMenu;
    }

    protected ByteBlowerGroupAction<EByteBlowerObject> createGroupAction() {
        return new PortGroupAction((ByteBlowerViewerComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerUngroupAction<EByteBlowerObject> createUngroupAction() {
        return new PortUngroupAction((ByteBlowerViewerComposite<EByteBlowerObject>)this);
    }
}

