/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.jface.viewers.IntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.Ipv6AddressCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.MacAddressCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerUngroupAction;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAmountComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerAmountTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerBasicTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.IByteBlowerTreeViewer;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpView;
import com.excentis.products.byteblower.gui.views.port.ByteBlowerIpv6PortCellModifier;
import com.excentis.products.byteblower.gui.views.port.ConfigurationCellEditor;
import com.excentis.products.byteblower.gui.views.port.DHCPv6CellEditor;
import com.excentis.products.byteblower.gui.views.port.VlanStackCellEditor;
import com.excentis.products.byteblower.gui.views.port.actions.CopyPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.CutPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.DeletePortAction;
import com.excentis.products.byteblower.gui.views.port.actions.NewPortAction;
import com.excentis.products.byteblower.gui.views.port.actions.PastePortAction;
import com.excentis.products.byteblower.gui.views.port.composites.ByteBlowerPortPopupMenu;
import com.excentis.products.byteblower.gui.views.port.composites.CaptureMenuItemInteractive;
import com.excentis.products.byteblower.gui.views.port.composites.IByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv6PortCopyDown;
import com.excentis.products.byteblower.gui.views.port.composites.PortGroupAction;
import com.excentis.products.byteblower.gui.views.port.composites.PortTreeViewer;
import com.excentis.products.byteblower.gui.views.port.composites.PortUngroupAction;
import com.excentis.products.byteblower.gui.views.port.dnd.PortTableDropAdapter;
import com.excentis.products.byteblower.gui.views.server.ServerView;
import com.excentis.products.byteblower.gui.views.vlan.VlanView;
import com.excentis.products.byteblower.gui.widgets.composites.YesNoCellEditor;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;

public class Ipv6PortComposite
extends ByteBlowerAmountTreeComposite<EByteBlowerObject> {
    private static final String[] columnNames = new String[]{"Name", "MAC Address", "Configuration", "IPv6 Address", "Router Address", "Prefix Length", "Firewall", "VLAN Stack", "MTU", "Docked"};
    private static final int[] columnWeights = new int[]{35, 25, 25, 45, 45, 25, 20, 20, 25, 25};

    public Ipv6PortComposite(Composite parent, IByteBlowerAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "Ipv6PortComposite", byteBlowerAction, focusDispatcher);
        this.initializeChildClass();
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public void doJump() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort port = (ByteBlowerGuiPort)first;
            switch (this.getCurrentColumn()) {
                case 2: {
                    ByteBlowerGuiPortController controller = new ByteBlowerGuiPortController(port);
                    DhcpView.showAndSelect(controller.getDhcpv6());
                    break;
                }
                case 7: {
                    ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)port);
                    VlanStack vlanStack = reader.getVlanStack();
                    VlanView.showAndSelect(vlanStack);
                    break;
                }
                case 9: {
                    ServerView.showAndSelect(port);
                    break;
                }
            }
        }
    }

    protected String getTreeLabel() {
        return "IPv6 ByteBlower Ports:";
    }

    protected CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[columnNames.length];
        Tree table = this.getTree();
        TreeViewer treeViewer = this.getTreeViewer();
        NameCellEditor nameEditor = new NameCellEditor((Composite)table);
        editors[0] = nameEditor;
        MacAddressCellEditor macEditor = new MacAddressCellEditor((Composite)table);
        editors[1] = macEditor;
        DHCPv6CellEditor ipv6configurationBox = new DHCPv6CellEditor(treeViewer);
        editors[2] = ipv6configurationBox;
        Ipv6AddressCellEditor ipv6Editor = new Ipv6AddressCellEditor((Composite)table);
        editors[3] = ipv6Editor;
        ipv6Editor = new Ipv6AddressCellEditor((Composite)table);
        editors[4] = ipv6Editor;
        IntegerCellEditor prefixLengthEditor = new IntegerCellEditor((Composite)table, Integer.valueOf(128));
        editors[5] = prefixLengthEditor;
        ComboBoxCellEditor firewallEditor = YesNoCellEditor.build((Composite)table);
        editors[6] = firewallEditor;
        VlanStackCellEditor vlanStackEditor = new VlanStackCellEditor(treeViewer);
        editors[7] = vlanStackEditor;
        IntegerCellEditor mtuEditor = new IntegerCellEditor((Composite)table, null, Integer.valueOf(256));
        editors[8] = mtuEditor;
        ConfigurationCellEditor configEditor = new ConfigurationCellEditor((Composite)table);
        editors[9] = configEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new ByteBlowerIpv6PortCellModifier(this);
    }

    protected DropTargetListener getDropTargetListener() {
        return new PortTableDropAdapter((Viewer)this.getByteBlowerTreeViewer(), EByteBlowerObject.class, SupportedLayer3Configuration.IPV6);
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 10;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return ByteBlowerGuiPort.class;
    }

    protected ByteBlowerFilter createViewerFilter() {
        return new ByteBlowerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ByteBlowerPortGroup) {
                    ByteBlowerPortGroup group = (ByteBlowerPortGroup)element;
                    ByteBlowerPortGroupReader reader = ReaderFactory.create((ByteBlowerPortGroup)group);
                    return reader.hasActiveIpv6Configuration();
                }
                if (element instanceof ByteBlowerGuiPort) {
                    ByteBlowerGuiPort port = (ByteBlowerGuiPort)element;
                    ByteBlowerGuiPortReaderImpl reader = new ByteBlowerGuiPortReaderImpl(port);
                    return reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV6);
                }
                return false;
            }
        };
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    protected ByteBlowerNewAction<EByteBlowerObject> createNewAction() {
        return new NewPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerCutAction<EByteBlowerObject> createCutAction() {
        return new CutPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerCopyAction<EByteBlowerObject> createCopyAction() {
        return new CopyPortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected TreeViewer createTreeViewer() {
        return new PortTreeViewer((ByteBlowerBasicTreeComposite<EByteBlowerObject>)this, this.getColumnNames(), this.getColumnWeights(), this.createViewerFilter());
    }

    protected ByteBlowerPasteAction<EByteBlowerObject> createPasteAction() {
        return new PastePortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerDeleteAction<EByteBlowerObject> createDeleteAction() {
        return new DeletePortAction((IByteBlowerAmountComposite<EByteBlowerObject>)this);
    }

    protected IEObjectCopyDown<EByteBlowerObject> createCopyDownLogic() {
        return new Ipv6PortCopyDown();
    }

    public boolean isCopyDownEnabled() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)first));
            switch (this.getCurrentColumn()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return reader.hasFixedAddress();
                }
                case 4: {
                    return reader.hasFixedAddress();
                }
                case 5: {
                    return reader.hasFixedAddress();
                }
                case 6: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 9: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)first));
            switch (this.getCurrentColumn()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return reader.getDhcpv6() != null;
                }
                case 3: {
                    return reader.hasFixedAddress();
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return reader.hasValidVlanStack();
                }
                case 8: {
                    return true;
                }
                case 9: {
                    return false;
                }
            }
            return false;
        }
        if (first instanceof ByteBlowerPortGroup) {
            switch (this.getCurrentColumn()) {
                case 0: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)first));
            switch (this.getCurrentColumn()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return reader.hasFixedAddress();
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isJumpEnabled() {
        boolean enable = false;
        EByteBlowerObject first = (EByteBlowerObject)this.getFirstSelectedObject();
        if (first instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)first));
            switch (this.getCurrentColumn()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 2: {
                    enable = reader.getDhcpv6() != null;
                    break;
                }
                case 7: {
                    enable = reader.hasValidVlanStack();
                    break;
                }
                case 9: {
                    enable = reader.isDocked();
                }
            }
        }
        return enable;
    }

    public int[] getColumnWeights() {
        return columnWeights;
    }

    protected void initializeTreeChildListeners() {
    }

    protected ByteBlowerPopupMenu createPopupMenu() {
        ByteBlowerPortPopupMenu originalMenu = new ByteBlowerPortPopupMenu(this.getShell(), (IByteBlowerGroupAction)this.actionInterface, (IByteBlowerCopyDownAction)this, (IByteBlowerTreeViewer)this.getByteBlowerTreeViewer());
        Menu base = originalMenu.getMenu();
        new MenuItem(base, 2);
        new CaptureMenuItemInteractive((ByteBlowerViewerComposite<EByteBlowerObject>)this, base);
        return originalMenu;
    }

    protected ByteBlowerGroupAction<EByteBlowerObject> createGroupAction() {
        return new PortGroupAction((ByteBlowerViewerComposite<EByteBlowerObject>)this);
    }

    protected ByteBlowerUngroupAction<EByteBlowerObject> createUngroupAction() {
        return new PortUngroupAction((ByteBlowerViewerComposite<EByteBlowerObject>)this);
    }
}

