/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.EByteBlowerObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.IncrementTimeDialog;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.List;
import org.eclipse.ui.PlatformUI;

public class FlowMeasurementCopyDown
extends EByteBlowerObjectCopyDown<FlowMeasurement> {
    protected CopyDownInfo copyDownSpecial(FlowMeasurement selectedEObject, FlowMeasurement affectedEObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        switch (translator.getColumn()) {
            case 0: {
                return this.copyDownStartTime(selectedEObject, affectedEObject, copyDownInfo, operation, mode);
            }
            case 2: {
                return this.copyDownDurationTime(selectedEObject, affectedEObject, copyDownInfo, operation, mode);
            }
            case 3: {
                return this.copyDownFrameCount(selectedEObject, affectedEObject, copyDownInfo, operation, mode);
            }
        }
        return null;
    }

    private Long getAmount(ICopyDownOperation.ECopyDownMode mode, int type) {
        IncrementTimeDialog dialog = new IncrementTimeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mode, type);
        if (dialog.open() == 0) {
            return dialog.getIncrementTime().getTimeInNanoseconds();
        }
        return null;
    }

    private CopyDownInfo copyDownStartTime(FlowMeasurement selectedEObject, FlowMeasurement affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode) {
        if (copyDownInfo == null) {
            Long amount = 0L;
            if (mode == ICopyDownOperation.ECopyDownMode.increment && (amount = this.getAmount(mode, 1)) == null) {
                return new CopyDownInfo(null, null, true);
            }
            FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)selectedEObject);
            copyDownInfo = new CopyDownInfo((Object)reader.getStartTime(), (Object)amount, false);
        }
        FlowMeasurementController controller = ControllerFactory.create((FlowMeasurement)affectedEObject);
        HighResolutionCalendar oldTime = (HighResolutionCalendar)copyDownInfo.getValue();
        HighResolutionCalendar newTime = new HighResolutionCalendar(Long.valueOf(oldTime.getTimeInNanoseconds() + (Long)copyDownInfo.getAmount()));
        operation.appendCommand(controller.delayStartTime(newTime));
        copyDownInfo.setValue((Object)newTime);
        return copyDownInfo;
    }

    private CopyDownInfo copyDownDurationTime(FlowMeasurement selectedEObject, FlowMeasurement affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode) {
        CopyDownInfo stopper = new CopyDownInfo(null, null, true);
        if (copyDownInfo == null) {
            Long amount = 0L;
            if (mode != ICopyDownOperation.ECopyDownMode.normal && (amount = this.getAmount(mode, 3)) == null) {
                return stopper;
            }
            FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)selectedEObject);
            copyDownInfo = new CopyDownInfo((Object)reader.getDuration(), (Object)amount, false);
        }
        FlowMeasurementController controller = ControllerFactory.create((FlowMeasurement)affectedEObject);
        HighResolutionCalendar oldTime = (HighResolutionCalendar)copyDownInfo.getValue();
        Long durationNanos = oldTime.getTimeInNanoseconds();
        Long amount = (Long)copyDownInfo.getAmount();
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            durationNanos = durationNanos + (Long)copyDownInfo.getAmount();
        } else if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
            FrameBlastingFlowReader reader;
            if (durationNanos <= amount) {
                return stopper;
            }
            durationNanos = durationNanos - amount;
            if (controller.isFrameBlasting() && !(reader = controller.getFlowReader().getFrameBlastingFlowReader()).objectIsNull()) {
                Long frameInterval = reader.getFrameInterval().getTimeInNanoseconds();
                if (durationNanos < frameInterval) {
                    return stopper;
                }
            }
        }
        HighResolutionCalendar newTime = new HighResolutionCalendar(durationNanos);
        operation.appendCommand(controller.setDuration(newTime));
        copyDownInfo.setValue((Object)newTime);
        return copyDownInfo;
    }

    private CopyDownInfo copyDownFrameCount(FlowMeasurement selectedEObject, FlowMeasurement affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode) {
        if (mode == ICopyDownOperation.ECopyDownMode.normal) {
            FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)selectedEObject);
            return this.copyDownFrameCountIncrement(selectedEObject, affectedEObject, new CopyDownInfo((Object)reader.getNumberOfFrames(), (Object)0L, false), operation);
        }
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            return this.copyDownFrameCountIncrement(selectedEObject, affectedEObject, copyDownInfo, operation);
        }
        return null;
    }

    private CopyDownInfo copyDownFrameCountIncrement(FlowMeasurement selectedEObject, FlowMeasurement affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation) {
        Long amount = (Long)copyDownInfo.getAmount();
        if (amount == null) {
            return new CopyDownInfo(null, null, true);
        }
        FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)selectedEObject);
        Long oldFrameCount = copyDownInfo != null ? (Long)copyDownInfo.getValue() : reader.getNumberOfFrames();
        Long newFrameCount = oldFrameCount + amount;
        FlowMeasurementController affectedController = ControllerFactory.create((FlowMeasurement)affectedEObject);
        operation.appendCommand(affectedController.setNumberOfFrames(newFrameCount));
        return new CopyDownInfo((Object)newFrameCount, (Object)amount, false);
    }
}

