/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario.composites;

import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTablePopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerRunAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RunPopupMenu
extends ByteBlowerTablePopupMenu {
    private IByteBlowerRunAction runAction;
    private IByteBlowerCopyDownAction copyDownAction;
    private IByteBlowerTableViewer tableViewer;
    private static ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private static final int popupPosRun = 0;
    private static final int popupPosSep1 = 1;
    private static final int popupPosNew = 2;
    private static final int popupPosSep2 = 3;
    private static final int popupPosCut = 4;
    private static final int popupPosCopy = 5;
    private static final int popupPosPaste = 6;
    private static final int popupPosSep3 = 7;
    private static final int popupPosDel = 8;
    private static final int popupPosSep4 = 9;
    private static final int popupPosCopyDownInc = 10;
    private static final int popupPosSolution = 11;
    private ArmListener armForCopyDown;
    private ArmListener unArmForCopyDown;

    public RunPopupMenu(Shell shell, IByteBlowerAction actionInterface, IByteBlowerRunAction runInterface, IByteBlowerCopyDownAction copyDownAction, IByteBlowerTableViewer tableViewer) {
        super(shell, actionInterface, copyDownAction, tableViewer);
        this.runAction = runInterface;
        this.copyDownAction = copyDownAction;
        this.tableViewer = tableViewer;
    }

    protected void initializeMenu() {
        this.armForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                boolean enabled = ((MenuItem)e.getSource()).getEnabled();
                RunPopupMenu.this.tableViewer.hiliteCopyDownRange(enabled);
            }
        };
        this.unArmForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                RunPopupMenu.this.tableViewer.hiliteCopyDownRange(false);
            }
        };
        MenuItem item = this.createMenuItem(8, 0, false);
        item.setText("Run");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.runAction.doRun();
            }
        });
        item = new MenuItem(this.menu, 2, 1);
        item = this.createMenuItem(8, 2, false);
        item.setText("New");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.byteBlowerAction.doNew();
            }
        });
        item = new MenuItem(this.menu, 2, 3);
        item = this.createMenuItem(8, 4, false);
        item.setText("Cut");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.byteBlowerAction.doCut();
            }
        });
        item = this.createMenuItem(8, 5, false);
        item.setText("Copy");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.byteBlowerAction.doCopy();
            }
        });
        item = this.createMenuItem(8, 6, false);
        item.setText("Paste");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.byteBlowerAction.doPaste();
            }
        });
        item = new MenuItem(this.menu, 2, 7);
        item = this.createMenuItem(8, 8, false);
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.byteBlowerAction.doDelete();
            }
        });
        item = new MenuItem(this.menu, 2, 9);
        item = this.createMenuItem(8, 10, true);
        item.setText("Copy Down Incrementing");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.copyDownAction.doCopyDownInc();
            }
        });
        item = this.createMenuItem(8, 11, false);
        item.setText("Solution...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPopupMenu.this.copyDownAction.doJumpToSolution();
            }
        });
    }

    private MenuItem createMenuItem(int style, int position, boolean arm) {
        MenuItem item = new MenuItem(this.menu, style, position);
        if (arm) {
            item.addArmListener(this.armForCopyDown);
        } else {
            item.addArmListener(this.unArmForCopyDown);
        }
        return item;
    }

    private void update(MenuItem[] items) {
        boolean enable = this.runAction.isRunEnabled();
        items[0].setEnabled(enable);
        enable = this.byteBlowerAction.isNewEnabled();
        items[2].setImage(enable ? sharedImages.getImage("IMG_TOOL_NEW_WIZARD") : sharedImages.getImage("IMG_TOOL_NEW_WIZARD_DISABLED"));
        items[2].setEnabled(enable);
        enable = this.byteBlowerAction.isCutEnabled();
        items[4].setImage(enable ? sharedImages.getImage("IMG_TOOL_CUT") : sharedImages.getImage("IMG_TOOL_CUT_DISABLED"));
        items[4].setEnabled(enable);
        enable = this.byteBlowerAction.isCopyEnabled();
        items[5].setImage(enable ? sharedImages.getImage("IMG_TOOL_COPY") : sharedImages.getImage("IMG_TOOL_COPY_DISABLED"));
        items[5].setEnabled(enable);
        enable = this.byteBlowerAction.isPasteEnabled();
        items[6].setImage(enable ? sharedImages.getImage("IMG_TOOL_PASTE") : sharedImages.getImage("IMG_TOOL_PASTE_DISABLED"));
        items[6].setEnabled(enable);
        enable = this.byteBlowerAction.isDeleteEnabled();
        items[8].setImage(enable ? sharedImages.getImage("IMG_TOOL_DELETE") : sharedImages.getImage("IMG_TOOL_DELETE_DISABLED"));
        items[8].setEnabled(enable);
        items[10].setEnabled(this.copyDownAction.isCopyDownIncEnabled());
        items[11].setEnabled(this.copyDownAction.isSolutionEnabled());
    }

    protected void initializeListeners() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                RunPopupMenu.this.update(items);
            }

            public void menuHidden(MenuEvent e) {
                RunPopupMenu.this.tableViewer.hiliteCopyDownRange(false);
                super.menuHidden(e);
            }
        });
    }
}

