/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.jface.viewers.BigIntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.TimeCellEditor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.listeners.SimpleSelectionListener;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.UnFocusComboEditor;
import com.excentis.products.byteblower.gui.views.flow.FlowView;
import com.excentis.products.byteblower.gui.views.scenario.FlowMeasurementCellModifier;
import com.excentis.products.byteblower.gui.views.scenario.FlowMeasurementCopyDown;
import com.excentis.products.byteblower.gui.views.scenario.actions.CopyScenarioActionComponentAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.CutScenarioActionComponentAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.DeleteScenarioActionComponentAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.NewScenarioActionComponentAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.PasteScenarioActionComponentAction;
import com.excentis.products.byteblower.gui.views.scenario.composites.FlowMeasurementComparator;
import com.excentis.products.byteblower.gui.views.scenario.composites.ScenarioComposite;
import com.excentis.products.byteblower.gui.views.scenario.dnd.FlowMeasurementTableDropAdapter;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Measurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ScenarioActionComposite
extends ByteBlowerAmountTableComposite<FlowMeasurement> {
    private static final String[] COLUMN_NAMES = new String[]{Messages.getString("ScenarioView.Scenario.Column.StartTime"), Messages.getString("ScenarioView.Scenario.Column.Flow"), Messages.getString("ScenarioView.Scenario.Column.Duration"), Messages.getString("ScenarioView.Scenario.Column.NumberOfFrames")};
    private static final int[] COLUMN_WEIGHTS = new int[]{1, 2, 2, 2, 2};
    private static String[] flowNames = new String[]{""};
    private static HashMap<Flow, Integer> flowMap = new HashMap();

    public ScenarioActionComposite(Composite parent, IByteBlowerAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher, ScenarioComposite scenarioComposite) {
        super(parent, "ScenarioActionComposite", byteBlowerAction, focusDispatcher, (ByteBlowerModelTableComposite)scenarioComposite);
        this.initializeChildClass();
    }

    protected CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        Table table = this.getTable();
        editors[0] = new TimeCellEditor((Composite)table);
        final UnFocusComboEditor flowBox = new UnFocusComboEditor((Composite)table, flowNames, 8);
        flowBox.addParentSelectionListener((SelectionListener)new SimpleSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object value = flowBox.getValue();
                if (value instanceof Integer && ScenarioActionComposite.this.isNewFlowIndex((Integer)value)) {
                    flowBox.focusLost();
                }
            }
        });
        flowBox.setActivationStyle(1);
        editors[1] = flowBox;
        editors[2] = new TimeCellEditor((Composite)table);
        editors[3] = new BigIntegerCellEditor((Composite)table, BigInteger.ONE, null);
        return editors;
    }

    protected int[] getColumnWeights() {
        return COLUMN_WEIGHTS;
    }

    protected String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    private void updateFlowCombo() {
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ComboBoxCellEditor flowCombo;
                if (ScenarioActionComposite.this.isDisposed()) {
                    return;
                }
                if (!ByteBlowerGuiResourceController.getInstance().isOpen()) {
                    return;
                }
                Object input = ScenarioActionComposite.this.getInput();
                if (!(input instanceof Scenario)) {
                    return;
                }
                if (ScenarioActionComposite.this.getStructuredSelection().size() != 1) {
                    return;
                }
                ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
                if (project == null) {
                    return;
                }
                ArrayList availableFlows = new ArrayList(project.getFlow());
                int flowCount = availableFlows.size();
                flowNames = new String[2 + flowCount];
                ScenarioActionComposite.flowNames[0] = "";
                flowMap.clear();
                int i = 0;
                while (i < flowCount) {
                    Flow flow = (Flow)availableFlows.get(i);
                    ScenarioActionComposite.flowNames[i + 1] = flow.getName();
                    Integer index = new Integer(i + 1);
                    flowMap.put(flow, index);
                    ++i;
                }
                ScenarioActionComposite.flowNames[ScenarioActionComposite.flowNames.length - 1] = "New Flow...";
                CellEditor[] celleditors = ScenarioActionComposite.this.getCellEditors();
                if (celleditors != null && (flowCombo = (ComboBoxCellEditor)celleditors[1]) != null) {
                    flowCombo.setItems(flowNames);
                }
            }
        });
    }

    public HashMap<Flow, Integer> getFlowMap() {
        this.updateFlowCombo();
        return flowMap;
    }

    protected ICellModifier getCellModifier() {
        return new FlowMeasurementCellModifier(this);
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return Scenario.class;
    }

    public int getChildFeatureId() {
        return 4;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Measurement.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        Object currentInput;
        Scenario scenario = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            scenario = (Scenario)selection.getFirstElement();
        }
        if (scenario != (currentInput = this.getInput())) {
            this.setInput(scenario);
            this.updateWidgets();
        }
    }

    protected String getTableLabel() {
        return Messages.getString("ScenarioView.Scenario.Actions");
    }

    private FlowMeasurementReader getFlowMeasurementReader() {
        FlowMeasurement object = this.getSelectedFlowMeasurement();
        return ReaderFactory.create((FlowMeasurement)object);
    }

    private FlowMeasurement getSelectedFlowMeasurement() {
        return (FlowMeasurement)this.getFirstSelectedObject();
    }

    public boolean isCopyDownEnabled() {
        FlowMeasurement object = this.getSelectedFlowMeasurement();
        if (object != null) {
            switch (this.getCurrentColumn()) {
                case 0: {
                    return true;
                }
                case 1: {
                    FlowMeasurementReader reader = this.getFlowMeasurementReader();
                    Flow flow = reader.getFlow();
                    return flow != null;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        FlowMeasurement selectedFlowMeasurement = this.getSelectedFlowMeasurement();
        if (selectedFlowMeasurement != null) {
            switch (this.getCurrentColumn()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public void doJump() {
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getFirstSelectedObject();
        int currentColumn = this.getCurrentColumn();
        switch (currentColumn) {
            case 1: {
                Flow flow = flowMeasurement.getFlow();
                FlowView.showAndSelect(flow);
            }
        }
    }

    public boolean isJumpEnabled() {
        boolean enable = false;
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getFirstSelectedObject();
        if (flowMeasurement != null) {
            int currentColumn = this.getCurrentColumn();
            switch (currentColumn) {
                case 1: {
                    enable = flowMeasurement.getFlow() != null;
                    break;
                }
            }
        }
        return enable;
    }

    public Object getInitialInput() {
        return null;
    }

    protected IEObjectCopyDown<FlowMeasurement> createCopyDownLogic() {
        return new FlowMeasurementCopyDown();
    }

    protected ByteBlowerNewAction<FlowMeasurement> createNewAction() {
        return new NewScenarioActionComponentAction(this);
    }

    protected ByteBlowerCutAction<FlowMeasurement> createCutAction() {
        return new CutScenarioActionComponentAction(this);
    }

    protected ByteBlowerCopyAction<FlowMeasurement> createCopyAction() {
        return new CopyScenarioActionComponentAction(this);
    }

    protected ByteBlowerPasteAction<FlowMeasurement> createPasteAction() {
        return new PasteScenarioActionComponentAction(this);
    }

    protected ByteBlowerDeleteAction<FlowMeasurement> createDeleteAction() {
        return new DeleteScenarioActionComponentAction(this);
    }

    protected DropTargetListener getDropTargetListener(StructuredViewer structuredViewer) {
        Class<? extends EByteBlowerObject> dropClass = this.getViewedClass();
        return new FlowMeasurementTableDropAdapter((Viewer)structuredViewer, dropClass);
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.resetInput();
    }

    public boolean isNewFlowIndex(int idx) {
        return idx == flowNames.length - 1;
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new FlowMeasurementComparator(columnViewer);
    }

    public boolean isSolutionEnabled() {
        FlowMeasurement measurement = (FlowMeasurement)this.getFirstSelectedObject();
        Scenario scenario = measurement.getScenario();
        ScenarioReader reader = ReaderFactory.create((Scenario)scenario);
        return !reader.getAllStatuses().isEmpty();
    }
}

