/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.server.composites;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerMoveOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.dnd.ByteBlowerDropAdapter;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.TransferData;

class PortConfigTableDropAdapter
extends ByteBlowerDropAdapter
implements IAfterOperationListener {
    private IDocker docker;

    public PortConfigTableDropAdapter(Viewer viewer, Class<?> dropClass, IDocker docker) {
        super(viewer, dropClass);
        this.docker = docker;
    }

    public boolean performDrop(Object data) {
        StructuredSelection droppedData = (StructuredSelection)data;
        Object first = droppedData.getFirstElement();
        if (first instanceof DockedByteBlowerPort) {
            this.undock(droppedData);
        } else {
            this.move(droppedData);
        }
        return true;
    }

    private void undock(StructuredSelection droppedData) {
        ArrayList<DockedByteBlowerPortReader> dockedPorts = new ArrayList<DockedByteBlowerPortReader>();
        for (Object draggedObject : droppedData.toList()) {
            DockedByteBlowerPort dockedByteBlowerPort = (DockedByteBlowerPort)draggedObject;
            dockedPorts.add(ReaderFactory.create((DockedByteBlowerPort)dockedByteBlowerPort));
        }
        this.docker.setSelectedDockedPorts(dockedPorts);
        this.docker.undock();
    }

    private void move(StructuredSelection droppedData) {
        ByteBlowerGuiPort port = null;
        int localDropIndex = this.dropIndex;
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        UniqueEList list = new UniqueEList();
        try {
            for (Object draggedObject : droppedData.toList()) {
                if (draggedObject instanceof ByteBlowerGuiPort) {
                    port = (ByteBlowerGuiPort)draggedObject;
                } else if (draggedObject instanceof ByteBlowerGuiPortConfiguration) {
                    port = ((ByteBlowerGuiPortConfiguration)draggedObject).getByteBlowerGuiPort();
                }
                list.add((Object)port);
            }
        }
        catch (Exception exception) {
            localDropIndex = 0;
        }
        ByteBlowerMoveOperation operation = new ByteBlowerMoveOperation(ByteBlowerGuiResourceController.getProject(), list.size() > 1 ? "Move Ports" : "Move Port", (EObject)project, ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PROJECT__BYTE_BLOWER_GUI_PORT, (EList)list, localDropIndex);
        operation.run();
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return ByteBlowerTransfer.getInstance((Class)this.dropClass).isSupportedType(transferType) || ByteBlowerTransfer.getInstance(DockedByteBlowerPort.class).isSupportedType(transferType);
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        Viewer viewer = this.getViewer();
        if (!viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }
}

