/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.server.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.composites.server.IDockListener;
import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.composites.server.IUndockListener;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.gui.views.server.composites.DeletePortDockAction;
import com.excentis.products.byteblower.gui.views.server.composites.DockedPortsFilter;
import com.excentis.products.byteblower.gui.views.server.composites.DockedPortsTableViewer;
import com.excentis.products.byteblower.gui.views.server.composites.NewPortDockAction;
import com.excentis.products.byteblower.gui.views.server.composites.PortConfigTableDropAdapter;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class PortDockComposite
extends ByteBlowerAmountTableComposite<ByteBlowerGuiPortConfiguration>
implements IDoubleClickListener,
IUndockListener,
IDockListener {
    private Button chkHideDocked;
    private IDocker docker;
    private static final String[] columnNames = new String[]{"Name", "Docked"};
    private static final int[] columnWeights = new int[]{1, 3};
    private DockedPortsTableViewer tableViewer;

    public PortDockComposite(Composite parent, IByteBlowerAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher, IDocker docker) {
        super(parent, "PortDockComposite", byteBlowerAction, focusDispatcher);
        this.docker = docker;
        docker.addDockListener((IDockListener)this);
        docker.addUndockListener((IUndockListener)this);
        this.createHideButton();
        this.initializeChildClass();
    }

    public void viewerSelectionChanged(SelectionChangedEvent event) {
        this.docker.setSelectedByteBlowerGuiPorts(this.getSelectedByteBlowerPorts());
        super.viewerSelectionChanged(event);
    }

    protected TableViewer createTableViewer() {
        this.tableViewer = new DockedPortsTableViewer(this, this.getColumnNames(), this.getColumnWeights(), this.getViewedClass(), this.getParentClass(), this.getChildFeatureId());
        return this.tableViewer;
    }

    protected void afterInitialization() {
        this.getTableViewer().addDoubleClickListener((IDoubleClickListener)this);
        super.afterInitialization();
    }

    private void createHideButton() {
        int nofTopWidgets;
        this.chkHideDocked = new Button((Composite)this, 32);
        this.chkHideDocked.setText("Hide docked ByteBlower Ports");
        GridData synchroniseLayoutData = new GridData(768);
        synchroniseLayoutData.horizontalSpan = nofTopWidgets = this.getNofTopWidgets();
        this.chkHideDocked.setLayoutData((Object)synchroniseLayoutData);
        this.chkHideDocked.addSelectionListener((SelectionListener)this);
        this.chkHideDocked.setSelection(false);
        this.updateFilteredContent();
    }

    protected ByteBlowerFilter createViewerFilter() {
        return new DockedPortsFilter();
    }

    public void doJump() {
    }

    protected CellEditor[] createCellEditors() {
        return null;
    }

    protected ICellModifier getCellModifier() {
        return null;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerGuiPort.class;
    }

    public int getChildFeatureId() {
        return 10;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return ByteBlowerGuiPort.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    protected String getTableLabel() {
        return "ByteBlower Ports:";
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public boolean isCopyDownEnabled() {
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public boolean isJumpEnabled() {
        return false;
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    public EList<ByteBlowerGuiPortReader> getSelectedByteBlowerPorts() {
        StructuredSelection selection = this.getStructuredSelection();
        UniqueEList list = new UniqueEList();
        for (Object selected : selection.toList()) {
            if (!(selected instanceof ByteBlowerGuiPortConfiguration)) continue;
            ByteBlowerGuiPortConfigurationReader reader = ReaderFactory.create((ByteBlowerGuiPortConfiguration)((ByteBlowerGuiPortConfiguration)selected));
            list.add((Object)reader.getPortReader());
        }
        return list;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.docker.link();
    }

    public void docked(EList<ByteBlowerGuiPortReader> ports, EList<PhysicalDockable> dockables) {
        this.tableViewer.hardRefresh();
        this.tableViewer.clearSelection();
    }

    public void undocked(List<ByteBlowerGuiPortConfiguration> undockedPortConfigs) {
        this.tableViewer.hardRefresh();
        this.select(undockedPortConfigs);
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.chkHideDocked) {
            this.updateFilteredContent();
        }
        super.widgetSelected(event);
    }

    private void updateFilteredContent() {
        this.tableViewer.enableFilter(this.chkHideDocked.getSelection());
    }

    public void link(EList<ByteBlowerGuiPortReader> ports) {
    }

    protected IEObjectCopyDown<ByteBlowerGuiPortConfiguration> createCopyDownLogic() {
        return null;
    }

    protected ByteBlowerNewAction<ByteBlowerGuiPortConfiguration> createNewAction() {
        return new NewPortDockAction(this);
    }

    protected ByteBlowerCutAction<ByteBlowerGuiPortConfiguration> createCutAction() {
        return null;
    }

    protected ByteBlowerCopyAction<ByteBlowerGuiPortConfiguration> createCopyAction() {
        return null;
    }

    protected ByteBlowerPasteAction<ByteBlowerGuiPortConfiguration> createPasteAction() {
        return null;
    }

    protected ByteBlowerDeleteAction<ByteBlowerGuiPortConfiguration> createDeleteAction() {
        return new DeletePortDockAction(this);
    }

    protected void initializeDragDropSupport() {
        if (!this.supportsDragDrop()) {
            return;
        }
        Transfer[] transfer = new Transfer[]{ByteBlowerTransfer.getInstance(this.getViewedClass()), ByteBlowerTransfer.getInstance(DockedByteBlowerPort.class)};
        this.columnViewer.addDragSupport(2, transfer, this.getDragSourceListener());
        this.columnViewer.addDropSupport(2, transfer, this.getDropTargetListener());
    }

    protected DropTargetListener getDropTargetListener() {
        return new PortConfigTableDropAdapter((Viewer)this.getTableViewer(), this.getViewedClass(), this.docker);
    }

    public int[] getColumnWeights() {
        return columnWeights;
    }
}

