/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.gui.jface.viewers.CompositeCellEditor;
import com.excentis.products.byteblower.gui.swt.widgets.text.DoubleTextFactory;
import com.excentis.products.byteblower.gui.views.tcp.RateLimit;
import com.excentis.products.byteblower.model.DataRateUnit;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class RateLimitCellEditor
extends CompositeCellEditor {
    private Button checkOnOff;
    private Text txtThroughput;
    private CCombo comboUnit;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private RateLimit rateLimit;

    public RateLimitCellEditor(Composite parent) {
        super(parent);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.txtThroughput.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Object doGetValue() {
        String txt;
        Float rate = this.checkOnOff.getSelection() ? ((txt = this.txtThroughput.getText()).isEmpty() ? Float.valueOf(this.rateLimit.getThroughput()) : new Float(txt)) : new Float(0.0f);
        DataRateUnit unit = DataRateUnit.get((int)this.comboUnit.getSelectionIndex());
        return new RateLimit(rate.floatValue(), unit);
    }

    protected void doSetFocus() {
        if (this.txtThroughput != null) {
            if (this.rateLimit.isEnabled()) {
                this.txtThroughput.setFocus();
                this.txtThroughput.selectAll();
            } else {
                this.checkOnOff.setFocus();
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.txtThroughput != null && value instanceof RateLimit ? 1 : 0) != 0);
        this.rateLimit = (RateLimit)value;
        this.txtThroughput.removeModifyListener(this.getModifyListener());
        this.setValues(this.rateLimit);
        this.txtThroughput.addModifyListener(this.getModifyListener());
    }

    private void setValues(RateLimit rateLimit) {
        float throughput = rateLimit.getThroughput();
        boolean enabled = rateLimit.isEnabled();
        this.checkOnOff.setSelection(enabled);
        this.txtThroughput.setEnabled(enabled);
        this.comboUnit.setEnabled(enabled);
        if (enabled) {
            Float throughputFloat = new Float(throughput);
            this.txtThroughput.setText(throughputFloat.toString());
            this.comboUnit.select(rateLimit.getUnit().getValue());
        } else {
            this.txtThroughput.setText("100");
            this.comboUnit.select(2);
        }
    }

    private void editOccured(ModifyEvent e) {
        String value = this.txtThroughput.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = 200;
        layoutData.minimumHeight = this.itemHeight;
        return layoutData;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RateLimitCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    private void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.txtThroughput == null || this.txtThroughput.isDisposed()) {
            return false;
        }
        return this.txtThroughput.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.txtThroughput == null || this.txtThroughput.isDisposed()) {
            return false;
        }
        return this.txtThroughput.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.txtThroughput == null || this.txtThroughput.isDisposed()) {
            return false;
        }
        return this.txtThroughput.getSelectionCount() > 0 || this.txtThroughput.getCaretPosition() < this.txtThroughput.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.txtThroughput != null && !this.txtThroughput.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.txtThroughput != null && !this.txtThroughput.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.txtThroughput == null || this.txtThroughput.isDisposed()) {
            return false;
        }
        return this.txtThroughput.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.txtThroughput != null && !this.txtThroughput.isDisposed() && (this.txtThroughput.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.txtThroughput.copy();
    }

    public void performCut() {
        this.txtThroughput.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.txtThroughput.getSelectionCount() > 0) {
            this.txtThroughput.insert("");
        } else {
            int pos = this.txtThroughput.getCaretPosition();
            if (pos < this.txtThroughput.getCharCount()) {
                this.txtThroughput.setSelection(pos, pos + 1);
                this.txtThroughput.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.txtThroughput.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.txtThroughput.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return ((Object)((Object)this)).getClass() != RateLimitCellEditor.class;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected void fillComposite(Composite composite) {
        this.checkOnOff = new Button(composite, 32);
        this.txtThroughput = DoubleTextFactory.instance().create(composite, 0, 6);
        this.txtThroughput.setTextLimit(10);
        this.comboUnit = new CCombo(composite, 2124);
        DataRateUnit[] dataRateUnitArray = DataRateUnit.values();
        int n = dataRateUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataRateUnit dataRateUnit = dataRateUnitArray[n2];
            this.comboUnit.add(dataRateUnit.getName());
            ++n2;
        }
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.checkOnOff.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.txtThroughput.setSize(100, this.itemHeight);
        this.txtThroughput.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.comboUnit.setLayoutData((Object)gridData);
        this.checkOnOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean on = RateLimitCellEditor.this.checkOnOff.getSelection();
                RateLimitCellEditor.this.txtThroughput.setEnabled(on);
                RateLimitCellEditor.this.comboUnit.setEnabled(on);
            }
        });
        this.checkOnOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RateLimitCellEditor.this.txtThroughput.setFocus();
                RateLimitCellEditor.this.txtThroughput.selectAll();
            }
        });
        this.txtThroughput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RateLimitCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.txtThroughput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                RateLimitCellEditor.this.keyReleaseOccured(e);
                if (RateLimitCellEditor.this.getControl() == null || RateLimitCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                RateLimitCellEditor.this.checkSelection();
                RateLimitCellEditor.this.checkDeleteable();
                RateLimitCellEditor.this.checkSelectable();
            }
        });
        this.txtThroughput.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.txtThroughput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                RateLimitCellEditor.this.checkSelection();
                RateLimitCellEditor.this.checkDeleteable();
                RateLimitCellEditor.this.checkSelectable();
            }
        });
        this.txtThroughput.addModifyListener(this.getModifyListener());
    }
}

