/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.jface.viewers.BigIntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.BigIntegerValidator;
import com.excentis.products.byteblower.gui.jface.viewers.EditableComboBoxCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.EnumeratorCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.YesNoComboBoxCellEditor;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.tcp.PayloadCellEditor;
import com.excentis.products.byteblower.gui.views.tcp.RateLimitCellEditor;
import com.excentis.products.byteblower.gui.views.tcp.SlowStartComboBoxCellEditor;
import com.excentis.products.byteblower.gui.views.tcp.TcpCellModifier;
import com.excentis.products.byteblower.gui.views.tcp.TcpComparator;
import com.excentis.products.byteblower.gui.views.tcp.TcpCopyDown;
import com.excentis.products.byteblower.gui.views.tcp.actions.CopyTcpAction;
import com.excentis.products.byteblower.gui.views.tcp.actions.CutTcpAction;
import com.excentis.products.byteblower.gui.views.tcp.actions.DeleteTcpAction;
import com.excentis.products.byteblower.gui.views.tcp.actions.NewTcpAction;
import com.excentis.products.byteblower.gui.views.tcp.actions.PasteTcpAction;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.provider.TcpFlowItemProvider;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

class TcpComposite
extends ByteBlowerAmountTableComposite<TcpFlow> {
    private static final String[] columnNames = new String[]{Messages.getString("FlowTemplatesView.Tcp.Column.Name"), Messages.getString("FlowTemplatesView.Tcp.Column.PayloadSize"), Messages.getString("FlowTemplatesView.Tcp.Column.Limit"), Messages.getString("FlowTemplatesView.Tcp.Column.InitialReceiveWindow"), Messages.getString("FlowTemplatesView.Tcp.Column.WindowScaling"), Messages.getString("FlowTemplatesView.Tcp.Column.RcvWindowScale"), Messages.getString("FlowTemplatesView.Tcp.Column.SlowStart"), Messages.getString("FlowTemplatesView.Tcp.Column.HTTPMethod"), Messages.getString("FlowTemplatesView.Tcp.Column.L4S"), Messages.getString("FlowTemplatesView.Tcp.Column.TCPCAA"), Messages.getString("FlowTemplatesView.Tcp.Column.ClientPort"), Messages.getString("FlowTemplatesView.Tcp.Column.ServerPort")};
    private static final int[] columnWeights = new int[]{2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2};
    private static final BigInteger tcpInitialReceiveWindowMin = new BigInteger("1500");

    public TcpComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "TcpComposite", actionInterface, focusDispatcher);
        this.initializeChildClass();
    }

    protected ByteBlowerFilter createViewerFilter() {
        return new ByteBlowerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof TcpFlow;
            }
        };
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[columnNames.length];
        NameCellEditor nameEditor = new NameCellEditor((Composite)table);
        editors[0] = nameEditor;
        editors[1] = new PayloadCellEditor((Composite)table);
        editors[2] = new RateLimitCellEditor((Composite)table);
        BigIntegerCellEditor windowSizeEditor = new BigIntegerCellEditor((Composite)table, TcpFlowReader.maxPort);
        windowSizeEditor.setValidator((ICellEditorValidator)new BigIntegerValidator(tcpInitialReceiveWindowMin));
        editors[3] = windowSizeEditor;
        EnumeratorCellEditor policyEditor = new EnumeratorCellEditor((Composite)table, 8);
        policyEditor.setItems(RetransmissionPolicy.VALUES);
        editors[5] = policyEditor;
        YesNoComboBoxCellEditor scalingBox = new YesNoComboBoxCellEditor((Composite)table);
        editors[4] = scalingBox;
        ComboBoxCellEditor scaleValueBox = new ComboBoxCellEditor((Composite)table, TcpFlowItemProvider.scaleValueChoices);
        scaleValueBox.setActivationStyle(1);
        editors[5] = scaleValueBox;
        EnumeratorCellEditor httpMethodBox = new EnumeratorCellEditor((Composite)table, HTTPMethod.VALUES);
        editors[7] = httpMethodBox;
        SlowStartComboBoxCellEditor slowStartEditor = new SlowStartComboBoxCellEditor((Composite)table);
        editors[6] = slowStartEditor;
        YesNoComboBoxCellEditor l4sBox = new YesNoComboBoxCellEditor((Composite)table);
        editors[8] = l4sBox;
        ArrayList caaValues = new ArrayList(TCPCongestionAvoidanceAlgorithm.VALUES);
        caaValues.remove(TCPCongestionAvoidanceAlgorithm.SERVER_DEFAULT);
        EnumeratorCellEditor congestionAlgoBox = new EnumeratorCellEditor((Composite)table, caaValues);
        editors[9] = congestionAlgoBox;
        editors[10] = new EditableComboBoxCellEditor((Composite)table, 0, TcpFlow.portChoices, BigInteger.valueOf(0L), TcpFlowReader.maxPort);
        editors[11] = new EditableComboBoxCellEditor((Composite)table, 0, TcpFlow.portChoices, BigInteger.valueOf(0L), TcpFlowReader.maxPort);
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new TcpCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return columnWeights;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 8;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return TcpFlow.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    protected String getTableLabel() {
        return "Flow Templates:";
    }

    protected String[] getColumnNames() {
        return columnNames;
    }

    public boolean isCopyDownEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
            case 10: {
                TcpFlow selectedTcp = (TcpFlow)this.getFirstSelectedObject();
                TcpFlowReader reader = ReaderFactory.create((TcpFlow)selectedTcp);
                return !reader.hasAutomaticClientPort();
            }
            case 11: {
                TcpFlow selectedTcp = (TcpFlow)this.getFirstSelectedObject();
                TcpFlowReader reader = ReaderFactory.create((TcpFlow)selectedTcp);
                return !reader.hasAutomaticServerPort();
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public boolean isJumpEnabled() {
        return false;
    }

    public void doJump() {
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    protected ByteBlowerNewAction<TcpFlow> createNewAction() {
        return new NewTcpAction(this);
    }

    protected ByteBlowerCutAction<TcpFlow> createCutAction() {
        return new CutTcpAction(this);
    }

    protected ByteBlowerCopyAction<TcpFlow> createCopyAction() {
        return new CopyTcpAction(this);
    }

    protected ByteBlowerPasteAction<TcpFlow> createPasteAction() {
        return new PasteTcpAction(this);
    }

    protected ByteBlowerDeleteAction<TcpFlow> createDeleteAction() {
        return new DeleteTcpAction(this);
    }

    protected IEObjectCopyDown<TcpFlow> createCopyDownLogic() {
        return new TcpCopyDown();
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new TcpComparator(columnViewer);
    }
}

