/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.EByteBlowerObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.views.tcp.RateLimit;
import com.excentis.products.byteblower.gui.views.tcp.TcpPayload;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.TcpFlowController;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import java.util.List;

class TcpCopyDown
extends EByteBlowerObjectCopyDown<TcpFlow> {
    protected boolean isStopper(CopyDownInfo copyDownInfo, FeatureViewTranslator translator) {
        if (translator.getColumn() == 10 || translator.getColumn() == 11) {
            String portString = (String)copyDownInfo.getValue();
            if (portString.equals("Automatic")) {
                return false;
            }
            Integer port = Integer.valueOf(portString);
            return port > TcpFlowReader.maxPort.intValue();
        }
        return super.isStopper(copyDownInfo, translator);
    }

    protected CopyDownInfo copyDownSpecial(TcpFlow selectedEObject, TcpFlow affectedEObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        switch (translator.getColumn()) {
            case 1: {
                return this.copyDownDuration(selectedEObject, affectedEObject, copyDownInfo, operation, mode);
            }
            case 2: {
                return this.copyDownRateLimit(selectedEObject, affectedEObject, copyDownInfo, operation, mode);
            }
        }
        return null;
    }

    private CopyDownInfo copyDownDuration(TcpFlow selectedEObject, TcpFlow affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode) {
        TcpPayload tcpPayload;
        if (copyDownInfo == null) {
            Float amount = Float.valueOf(0.0f);
            tcpPayload = new TcpPayload(selectedEObject);
            copyDownInfo = new CopyDownInfo((Object)tcpPayload, (Object)amount, false);
        }
        TcpFlowController controller = ControllerFactory.create((TcpFlow)affectedEObject);
        tcpPayload = (TcpPayload)copyDownInfo.getValue();
        operation.appendCommand(controller.setPayloadSize(tcpPayload.getPayloadString()));
        operation.appendCommand(controller.setPayloadUnit(tcpPayload.getUnit()));
        copyDownInfo.setValue((Object)tcpPayload);
        return copyDownInfo;
    }

    private CopyDownInfo copyDownRateLimit(TcpFlow selectedEObject, TcpFlow affectedEObject, CopyDownInfo copyDownInfo, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode) {
        RateLimit rateLimit;
        if (copyDownInfo == null) {
            Float amount = Float.valueOf(0.0f);
            rateLimit = new RateLimit(selectedEObject);
            copyDownInfo = new CopyDownInfo((Object)rateLimit, (Object)amount, false);
        }
        TcpFlowController controller = ControllerFactory.create((TcpFlow)affectedEObject);
        rateLimit = (RateLimit)copyDownInfo.getValue();
        operation.appendCommand(controller.setRateLimit(rateLimit.getThroughput()));
        operation.appendCommand(controller.setRateLimitUnit(rateLimit.getUnit()));
        copyDownInfo.setValue((Object)rateLimit);
        return copyDownInfo;
    }
}

