/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards;

import com.excentis.products.byteblower.gui.configuration.dialogs.PhysicalConfigurationDialog;
import com.excentis.products.byteblower.gui.model.reader.ByteBlowerGuiPortGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressTextFactory_ForByteBlowerGuiPort;
import com.excentis.products.byteblower.gui.swt.widgets.text.MacAddressTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.NetmaskTextFactory;
import com.excentis.products.byteblower.gui.wizards.PortAdapter;
import com.excentis.products.byteblower.gui.wizards.PortAdapterFactory;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ByteBlowerWizardPortConfigComposite
extends Composite
implements SelectionListener,
ModifyListener {
    private Text txtName;
    private Text txtMac;
    private Button useDhcp;
    private Text txtIp;
    private Text txtGateway;
    private Text txtNetmask;
    private Text txtConfig;
    private Button btnConfig;
    private ByteBlowerGuiPortController portController;
    private boolean isSource;
    private EthernetConfigurationController ethernetConfigController;
    private Ipv4ConfigurationController ipv4ConfigController;
    private MacAddressController macAddressController;
    private PhysicalDockable dockable = null;
    private String errorMessage;
    private Dhcp dhcp = DhcpController.create((ByteBlowerProject)ByteBlowerGuiResourceController.getProject());

    public ByteBlowerWizardPortConfigComposite(Composite parent, int style, ByteBlowerGuiPort port, boolean isSource) {
        super(parent, style);
        this.portController = new ByteBlowerGuiPortController(port);
        this.ethernetConfigController = this.portController.getEthernetConfigurationController();
        this.ipv4ConfigController = this.portController.getIpv4ConfigurationController();
        this.macAddressController = this.ethernetConfigController.getMacAddressController();
        this.isSource = isSource;
        this.initialize();
        PortAdapter.addCompositeListener(this);
        PortAdapterFactory.INSTANCE.adapt((Notifier)port, PortAdapter.class);
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout());
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label((Composite)group, 0);
        if (this.isSource) {
            lblName.setText("Source Port name:");
        } else {
            lblName.setText("Destination Port name:");
        }
        this.txtName = new Text((Composite)group, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener((ModifyListener)this);
        group = new Group((Composite)this, 0);
        group.setText("Layer 2");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblMacAddress = new Label((Composite)group, 0);
        lblMacAddress.setText("MAC Address:");
        this.txtMac = MacAddressTextFactory.instance().create((Composite)group, 2048);
        this.txtMac.setLayoutData((Object)new GridData(768));
        this.txtMac.addModifyListener((ModifyListener)this);
        group = new Group((Composite)this, 0);
        group.setText("Layer 3");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        this.useDhcp = new Button((Composite)group, 32);
        this.useDhcp.setText("Use DHCP");
        this.useDhcp.addSelectionListener((SelectionListener)this);
        Label lblDummy = new Label((Composite)group, 0);
        lblDummy.setVisible(false);
        Label lblIp = new Label((Composite)group, 0);
        lblIp.setText("IP Address:");
        this.txtIp = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create((Composite)group, 2048);
        this.txtIp.setLayoutData((Object)new GridData(768));
        this.txtIp.addModifyListener((ModifyListener)this);
        Label lblGateway = new Label((Composite)group, 0);
        lblGateway.setText("Default Gateway:");
        this.txtGateway = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create((Composite)group, 2048);
        this.txtGateway.setLayoutData((Object)new GridData(768));
        this.txtGateway.addModifyListener((ModifyListener)this);
        Label lblNetmask = new Label((Composite)group, 0);
        lblNetmask.setText("Netmask:");
        this.txtNetmask = NetmaskTextFactory.instance().create((Composite)group, 2048);
        this.txtNetmask.setLayoutData((Object)new GridData(768));
        this.txtNetmask.addModifyListener((ModifyListener)this);
        group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        Label lblConfig = new Label((Composite)group, 0);
        lblConfig.setText("Physical Configuration:");
        this.txtConfig = new Text((Composite)group, 2048);
        this.txtConfig.setLayoutData((Object)new GridData(768));
        this.txtConfig.setEditable(false);
        this.btnConfig = new Button((Composite)group, 0);
        this.btnConfig.setText("...");
        this.btnConfig.addSelectionListener((SelectionListener)this);
        this.initializeValues();
    }

    private void initializeValues() {
        this.txtName.setText(this.portController.getName());
        this.txtMac.setText(this.macAddressController.getAddress());
        this.setText(this.txtIp, this.ipv4ConfigController.getAddressReader());
        this.setText(this.txtGateway, this.ipv4ConfigController.getGatewayReader());
        this.setText(this.txtNetmask, this.ipv4ConfigController.getNetmaskReader());
        this.updatePhysicalConfig();
    }

    private void setText(Text txtIp, Ipv4AddressReader reader) {
        String address = reader.getAddress();
        txtIp.setText(address);
    }

    private ByteBlowerGuiPort getPort() {
        return (ByteBlowerGuiPort)this.portController.getObject();
    }

    void updatePhysicalConfig() {
        ByteBlowerGuiPort port = this.getPort();
        ByteBlowerGuiPortGuiReader guiReader = GuiReaderFactory.create((ByteBlowerGuiPort)port);
        String dockedStatus = guiReader.getDockedStatus();
        this.txtConfig.setText(dockedStatus);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnConfig) {
            PhysicalConfigurationDialog dlg = new PhysicalConfigurationDialog(this.getShell(), this.isSource);
            if (dlg.open() == 0) {
                this.dockable = dlg.getDockable();
                ByteBlowerGuiPortConfigurationController byteblowerGuiPortConfigurationController = this.portController.getByteBlowerGuiPortConfigurationController();
                Command command = byteblowerGuiPortConfigurationController.dock(this.dockable);
                if (command != null && command.canExecute()) {
                    command.execute();
                }
                this.portController.setStatusUnknown();
            }
        } else if (e.widget == this.useDhcp) {
            boolean usedhcp = this.useDhcp.getSelection();
            this.txtIp.setEnabled(!usedhcp);
            this.txtGateway.setEnabled(!usedhcp);
            this.txtNetmask.setEnabled(!usedhcp);
            if (usedhcp) {
                this.ipv4ConfigController.setDhcp(this.dhcp).getCommand().execute();
            } else {
                this.ipv4ConfigController.setFixedAddressConfiguration().execute();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isComplete() {
        this.txtName.setForeground(null);
        ByteBlowerGuiPort port = this.getPort();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)ByteBlowerGuiResourceController.getProject(), (EObject)port, (String)port.getName())) {
            this.errorMessage = "Please enter a unique Port Name";
            this.txtName.setForeground(ColorConstants.red);
            return false;
        }
        this.txtMac.setForeground(null);
        if (!this.macAddressController.isValid()) {
            this.errorMessage = "Please enter a valid MAC Address";
            this.txtMac.setForeground(ColorConstants.red);
            return false;
        }
        this.txtIp.setForeground(null);
        this.txtGateway.setForeground(null);
        this.txtNetmask.setForeground(null);
        this.txtConfig.setForeground(null);
        if (this.ipv4ConfigController.getConfigurationType().equals((Object)Ipv4AddressConfigType.FIXED)) {
            if (!this.ipv4ConfigController.getAddressReader().isValid(false)) {
                this.errorMessage = "Please enter a valid IP Address";
                this.txtIp.setForeground(ColorConstants.red);
                return false;
            }
            if (!this.ipv4ConfigController.getGatewayReader().isValid(false)) {
                this.errorMessage = "Please enter a valid Default Gateway IP Address";
                this.txtGateway.setForeground(ColorConstants.red);
                return false;
            }
            if (!this.ipv4ConfigController.getNetmaskReader().isValid(false)) {
                this.errorMessage = "Please enter a valid Netmask";
                this.txtNetmask.setForeground(ColorConstants.red);
                return false;
            }
        }
        if (!this.portController.isDockingOk()) {
            this.txtConfig.setForeground(ColorConstants.red);
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.useDhcp.addSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.txtName.addModifyListener(listener);
        this.txtMac.addModifyListener(listener);
        this.txtIp.addModifyListener(listener);
        this.txtGateway.addModifyListener(listener);
        this.txtNetmask.addModifyListener(listener);
        this.txtConfig.addModifyListener(listener);
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        try {
            if (control.isFocusControl()) {
                if (control == this.txtName) {
                    String newName = this.txtName.getText().trim();
                    this.portController.setName(newName).execute();
                } else if (control == this.txtMac) {
                    String mac = this.txtMac.getText();
                    this.macAddressController.setAddress(mac);
                } else if (control == this.txtIp) {
                    String ip = this.txtIp.getText();
                    this.ipv4ConfigController.getAddressController().setAddress(ip);
                } else if (control == this.txtGateway) {
                    String ip = this.txtGateway.getText();
                    this.ipv4ConfigController.getGatewayController().setAddress(ip);
                } else if (control == this.txtNetmask) {
                    String ip = this.txtNetmask.getText();
                    this.ipv4ConfigController.getNetmaskController().setAddress(ip);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public PhysicalDockable getDockable() {
        return this.dockable;
    }
}

