/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.composites;

import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.wizards.composites.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class FlowConfigurationPage
extends Composite {
    private Text destinationPortText = null;
    private Text sourcePortText = null;
    private Combo protocolCombo = null;
    private Scale packetRate = null;
    private Text packetRateText = null;
    private Scale packetSize = null;
    private Text packetSizeText = null;
    private Group group = null;
    private String errorMessage;

    public FlowConfigurationPage(Composite parent, int style) {
        super(parent, 0);
        this.group = new Group((Composite)this, style);
        this.setLayout((Layout)new FillLayout());
        this.Initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
        this.group.setText(Messages.getString("FlowConfigurationPage.Title"));
    }

    private void Initialize() {
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        this.group.setLayout((Layout)layout);
        Label flowDescription = new Label((Composite)this.group, 64);
        GridData descriptionData = new GridData(64, 128, false, false);
        descriptionData.horizontalSpan = 2;
        flowDescription.setLayoutData((Object)descriptionData);
        flowDescription.setText(Messages.getString("FlowConfigurationPage.Description"));
        Label protocolLabel = new Label((Composite)this.group, 0);
        protocolLabel.setLayoutData((Object)new GridData(64, 128, false, false));
        protocolLabel.setText(Messages.getString("FlowConfigurationPage.Protocol"));
        this.protocolCombo = new Combo((Composite)this.group, 4);
        this.protocolCombo.setLayoutData((Object)new GridData(64, 128, false, false));
        this.protocolCombo.add(Messages.getString("FlowConfigurationPage.Udp"));
        this.protocolCombo.add(Messages.getString("FlowConfigurationPage.Tcp"));
        this.protocolCombo.select(0);
        Label sourcePortLabel = new Label((Composite)this.group, 0);
        sourcePortLabel.setLayoutData((Object)new GridData(64, 128, false, false));
        sourcePortLabel.setText(Messages.getString("FlowConfigurationPage.SourcePort"));
        this.sourcePortText = IntegerTextFactory.instance().create((Composite)this.group, 99999L);
        this.sourcePortText.setLayoutData((Object)new GridData(64, 128, false, false));
        this.sourcePortText.setText(Messages.getString("FlowConfigurationPage.SourcePortDefault"));
        this.sourcePortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int value = new Integer(((Text)e.widget).getText());
                    if (value > 65536) {
                        ((Text)e.widget).setText(Messages.getString("FlowConfigurationPage.PortValueMaximum"));
                    }
                    if (value < 0) {
                        ((Text)e.widget).setText(Messages.getString("FlowConfigurationPage.PortValueMinimum"));
                    }
                }
                catch (Exception exception) {}
            }
        });
        Label destinationPortLabel = new Label((Composite)this.group, 0);
        destinationPortLabel.setLayoutData((Object)new GridData(64, 128, false, false));
        destinationPortLabel.setText(Messages.getString("FlowConfigurationPage.DestinationPort"));
        this.destinationPortText = IntegerTextFactory.instance().create((Composite)this.group, 99999L);
        this.destinationPortText.setLayoutData((Object)new GridData(64, 128, false, false));
        this.destinationPortText.setText(Messages.getString("FlowConfigurationPage.DestinationPortDefault"));
        this.destinationPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int value = new Integer(((Text)e.widget).getText());
                    if (value > 65536) {
                        ((Text)e.widget).setText(Messages.getString("FlowConfigurationPage.PortValueMaximum"));
                    }
                    if (value < 0) {
                        ((Text)e.widget).setText(Messages.getString("FlowConfigurationPage.PortValueMinimum"));
                    }
                }
                catch (Exception exception) {}
            }
        });
        Label packetRateLabel = new Label((Composite)this.group, 0);
        packetRateLabel.setLayoutData((Object)new GridData(64, 128, false, false));
        packetRateLabel.setText(Messages.getString("FlowConfigurationPage.PacketRate"));
        this.packetRateText = IntegerTextFactory.instance().create((Composite)this.group, 9999L);
        this.packetRateText.setLayoutData((Object)new GridData(64, 128, false, false));
        this.packetRateText.setText(Messages.getString("FlowConfigurationPage.PacketRateDefault"));
        this.packetRateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FlowConfigurationPage.this.packetRateText.isFocusControl()) {
                    try {
                        int value = new Integer(FlowConfigurationPage.this.packetRateText.getText());
                        if (value > 1000) {
                            FlowConfigurationPage.this.packetRateText.setText(Messages.getString("FlowConfigurationPage.PacketRateMaximum"));
                            value = 1000;
                        }
                        if (value < 0) {
                            FlowConfigurationPage.this.packetRateText.setText(Messages.getString("FlowConfigurationPage.PacketRateMinimum"));
                            value = 0;
                        }
                        FlowConfigurationPage.this.packetRate.setSelection(value);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.packetRate = new Scale((Composite)this.group, 256);
        GridData scaleLayout = new GridData(4, 128, false, false);
        scaleLayout.horizontalSpan = 2;
        this.packetRate.setLayoutData((Object)scaleLayout);
        this.packetRate.setMinimum(0);
        this.packetRate.setMaximum(1000);
        this.packetRate.setSelection(100);
        this.packetRate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (FlowConfigurationPage.this.packetRate.isFocusControl()) {
                    FlowConfigurationPage.this.packetRateText.setText(String.valueOf(Messages.getString("FlowConfigurationPage.empty")) + ((Scale)event.widget).getSelection());
                }
            }
        });
        Label packetSizeLabel = new Label((Composite)this.group, 0);
        packetSizeLabel.setLayoutData((Object)new GridData(64, 128, false, false));
        packetSizeLabel.setText(Messages.getString("FlowConfigurationPage.FrameSize"));
        this.packetSizeText = IntegerTextFactory.instance().create((Composite)this.group, 99999L);
        this.packetSizeText.setLayoutData((Object)new GridData(64, 128, false, false));
        this.packetSizeText.setText(Messages.getString("FlowConfigurationPage.DefaultFrameSize"));
        this.packetSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FlowConfigurationPage.this.packetSizeText.isFocusControl()) {
                    try {
                        int value = new Integer(FlowConfigurationPage.this.packetSizeText.getText());
                        if (value > 8192) {
                            FlowConfigurationPage.this.packetSizeText.setText(Messages.getString("FlowConfigurationPage.MaximumFrameSize"));
                            value = 8192;
                        }
                        if (value < 60) {
                            FlowConfigurationPage.this.packetSizeText.setText(Messages.getString("FlowConfigurationPage.MinimumFrameSize"));
                            value = 60;
                        }
                        FlowConfigurationPage.this.packetSize.setSelection(value);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.packetSize = new Scale((Composite)this.group, 256);
        GridData sizeLayout = new GridData(4, 128, false, false);
        sizeLayout.horizontalSpan = 2;
        this.packetSize.setLayoutData((Object)sizeLayout);
        this.packetSize.setMinimum(60);
        this.packetSize.setMaximum(8192);
        this.packetSize.setSelection(128);
        this.packetSize.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (FlowConfigurationPage.this.packetSize.isFocusControl()) {
                    FlowConfigurationPage.this.packetSizeText.setText(String.valueOf(Messages.getString("FlowConfigurationPage.empty")) + ((Scale)event.widget).getSelection());
                }
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FlowConfigurationPage.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                FlowConfigurationPage.this.onDispose();
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.protocolCombo.addModifyListener(listener);
        this.sourcePortText.addModifyListener(listener);
        this.destinationPortText.addModifyListener(listener);
        this.packetRateText.addModifyListener(listener);
        this.packetSizeText.addModifyListener(listener);
    }

    public boolean isComplete() {
        if (this.sourcePortText.getText().length() > 0) {
            if (this.destinationPortText.getText().length() > 0) {
                if (this.packetRateText.getText().length() > 0) {
                    return true;
                }
                this.errorMessage = Messages.getString("FlowConfigurationPage.invalidPacketRate");
                return false;
            }
            this.errorMessage = Messages.getString("FlowConfigurationPage.invalidDestinationPort");
            return false;
        }
        this.errorMessage = Messages.getString("FlowConfigurationPage.invalidSourcePort");
        return false;
    }

    private void onResize() {
        this.group.setBounds(this.getBounds());
        ((GridData)this.sourcePortText.getLayoutData()).widthHint = this.getBounds().width / 4;
        ((GridData)this.destinationPortText.getLayoutData()).widthHint = this.getBounds().width / 4;
        ((GridData)this.packetRateText.getLayoutData()).widthHint = this.getBounds().width / 4;
        ((GridData)this.packetSizeText.getLayoutData()).widthHint = this.getBounds().width / 4;
        this.layout();
    }

    private void onDispose() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

