/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.composites;

import com.excentis.products.byteblower.gui.swt.widgets.text.MacAddressTextFactory;
import com.excentis.products.byteblower.gui.wizards.composites.Messages;
import com.excentis.products.byteblower.model.reader.impl.MacAddressReaderImpl;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class Layer2Composite
extends Composite {
    private Group group = new Group((Composite)this, 0);
    private Label l2Description = null;
    private Label macLabel = null;
    private Text macText = null;
    private String errorMessage;

    Layer2Composite(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.group.setText(Messages.getString("Layer2Composite.Title"));
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
        this.initialize();
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Layer2Composite.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                Layer2Composite.this.onDispose();
            }
        });
    }

    private void initialize() {
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 2;
        localGridlayout.marginWidth = 5;
        localGridlayout.marginHeight = 5;
        localGridlayout.horizontalSpacing = 5;
        localGridlayout.verticalSpacing = 5;
        localGridlayout.makeColumnsEqualWidth = true;
        this.group.setLayout((Layout)localGridlayout);
        this.l2Description = new Label((Composite)this.group, 64);
        GridData descriptionData = new GridData(64, 128, true, true);
        descriptionData.horizontalSpan = 2;
        this.l2Description.setLayoutData((Object)descriptionData);
        this.l2Description.setText(Messages.getString("Layer2Composite.Introduction"));
        this.macLabel = new Label((Composite)this.group, 0);
        this.macLabel.setLayoutData((Object)new GridData(4, 128, false, false));
        this.macLabel.setText(Messages.getString("Layer2Composite.Address"));
        this.macText = MacAddressTextFactory.instance().create((Composite)this.group, 2048);
        this.macText.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.macText.setText(Messages.getString("Layer2Composite.default"));
        this.layout();
    }

    private void onDispose() {
        if (this.l2Description != null) {
            this.l2Description.dispose();
        }
        if (this.macLabel != null) {
            this.macLabel.dispose();
        }
        if (this.macText != null) {
            this.macText.dispose();
        }
    }

    void addModifyListener(ModifyListener listener) {
        this.macText.addModifyListener(listener);
    }

    private void onResize() {
        this.group.setBounds(this.getBounds());
        ((GridData)this.l2Description.getLayoutData()).widthHint = this.getBounds().width - 10;
        this.layout();
    }

    public boolean isComplete() {
        if (!MacAddressReaderImpl.isComplete((String)this.macText.getText())) {
            this.errorMessage = Messages.getString("Layer2Composite.invalidValue");
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

